/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.cxf.payload;

import java.util.Collection;
import java.util.Collections;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.interceptor.AttachmentInInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;
import org.openehealth.ipf.commons.ihe.core.payload.ExpressionResolver;
import org.openehealth.ipf.commons.ihe.core.payload.SpringExpressionResolver;
import org.openehealth.ipf.commons.ihe.ws.cxf.AbstractSafeInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.InPayloadExtractorInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.StringPayloadHolder;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.WsPayloadLoggerBase;

class InPayloadLoggerInterceptor
extends AbstractSafeInterceptor {
    private final WsPayloadLoggerBase base = new WsPayloadLoggerBase();

    public InPayloadLoggerInterceptor(String fileNamePattern) {
        this((ExpressionResolver)new SpringExpressionResolver(fileNamePattern));
    }

    public InPayloadLoggerInterceptor(ExpressionResolver resolver) {
        super("receive");
        this.addAfter(AttachmentInInterceptor.class.getName());
        this.setExpressionResolver(resolver);
    }

    public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
        return Collections.singletonList(new InPayloadExtractorInterceptor(StringPayloadHolder.PayloadType.HTTP));
    }

    @Override
    public void process(SoapMessage message) {
        if (this.canProcess()) {
            this.logPayload((Message)message);
        }
    }

    public void logPayload(Message message) {
        this.base.logPayload(message);
    }

    public boolean canProcess() {
        return this.base.canProcess();
    }

    public int getErrorCountLimit() {
        return this.base.getErrorCountLimit();
    }

    public ExpressionResolver getExpressionResolver() {
        return this.base.getExpressionResolver();
    }

    public boolean isLocallyEnabled() {
        return this.base.isLocallyEnabled();
    }

    public void resetErrorCount() {
        this.base.resetErrorCount();
    }

    public void setErrorCountLimit(int arg0) {
        this.base.setErrorCountLimit(arg0);
    }

    public void setExpressionResolver(ExpressionResolver arg0) {
        this.base.setExpressionResolver(arg0);
    }

    public void setLocallyEnabled(boolean arg0) {
        this.base.setLocallyEnabled(arg0);
    }
}

