/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.cxf.payload;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.StringPayloadHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class InNamespaceMergeInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Pattern XMLNS_PATTERN = Pattern.compile("xmlns:(\\w+)=\".+?\"");

    public InNamespaceMergeInterceptor() {
        super("unmarshal");
        this.addAfter(DocLiteralInInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        String payload;
        if (this.isGET(message)) {
            return;
        }
        StringPayloadHolder payloadHolder = (StringPayloadHolder)message.getContent(StringPayloadHolder.class);
        if (payloadHolder != null && InNamespaceMergeInterceptor.isXmlContent(payload = payloadHolder.get(StringPayloadHolder.PayloadType.SOAP_BODY))) {
            Document document = (Document)message.getContent(Node.class);
            payloadHolder.put(StringPayloadHolder.PayloadType.SOAP_BODY, InNamespaceMergeInterceptor.enrichNamespaces(document, payload));
        }
    }

    private static boolean isXmlContent(String payload) {
        if (payload != null) {
            int i = 0;
            while (i < payload.length()) {
                char c = payload.charAt(i);
                if (!Character.isWhitespace(c)) {
                    return c == '<';
                }
                ++i;
            }
        }
        return false;
    }

    protected static String enrichNamespaces(Document source, String target) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        Element envelope = source.getDocumentElement();
        InNamespaceMergeInterceptor.addNamespacesFromElement(envelope, namespaces);
        Node node = envelope.getFirstChild();
        while (!(node == null || node instanceof Element && "Body".equals(node.getLocalName()))) {
            node = node.getNextSibling();
        }
        Element body = (Element)node;
        InNamespaceMergeInterceptor.addNamespacesFromElement(body, namespaces);
        if (!namespaces.isEmpty()) {
            int startPos = 0;
            int endPos = target.indexOf(62);
            while (endPos != -1 && "--".equals(target.substring(endPos - 2, endPos))) {
                startPos = endPos + 1;
                endPos = target.indexOf(62, startPos);
            }
            if (endPos == -1) {
                return target;
            }
            if (target.charAt(endPos - 1) == '/') {
                --endPos;
            }
            String startTag = target.substring(startPos, endPos);
            Matcher matcher = XMLNS_PATTERN.matcher(startTag);
            while (matcher.find()) {
                namespaces.remove(matcher.group(1));
            }
            if (!namespaces.isEmpty()) {
                StringBuilder sb = new StringBuilder(startTag);
                for (Map.Entry ns : namespaces.entrySet()) {
                    sb.append(" xmlns:").append((String)ns.getKey()).append("=\"").append((String)ns.getValue()).append('\"');
                }
                sb.append(target.substring(endPos));
                return sb.toString();
            }
        }
        return target;
    }

    protected static void addNamespacesFromElement(Element elem, Map<String, String> map) {
        NamedNodeMap attributes = elem.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            if ("http://www.w3.org/2000/xmlns/".equals(attribute.getNamespaceURI())) {
                map.put(attribute.getLocalName(), attribute.getTextContent());
            }
            ++i;
        }
    }
}

