/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.cxf.audit;

import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.ServiceInvokerInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.addressing.VersionTransformer;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.ws.correlation.AsynchronyCorrelator;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.AbstractAuditInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.WsAuditDataset;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.InPayloadInjectorInterceptor;
import org.openhealthtools.ihe.atna.auditor.codes.rfc3881.RFC3881EventCodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class AuditResponseInterceptor<T extends WsAuditDataset>
extends AbstractAuditInterceptor<T> {
    private static final transient Logger LOG = LoggerFactory.getLogger(AuditResponseInterceptor.class);
    private final AsynchronyCorrelator<T> correlator;
    private final boolean asyncReceiver;
    private final boolean serverSide;

    public AuditResponseInterceptor(AuditStrategy<T> auditStrategy, boolean serverSide, AsynchronyCorrelator<T> correlator, boolean asyncReceiver) {
        super(AuditResponseInterceptor.isClient(asyncReceiver, serverSide) ? "invoke" : "prepare-send", auditStrategy);
        if (AuditResponseInterceptor.isClient(asyncReceiver, serverSide)) {
            this.addAfter(InPayloadInjectorInterceptor.class.getName());
            this.addBefore(ServiceInvokerInterceptor.class.getName());
        }
        this.correlator = correlator;
        this.serverSide = serverSide;
        this.asyncReceiver = asyncReceiver;
    }

    private static boolean isClient(boolean asyncReceiver, boolean serverSide) {
        return asyncReceiver || !serverSide;
    }

    @Override
    protected void process(SoapMessage message) throws Exception {
        if (this.isGET((Message)message)) {
            return;
        }
        if (MessageUtils.isPartialResponse((Message)message)) {
            return;
        }
        Object response = AuditResponseInterceptor.extractPojo((Message)message);
        AuditStrategy auditStrategy = this.getAuditStrategy();
        if (!auditStrategy.isAuditableResponse(response)) {
            return;
        }
        WsAuditDataset auditDataset = null;
        if (this.asyncReceiver) {
            String messageId = null;
            for (Header header : message.getHeaders()) {
                if (!"RelatesTo".equals(header.getName().getLocalPart()) || !VersionTransformer.isSupported((String)header.getName().getNamespaceURI())) continue;
                messageId = ((Element)header.getObject()).getTextContent();
                break;
            }
            if (messageId != null) {
                auditDataset = (WsAuditDataset)((Object)this.correlator.getAuditDataset(messageId));
            } else {
                LOG.error("Cannot determine WSA message ID");
            }
        }
        if (auditDataset == null) {
            auditDataset = (WsAuditDataset)((Object)this.getAuditDataset(message));
        }
        AuditResponseInterceptor.extractUserIdFromWSAddressing(message, AuditResponseInterceptor.isClient(this.asyncReceiver, this.serverSide), this.serverSide, auditDataset);
        Exchange exchange = message.getExchange();
        if (message == exchange.getInFaultMessage() || message == exchange.getOutFaultMessage() || response == null) {
            auditDataset.setEventOutcomeCode(RFC3881EventCodes.RFC3881EventOutcomeCodes.SERIOUS_FAILURE);
        } else {
            auditStrategy.enrichAuditDatasetFromResponse(auditDataset, response);
        }
        auditStrategy.doAudit(auditDataset);
    }
}

