/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.cxf.audit;

import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.headers.Header;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.ws.WsTransactionConfiguration;
import org.openehealth.ipf.commons.ihe.ws.correlation.AsynchronyCorrelator;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.AbstractAuditInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.WsAuditDataset;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.StringPayloadHolder;

public class AuditOutRequestInterceptor<T extends WsAuditDataset>
extends AbstractAuditInterceptor<T> {
    private final AsynchronyCorrelator<T> correlator;
    private final WsTransactionConfiguration wsTransactionConfiguration;

    public AuditOutRequestInterceptor(AuditStrategy<T> auditStrategy, AsynchronyCorrelator<T> correlator, WsTransactionConfiguration wsTransactionConfiguration) {
        super("write-ending", auditStrategy);
        this.correlator = correlator;
        this.wsTransactionConfiguration = wsTransactionConfiguration;
    }

    @Override
    protected void process(SoapMessage message) throws Exception {
        if (this.isGET((Message)message)) {
            return;
        }
        Object auditDataset = this.getAuditDataset(message);
        ((WsAuditDataset)((Object)auditDataset)).setServiceEndpointUrl((String)message.get((Object)Message.ENDPOINT_ADDRESS));
        AuditOutRequestInterceptor.extractXuaUserNameFromSaml2Assertion(message, Header.Direction.DIRECTION_OUT, auditDataset);
        Object request = AuditOutRequestInterceptor.extractPojo((Message)message);
        if (this.wsTransactionConfiguration.isAuditRequestPayload()) {
            if (request instanceof String) {
                ((WsAuditDataset)((Object)auditDataset)).setRequestPayload((String)request);
            } else {
                ((WsAuditDataset)((Object)auditDataset)).setRequestPayload((StringPayloadHolder)message.getContent(StringPayloadHolder.class));
            }
        }
        this.getAuditStrategy().enrichAuditDatasetFromRequest(auditDataset, request, null);
        AddressingProperties props = (AddressingProperties)message.get((Object)"javax.xml.ws.addressing.context.outbound");
        if (props != null && (Boolean.TRUE.equals(message.getContextualProperty(AsynchronyCorrelator.FORCE_CORRELATION)) || !"http://www.w3.org/2005/08/addressing/anonymous".equals(props.getReplyTo().getAddress().getValue()))) {
            this.correlator.storeAuditDataset(props.getMessageID().getValue(), (WsAuditDataset)((Object)auditDataset));
        }
    }
}

