/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.cxf.audit;

import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.headers.Header;
import org.apache.cxf.message.Message;
import org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.ws.WsTransactionConfiguration;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.AbstractAuditInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.WsAuditDataset;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.StringPayloadHolder;

public class AuditInRequestInterceptor<T extends WsAuditDataset>
extends AbstractAuditInterceptor<T> {
    private final WsTransactionConfiguration wsTransactionConfiguration;

    public AuditInRequestInterceptor(AuditStrategy<T> auditStrategy, WsTransactionConfiguration wsTransactionConfiguration) {
        super("unmarshal", auditStrategy);
        this.addAfter(DocLiteralInInterceptor.class.getName());
        this.wsTransactionConfiguration = wsTransactionConfiguration;
    }

    @Override
    protected void process(SoapMessage message) throws Exception {
        if (this.isGET((Message)message)) {
            return;
        }
        Object auditDataset = this.getAuditDataset(message);
        AuditInRequestInterceptor.extractAddressesFromServletRequest(message, auditDataset);
        AuditInRequestInterceptor.extractXuaUserNameFromSaml2Assertion(message, Header.Direction.DIRECTION_IN, auditDataset);
        if (this.wsTransactionConfiguration.isAuditRequestPayload()) {
            ((WsAuditDataset)((Object)auditDataset)).setRequestPayload((StringPayloadHolder)message.getContent(StringPayloadHolder.class));
        }
        this.getAuditStrategy().enrichAuditDatasetFromRequest(auditDataset, AuditInRequestInterceptor.extractPojo((Message)message), null);
    }
}

