/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hpd.controls;

import java.io.IOException;
import javax.naming.ldap.SortKey;
import lombok.Generated;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openehealth.ipf.commons.ihe.hpd.controls.sorting.SortControl2;
import org.openehealth.ipf.commons.ihe.hpd.controls.sorting.SortResponseControl2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Asn1Test {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Asn1Test.class);

    @Test
    public void testSortControlParsing() throws IOException {
        Asn1Test.doTestSortControlParsing(new SortControl2(true, new SortKey[]{new SortKey("a", false, "rule1"), new SortKey("b", false, null), new SortKey("c", true, "rule2"), new SortKey("d", true, null)}));
        Asn1Test.doTestSortControlParsing(new SortControl2(true, new SortKey[0]));
    }

    private static void doTestSortControlParsing(SortControl2 original) throws IOException {
        byte[] berBytes = original.getEncodedValue();
        SortControl2 restored = new SortControl2(berBytes, true);
        log.debug(restored.toString());
        Assertions.assertEquals((Object)original, (Object)restored);
    }

    @Test
    public void testSortResponseControlRendering() throws IOException {
        Asn1Test.doTestSortResponseControlRendering(new SortResponseControl2(10, "abcd", true));
        Asn1Test.doTestSortResponseControlRendering(new SortResponseControl2(10, "", true));
        Asn1Test.doTestSortResponseControlRendering(new SortResponseControl2(10, null, true));
    }

    private static void doTestSortResponseControlRendering(SortResponseControl2 original) throws IOException {
        byte[] berBytes = original.getEncodedValue();
        SortResponseControl2 restored = new SortResponseControl2(berBytes, true);
        log.debug(restored.toString());
        Assertions.assertEquals((Object)original, (Object)restored);
    }
}

