/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hpd.controls.pagination;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.hpd.HpdException;
import org.openehealth.ipf.commons.ihe.hpd.HpdUtils;
import org.openehealth.ipf.commons.ihe.hpd.controls.ConsumerHpdHandler;
import org.openehealth.ipf.commons.ihe.hpd.controls.ControlUtils;
import org.openehealth.ipf.commons.ihe.hpd.controls.handlers.ConsumerHandler;
import org.openehealth.ipf.commons.ihe.hpd.controls.pagination.PaginationStorage;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.DsmlMessage;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ErrorResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.LDAPResult;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ResultCode;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.SearchRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.SearchResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.SearchResultEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerPaginationHandler
extends ConsumerHpdHandler {
    private static final Logger log = LoggerFactory.getLogger(ConsumerPaginationHandler.class);
    private final PaginationStorage paginationStorage;

    public ConsumerPaginationHandler(ConsumerHandler<BatchRequest, BatchResponse> wrappedHandler, PaginationStorage paginationStorage) {
        super(wrappedHandler);
        this.paginationStorage = Objects.requireNonNull(paginationStorage, "Pagination storage must be provided");
    }

    @Override
    public BatchResponse handle(BatchRequest batchRequest) {
        HashMap<String, PagedResultsResponseControl> controls = new HashMap<String, PagedResultsResponseControl>();
        JAXBElement[] localResponses = new JAXBElement[batchRequest.getBatchRequests().size()];
        for (int position = batchRequest.getBatchRequests().size() - 1; position >= 0; --position) {
            DsmlMessage request = batchRequest.getBatchRequests().get(position);
            String requestId = StringUtils.trimToNull((String)request.getRequestID());
            if (requestId == null) {
                log.warn("Request ID is missing in {} --> cannot handle, pass to the route as is", (Object)request.getClass().getSimpleName());
                continue;
            }
            if (request instanceof SearchRequest) {
                try {
                    PagedResultsResponseControl pagination = (PagedResultsResponseControl)ControlUtils.extractControl(request, "1.2.840.113556.1.4.319");
                    if (pagination == null) {
                        log.debug("No pagination control in request with ID {} --> pass it to the route", (Object)requestId);
                        continue;
                    }
                    if (pagination.getResultSize() < 1) {
                        log.debug("Non-positive page length in request with ID {} --> create error response", (Object)requestId);
                        localResponses[position] = HpdUtils.errorResponse(new HpdException("Page size must be positive", ErrorResponse.ErrorType.MALFORMED_REQUEST), requestId);
                        batchRequest.getBatchRequests().remove(position);
                        continue;
                    }
                    if (pagination.getCookie() == null) {
                        log.debug("Initial pagination control in request with ID {} --> pass it to the route and handle response", (Object)requestId);
                        controls.put(requestId, pagination);
                        continue;
                    }
                    PaginationStorage.TakeResult take = this.paginationStorage.take(pagination);
                    if (take.getEntries().isEmpty()) {
                        log.debug("Cannot serve request with ID {} from the storage --> pass it to the route", (Object)requestId);
                        continue;
                    }
                    log.debug("Serve request with ID {} from the storage", (Object)requestId);
                    SearchResponse response = new SearchResponse();
                    response.setRequestID(requestId);
                    response.getSearchResultEntry().addAll(take.getEntries());
                    response.setSearchResultDone(new LDAPResult());
                    response.getSearchResultDone().setResultCode(new ResultCode());
                    response.getSearchResultDone().getResultCode().setCode(0);
                    ControlUtils.setControl(response, (BasicControl)new PagedResultsControl(0, take.isMoreEntriesAvailable() ? pagination.getCookie() : null, true));
                    localResponses[position] = HpdUtils.DSMLV2_OBJECT_FACTORY.createBatchResponseSearchResponse(response);
                    batchRequest.getBatchRequests().remove(position);
                }
                catch (Exception e) {
                    log.error("Exception while handling request with ID {} --> create error response", (Object)requestId, (Object)e);
                    localResponses[position] = HpdUtils.errorResponse(e, requestId);
                    batchRequest.getBatchRequests().remove(position);
                }
                continue;
            }
            log.debug("Pass {} with request ID {} to the route as is", (Object)request.getClass().getSimpleName(), (Object)requestId);
        }
        if (batchRequest.getBatchRequests().isEmpty()) {
            log.debug("No requests left for processing --> send nothing to the route");
            return ConsumerPaginationHandler.aggregateResponse(batchRequest, new BatchResponse(), localResponses);
        }
        BatchResponse batchResponse = (BatchResponse)this.getWrappedHandler().handle(batchRequest);
        for (int position = batchResponse.getBatchResponses().size() - 1; position >= 0; --position) {
            JAXBElement<?> jaxbElement = batchResponse.getBatchResponses().get(position);
            Object value = jaxbElement.getValue();
            String requestId = StringUtils.trimToNull((String)HpdUtils.extractResponseRequestId(value));
            if (value instanceof SearchResponse) {
                PagedResultsResponseControl pagination;
                SearchResponse searchResponse = (SearchResponse)value;
                PagedResultsResponseControl pagedResultsResponseControl = pagination = requestId == null ? null : (PagedResultsResponseControl)controls.get(requestId);
                if (pagination == null) {
                    log.debug("No pagination was requested for request with ID {} --> return response as is", (Object)requestId);
                    continue;
                }
                try {
                    List<SearchResultEntry> entries = searchResponse.getSearchResultEntry();
                    int entriesCount = entries.size();
                    int requestedCount = pagination.getResultSize();
                    if (entriesCount <= requestedCount) {
                        log.debug("Pagination of request with ID {} finished", (Object)requestId);
                        ControlUtils.setControl(searchResponse, (BasicControl)new PagedResultsControl(0, null, true));
                        continue;
                    }
                    log.debug("For request with ID {}, return first {} entries and store {} more in the storage", new Object[]{requestId, requestedCount, entriesCount - requestedCount});
                    ArrayList<SearchResultEntry> entriesToStore = new ArrayList<SearchResultEntry>(entries.subList(requestedCount, entriesCount));
                    byte[] cookie = UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8);
                    this.paginationStorage.store(cookie, entriesToStore);
                    ArrayList<SearchResultEntry> entriesToDeliver = new ArrayList<SearchResultEntry>(entries.subList(0, requestedCount));
                    searchResponse.getSearchResultEntry().clear();
                    searchResponse.getSearchResultEntry().addAll(entriesToDeliver);
                    ControlUtils.setControl(searchResponse, (BasicControl)new PagedResultsControl(0, cookie, true));
                }
                catch (Exception e) {
                    log.error("Exception while handling response with ID {}", (Object)requestId, (Object)e);
                    batchResponse.getBatchResponses().set(position, HpdUtils.errorResponse(e, requestId));
                }
                continue;
            }
            log.debug("Return {} with request ID {} as is", (Object)value.getClass().getSimpleName(), (Object)requestId);
        }
        return ConsumerPaginationHandler.aggregateResponse(batchRequest, batchResponse, localResponses);
    }
}

