/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hpd.controls.sorting;

import java.io.IOException;
import java.util.HashMap;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.hpd.HpdUtils;
import org.openehealth.ipf.commons.ihe.hpd.controls.ConsumerHpdHandler;
import org.openehealth.ipf.commons.ihe.hpd.controls.ControlUtils;
import org.openehealth.ipf.commons.ihe.hpd.controls.handlers.ConsumerHandler;
import org.openehealth.ipf.commons.ihe.hpd.controls.sorting.SearchResponseSorter;
import org.openehealth.ipf.commons.ihe.hpd.controls.sorting.SortControl2;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.DsmlMessage;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.SearchRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerSortingHandler
extends ConsumerHpdHandler {
    private static final Logger log = LoggerFactory.getLogger(ConsumerSortingHandler.class);

    public ConsumerSortingHandler(ConsumerHandler<BatchRequest, BatchResponse> wrappedHandler) {
        super(wrappedHandler);
    }

    @Override
    public BatchResponse handle(BatchRequest batchRequest) {
        HashMap<String, SortControl2> controls = new HashMap<String, SortControl2>();
        JAXBElement[] localResponses = new JAXBElement[batchRequest.getBatchRequests().size()];
        for (int position = batchRequest.getBatchRequests().size() - 1; position >= 0; --position) {
            DsmlMessage request = batchRequest.getBatchRequests().get(position);
            String requestId = StringUtils.trimToNull((String)request.getRequestID());
            if (requestId == null) {
                log.warn("Request ID is missing in {} --> cannot handle, pass to the route as is", (Object)request.getClass().getSimpleName());
                continue;
            }
            if (request instanceof SearchRequest) {
                try {
                    SortControl2 sorting = (SortControl2)ControlUtils.extractControl(request, "1.2.840.113556.1.4.473");
                    if (sorting == null) {
                        log.debug("No sorting control in request with ID {} --> pass it to the route", (Object)requestId);
                        continue;
                    }
                    if (sorting.getKeys().length == 0) {
                        log.debug("No sorting keys specified in request with ID {} --> pass it to the route", (Object)requestId);
                        continue;
                    }
                    log.debug("Sorting control in request with ID {} --> pass it to the route and handle response", (Object)requestId);
                    controls.put(requestId, sorting);
                }
                catch (Exception e) {
                    log.error("Exception while handling request with ID {} --> create error response", (Object)requestId, (Object)e);
                    localResponses[position] = HpdUtils.errorResponse(e, requestId);
                    batchRequest.getBatchRequests().remove(position);
                }
                continue;
            }
            log.debug("Pass {} with request ID {} to the route as is", (Object)request.getClass().getSimpleName(), (Object)requestId);
        }
        BatchResponse batchResponse = (BatchResponse)this.getWrappedHandler().handle(batchRequest);
        for (int position = batchResponse.getBatchResponses().size() - 1; position >= 0; --position) {
            JAXBElement<?> jaxbElement = batchResponse.getBatchResponses().get(position);
            Object value = jaxbElement.getValue();
            String requestId = HpdUtils.extractResponseRequestId(value);
            if (value instanceof SearchResponse) {
                SortControl2 sorting;
                SearchResponse searchResponse = (SearchResponse)value;
                SortControl2 sortControl2 = sorting = requestId == null ? null : (SortControl2)controls.get(requestId);
                if (sorting == null) {
                    log.debug("No sorting was requested for request with ID {} --> return response as is", (Object)requestId);
                    continue;
                }
                try {
                    log.debug("Sort items in response with ID {}", (Object)requestId);
                    SearchResponseSorter.sort(searchResponse, sorting);
                }
                catch (IOException e) {
                    log.error("Exception while handling response with ID {}", (Object)requestId, (Object)e);
                    batchResponse.getBatchResponses().set(position, HpdUtils.errorResponse(e, requestId));
                }
                continue;
            }
            log.debug("Return {} with request ID {} as is", (Object)value.getClass().getSimpleName(), (Object)requestId);
        }
        return ConsumerSortingHandler.aggregateResponse(batchRequest, batchResponse, localResponses);
    }
}

