/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2;

import java.util.List;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchResponseElement;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ErrorResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ExtendedResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.LDAPResult;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ObjectFactory;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.SearchResponse;

public class BatchResponseIntermediary {
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private List<BatchResponseElement> batchResponses;
    private String requestID;

    public BatchResponse toBatchResponse() {
        BatchResponse batchResponse = new BatchResponse();
        batchResponse.setRequestID(this.requestID);
        if (this.batchResponses != null) {
            for (BatchResponseElement response : this.batchResponses) {
                if (response instanceof ExtendedResponse) {
                    batchResponse.getBatchResponses().add(OBJECT_FACTORY.createBatchResponseExtendedResponse((ExtendedResponse)response));
                    continue;
                }
                if (response instanceof SearchResponse) {
                    batchResponse.getBatchResponses().add(OBJECT_FACTORY.createBatchResponseSearchResponse((SearchResponse)response));
                    continue;
                }
                if (response instanceof ErrorResponse) {
                    batchResponse.getBatchResponses().add(OBJECT_FACTORY.createBatchResponseErrorResponse((ErrorResponse)response));
                    continue;
                }
                if (response instanceof LDAPResult) {
                    LDAPResult ldapResult = (LDAPResult)response;
                    switch (ldapResult.getElementName()) {
                        case "modDNResponse": {
                            batchResponse.getBatchResponses().add(OBJECT_FACTORY.createBatchResponseModDNResponse(ldapResult));
                            break;
                        }
                        case "compareResponse": {
                            batchResponse.getBatchResponses().add(OBJECT_FACTORY.createBatchResponseCompareResponse(ldapResult));
                            break;
                        }
                        case "delResponse": {
                            batchResponse.getBatchResponses().add(OBJECT_FACTORY.createBatchResponseDelResponse(ldapResult));
                            break;
                        }
                        case "modifyResponse": {
                            batchResponse.getBatchResponses().add(OBJECT_FACTORY.createBatchResponseModifyResponse(ldapResult));
                            break;
                        }
                        case "authResponse": {
                            batchResponse.getBatchResponses().add(OBJECT_FACTORY.createBatchResponseAuthResponse(ldapResult));
                            break;
                        }
                        case "addResponse": {
                            batchResponse.getBatchResponses().add(OBJECT_FACTORY.createBatchResponseAddResponse(ldapResult));
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Cannot handle LDAPResult element name " + ldapResult.getElementName());
                        }
                    }
                    continue;
                }
                throw new IllegalStateException("Cannot handle class " + response.getClass().getName());
            }
        }
        return batchResponse;
    }

    public List<BatchResponseElement> getBatchResponses() {
        return this.batchResponses;
    }

    public void setBatchResponses(List<BatchResponseElement> batchResponses) {
        this.batchResponses = batchResponses;
    }

    public String getRequestID() {
        return this.requestID;
    }

    public void setRequestID(String requestID) {
        this.requestID = requestID;
    }
}

