/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hpd.controls.sorting;

import java.io.IOException;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.SortResponseControl;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;

public class SortResponseControl2
extends BasicControl {
    private final SortResponseControl internal;

    public SortResponseControl2(byte[] berBytes, boolean criticality) throws IOException {
        super("1.2.840.113556.1.4.474", criticality, null);
        this.internal = new SortResponseControl("1.2.840.113556.1.4.474", criticality, berBytes);
    }

    public SortResponseControl2(int resultCode, String failedAttributeName, boolean criticality) throws IOException {
        this(SortResponseControl2.encode(resultCode, failedAttributeName), criticality);
    }

    @Override
    public byte[] getEncodedValue() {
        return this.internal.getEncodedValue();
    }

    public int getResultCode() {
        return this.internal.getResultCode();
    }

    public String getFailedAttributeName() {
        return this.internal.getAttributeID();
    }

    private static byte[] encode(int resultCode, String failedAttributeName) throws IOException {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)new ASN1Enumerated(resultCode));
        if (failedAttributeName != null) {
            vector.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)new DERUTF8String(failedAttributeName)));
        }
        return new DERSequence(vector).getEncoded();
    }

    public String toString() {
        return "SortResponse(" + this.getResultCode() + "; " + this.getFailedAttributeName() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortResponseControl2 that = (SortResponseControl2)o;
        return this.getResultCode() == that.getResultCode() && StringUtils.equals((CharSequence)this.getFailedAttributeName(), (CharSequence)that.getFailedAttributeName());
    }
}

