/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hpd.controls;

import java.io.IOException;
import java.util.List;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import org.apache.commons.lang3.NotImplementedException;
import org.openehealth.ipf.commons.ihe.hpd.controls.sorting.SortControl2;
import org.openehealth.ipf.commons.ihe.hpd.controls.sorting.SortResponseControl2;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.Control;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.DsmlMessage;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.SearchResponse;

public final class ControlUtils {
    public static <T extends BasicControl> T extractControl(byte[] berBytes, String type, boolean criticality) throws IOException {
        switch (type) {
            case "1.2.840.113556.1.4.319": {
                return (T)new PagedResultsResponseControl("1.2.840.113556.1.4.319", criticality, berBytes);
            }
            case "1.2.840.113556.1.4.473": {
                return (T)new SortControl2(berBytes, criticality);
            }
            case "1.2.840.113556.1.4.474": {
                return (T)new SortResponseControl2(berBytes, criticality);
            }
        }
        throw new NotImplementedException("Cannot handle control type " + type);
    }

    public static PagedResultsResponseControl convert(PagedResultsControl control) throws IOException {
        byte[] berBytes = control.getEncodedValue();
        return new PagedResultsResponseControl("1.2.840.113556.1.4.319", control.isCritical(), berBytes);
    }

    public static <T extends BasicControl> T extractControl(List<Control> controls, String type) throws IOException {
        for (Control control : controls) {
            if (!type.equals(control.getType())) continue;
            return ControlUtils.extractControl((byte[])control.getControlValue(), type, control.isCriticality());
        }
        return null;
    }

    public static <T extends BasicControl> T extractControl(SearchResponse searchResponse, String type) throws IOException {
        return searchResponse != null && searchResponse.getSearchResultDone() != null ? (T)ControlUtils.extractControl(searchResponse.getSearchResultDone().getControl(), type) : null;
    }

    public static <T extends BasicControl> T extractControl(DsmlMessage dsmlMessage, String type) throws IOException {
        return dsmlMessage != null ? (T)ControlUtils.extractControl(dsmlMessage.getControl(), type) : null;
    }

    public static Control toDsmlv2(BasicControl bc) {
        Control control = new Control();
        control.setType(bc.getID());
        control.setCriticality(bc.isCritical());
        control.setControlValue(bc.getEncodedValue());
        return control;
    }

    public static void setControl(SearchResponse response, BasicControl bc) {
        ControlUtils.setControl(response.getSearchResultDone(), bc);
    }

    public static void setControl(DsmlMessage dsmlMessage, BasicControl bc) {
        List<Control> controls = dsmlMessage.getControl();
        for (int i = 0; i < controls.size(); ++i) {
            if (!bc.getID().equals(controls.get(i).getType())) continue;
            controls.set(i, ControlUtils.toDsmlv2(bc));
            return;
        }
        controls.add(ControlUtils.toDsmlv2(bc));
    }

    private ControlUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

