/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hpd;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.core.modules.api.ValidationException;
import org.openehealth.ipf.commons.ihe.hpd.HpdException;
import org.openehealth.ipf.commons.ihe.hpd.stub.chcidd.DownloadRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.chcidd.DownloadResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.chpidd.ObjectFactory;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.AddRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.DelRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.DsmlMessage;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ErrorResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.LDAPResult;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ModifyDNRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ModifyRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.SearchRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.SearchResponse;
import org.openehealth.ipf.commons.xml.XsdValidator;

public class HpdValidator {
    public static final JAXBContext JAXB_CONTEXT;
    private static final XsdValidator XSD_VALIDATOR;
    private static final Pattern DIGITS_PATTERN;

    private static void check(boolean condition, String message) {
        if (!condition) {
            throw new HpdException(message, ErrorResponse.ErrorType.MALFORMED_REQUEST);
        }
    }

    private static void validateWithXsd(Object object, String schemaName) {
        try {
            JAXBSource source = new JAXBSource(JAXB_CONTEXT, object);
            XSD_VALIDATOR.validate((Source)source, schemaName);
        }
        catch (ValidationException e) {
            throw new HpdException((Exception)((Object)e), ErrorResponse.ErrorType.MALFORMED_REQUEST);
        }
        catch (Exception e) {
            throw new HpdException(e, ErrorResponse.ErrorType.OTHER);
        }
    }

    private static boolean isUniqueRequestId(String id, Set<String> knownIds) {
        return id != null && DIGITS_PATTERN.matcher(id).matches() && knownIds.add(id);
    }

    private static void validateBatchRequest(BatchRequest batchRequest, Class<? extends DsmlMessage>[] allowedElementTypes, Consumer<DsmlMessage> requestValidator) {
        HpdValidator.check(batchRequest.getBatchRequests() != null, "Batch request is null");
        HpdValidator.check(!batchRequest.getBatchRequests().isEmpty(), "Batch request is empty");
        HashSet<String> requestIds = new HashSet<String>();
        HpdValidator.check(HpdValidator.isUniqueRequestId(batchRequest.getRequestID(), requestIds), "Batch request ID must be a non-negative number");
        for (DsmlMessage dsml : batchRequest.getBatchRequests()) {
            HpdValidator.check(dsml != null, "Batch request element is null");
            HpdValidator.check(ArrayUtils.contains((Object[])allowedElementTypes, dsml.getClass()), "Bad batch request element type " + ClassUtils.getSimpleName((Object)dsml));
            HpdValidator.check(HpdValidator.isUniqueRequestId(dsml.getRequestID(), requestIds), "Request ID must be a non-negative number unique in the batch request");
            requestValidator.accept(dsml);
        }
    }

    private static void validateSearchRequest(SearchRequest searchRequest, String dc, String o, String c) {
        try {
            LdapName ldapName = new LdapName(searchRequest.getDn());
            for (Rdn rdn : ldapName.getRdns()) {
                String value = (String)rdn.getValue();
                switch (rdn.getType().toLowerCase()) {
                    case "dc": {
                        HpdValidator.check(dc.equalsIgnoreCase(value), "DN.DC must be equal to " + dc);
                        break;
                    }
                    case "o": {
                        if (o != null) {
                            HpdValidator.check(o.equalsIgnoreCase(value), "DN.O must be equal to " + o);
                            break;
                        }
                        HpdValidator.check(StringUtils.isNotBlank((CharSequence)value), "DN.O must be not empty");
                        break;
                    }
                    case "c": {
                        if (c != null) {
                            HpdValidator.check(c.equalsIgnoreCase(value), "DN.C must be equal to " + c);
                            break;
                        }
                        HpdValidator.check(StringUtils.isNotBlank((CharSequence)value), "DN.C must be not empty");
                    }
                }
            }
        }
        catch (InvalidNameException e) {
            throw new HpdException(e, ErrorResponse.ErrorType.MALFORMED_REQUEST);
        }
    }

    public static void validateIti58Request(BatchRequest batchRequest) {
        HpdValidator.validateWithXsd(batchRequest, "/schema/DSMLv2.xsd");
        HpdValidator.validateBatchRequest(batchRequest, new Class[]{SearchRequest.class}, element -> HpdValidator.validateSearchRequest((SearchRequest)element, "HPD", null, null));
    }

    public static void validateIti58Response(BatchResponse batchResponse) {
        HpdValidator.validateWithXsd(batchResponse, "/schema/DSMLv2.xsd");
        HashSet<String> requestIds = new HashSet<String>();
        HpdValidator.check(HpdValidator.isUniqueRequestId(batchResponse.getRequestID(), requestIds), "Batch request ID must be a non-negative number");
        for (JAXBElement<?> jaxbElement : batchResponse.getBatchResponses()) {
            String requestId;
            HpdValidator.check(jaxbElement != null, "Batch response element is null");
            Object value = jaxbElement.getValue();
            HpdValidator.check(value != null, "Batch response element is null");
            if (value instanceof LDAPResult) {
                requestId = ((LDAPResult)value).getRequestID();
            } else if (value instanceof SearchResponse) {
                requestId = ((SearchResponse)value).getRequestID();
            } else if (value instanceof ErrorResponse) {
                requestId = ((ErrorResponse)value).getRequestID();
            } else {
                throw new HpdException("Wrong response element type " + value.getClass().getSimpleName(), ErrorResponse.ErrorType.MALFORMED_REQUEST);
            }
            HpdValidator.check(HpdValidator.isUniqueRequestId(requestId, requestIds), "Request ID must be a non-negative number unique in the batch response");
        }
    }

    public static void validateIti59Request(BatchRequest batchRequest) {
        HpdValidator.validateWithXsd(batchRequest, "/schema/DSMLv2.xsd");
        HpdValidator.validateBatchRequest(batchRequest, new Class[]{AddRequest.class, ModifyRequest.class, ModifyDNRequest.class, DelRequest.class}, element -> {});
    }

    public static void validateIti59Response(BatchResponse batchResponse) {
        HpdValidator.validateWithXsd(batchResponse, "/schema/DSMLv2.xsd");
    }

    public static void validateChPiddRequest(org.openehealth.ipf.commons.ihe.hpd.stub.chpidd.DownloadRequest downloadRequest) {
        HpdValidator.validateWithXsd(downloadRequest, "/schema/PIDD.xsd");
    }

    public static void validateChPiddResponse(org.openehealth.ipf.commons.ihe.hpd.stub.chpidd.DownloadResponse downloadResponse) {
        HpdValidator.validateWithXsd(downloadResponse, "/schema/PIDD.xsd");
        if (downloadResponse.getBatchRequest() != null) {
            for (BatchRequest batchRequest : downloadResponse.getBatchRequest()) {
                HpdValidator.validateBatchRequest(batchRequest, new Class[]{AddRequest.class, ModifyRequest.class, ModifyDNRequest.class, DelRequest.class}, element -> {});
            }
        }
    }

    public static void validateChCiqRequest(BatchRequest batchRequest) {
        HpdValidator.validateWithXsd(batchRequest, "/schema/DSMLv2.xsd");
        HpdValidator.validateBatchRequest(batchRequest, new Class[]{SearchRequest.class}, element -> HpdValidator.validateSearchRequest((SearchRequest)element, "CPI", "BAG", "CH"));
    }

    public static void validateChCiqResponse(BatchResponse batchResponse) {
        HpdValidator.validateWithXsd(batchResponse, "/schema/DSMLv2.xsd");
    }

    public static void validateChCiddRequest(DownloadRequest downloadRequest) {
        HpdValidator.validateWithXsd(downloadRequest, "/schema/CIDD.xsd");
    }

    public static void validateChCiddResponse(DownloadResponse downloadResponse) {
        HpdValidator.validateWithXsd(downloadResponse, "/schema/CIDD.xsd");
        if (downloadResponse.getBatchRequest() != null) {
            for (BatchRequest batchRequest : downloadResponse.getBatchRequest()) {
                HpdValidator.validateBatchRequest(batchRequest, new Class[]{AddRequest.class, ModifyRequest.class, ModifyDNRequest.class, DelRequest.class}, element -> {});
            }
        }
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ObjectFactory.class, ObjectFactory.class, org.openehealth.ipf.commons.ihe.hpd.stub.chcidd.ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new ExceptionInInitializerError(e);
        }
        XSD_VALIDATOR = new XsdValidator();
        DIGITS_PATTERN = Pattern.compile("\\d+");
    }
}

