/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hpd;

import javax.xml.bind.JAXBElement;
import org.apache.commons.lang3.NotImplementedException;
import org.openehealth.ipf.commons.ihe.hpd.HpdException;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ErrorResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.LDAPResult;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ObjectFactory;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.SearchResponse;

public final class HpdUtils {
    public static final ObjectFactory DSMLV2_OBJECT_FACTORY = new ObjectFactory();

    public static JAXBElement<ErrorResponse> errorResponse(Exception exception, String requestId) {
        ErrorResponse error = DSMLV2_OBJECT_FACTORY.createErrorResponse();
        error.setMessage(exception.getMessage());
        error.setRequestID(requestId);
        ErrorResponse.ErrorType errorType = exception instanceof HpdException ? ((HpdException)exception).getType() : ErrorResponse.ErrorType.OTHER;
        error.setType(errorType);
        return DSMLV2_OBJECT_FACTORY.createBatchResponseErrorResponse(error);
    }

    public static String extractResponseRequestId(Object dsmlResponse) {
        if (dsmlResponse instanceof SearchResponse) {
            return ((SearchResponse)dsmlResponse).getRequestID();
        }
        if (dsmlResponse instanceof LDAPResult) {
            return ((LDAPResult)dsmlResponse).getRequestID();
        }
        if (dsmlResponse instanceof ErrorResponse) {
            return ((ErrorResponse)dsmlResponse).getRequestID();
        }
        throw new NotImplementedException("Cannot handle HPD response type " + dsmlResponse.getClass() + ", please submit a bug report");
    }

    private HpdUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

