/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hpd.iti59;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectDataLifeCycle;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCode;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategySupport;
import org.openehealth.ipf.commons.ihe.hpd.iti59.Iti59AuditDataset;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.AddRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.DelRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.DsmlMessage;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ErrorResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.LDAPResult;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ModifyDNRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ModifyRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Iti59AuditStrategy
extends AuditStrategySupport<Iti59AuditDataset> {
    private static final Logger log = LoggerFactory.getLogger(Iti59AuditStrategy.class);
    private static final Map<String, ParticipantObjectTypeCode> PARTICIPANT_OBJECT_CODE_MAP = new HashMap<String, ParticipantObjectTypeCode>();

    protected Iti59AuditStrategy(boolean serverSide) {
        super(serverSide);
    }

    public Iti59AuditDataset createAuditDataset() {
        return new Iti59AuditDataset(this.isServerSide());
    }

    private static void enrichAuditItem(Iti59AuditDataset.RequestItem item, String dn) {
        try {
            for (Rdn rdn : new LdapName(dn).getRdns()) {
                String value = (String)rdn.getValue();
                switch (rdn.getType().toLowerCase()) {
                    case "uid": {
                        item.setUid(value);
                        break;
                    }
                    case "ou": {
                        item.setParticipantObjectTypeCode(PARTICIPANT_OBJECT_CODE_MAP.get(value.toLowerCase()));
                    }
                }
            }
        }
        catch (InvalidNameException e) {
            log.debug("Cannot parse DN", (Throwable)e);
        }
    }

    public Iti59AuditDataset enrichAuditDatasetFromRequest(Iti59AuditDataset auditDataset, Object requestObject, Map<String, Object> parameters) {
        BatchRequest batchRequest = (BatchRequest)requestObject;
        if (batchRequest == null || batchRequest.getBatchRequests() == null || batchRequest.getBatchRequests().isEmpty()) {
            log.debug("Empty batch request");
            return auditDataset;
        }
        Iti59AuditDataset.RequestItem[] requestItems = new Iti59AuditDataset.RequestItem[batchRequest.getBatchRequests().size()];
        for (int i = 0; i < batchRequest.getBatchRequests().size(); ++i) {
            DsmlMessage dsmlMessage = batchRequest.getBatchRequests().get(i);
            if (dsmlMessage instanceof AddRequest) {
                AddRequest addRequest = (AddRequest)dsmlMessage;
                requestItems[i] = new Iti59AuditDataset.RequestItem(StringUtils.trimToNull((String)addRequest.getRequestID()), EventActionCode.Create);
                requestItems[i].setParticipantObjectDataLifeCycle(ParticipantObjectDataLifeCycle.Origination);
                Iti59AuditStrategy.enrichAuditItem(requestItems[i], addRequest.getDn());
                continue;
            }
            if (dsmlMessage instanceof ModifyRequest) {
                ModifyRequest modifyRequest = (ModifyRequest)dsmlMessage;
                requestItems[i] = new Iti59AuditDataset.RequestItem(StringUtils.trimToNull((String)modifyRequest.getRequestID()), EventActionCode.Update);
                requestItems[i].setParticipantObjectDataLifeCycle(ParticipantObjectDataLifeCycle.Amendment);
                Iti59AuditStrategy.enrichAuditItem(requestItems[i], modifyRequest.getDn());
                continue;
            }
            if (dsmlMessage instanceof ModifyDNRequest) {
                ModifyDNRequest modifyDNRequest = (ModifyDNRequest)dsmlMessage;
                requestItems[i] = new Iti59AuditDataset.RequestItem(StringUtils.trimToNull((String)modifyDNRequest.getRequestID()), EventActionCode.Execute);
                requestItems[i].setParticipantObjectDataLifeCycle(ParticipantObjectDataLifeCycle.Translation);
                Iti59AuditStrategy.enrichAuditItem(requestItems[i], modifyDNRequest.getDn());
                try {
                    requestItems[i].setNewUid(new LdapName(modifyDNRequest.getNewrdn()).getRdns().stream().filter(rdn -> "uid".equalsIgnoreCase(rdn.getType())).map(rdn -> (String)rdn.getValue()).findAny().orElse(null));
                }
                catch (Exception e) {
                    log.debug("Cannot parse new Rdn", (Throwable)e);
                }
                continue;
            }
            if (dsmlMessage instanceof DelRequest) {
                DelRequest delRequest = (DelRequest)dsmlMessage;
                requestItems[i] = new Iti59AuditDataset.RequestItem(StringUtils.trimToNull((String)delRequest.getRequestID()), EventActionCode.Delete);
                requestItems[i].setParticipantObjectDataLifeCycle(ParticipantObjectDataLifeCycle.PermanentErasure);
                Iti59AuditStrategy.enrichAuditItem(requestItems[i], delRequest.getDn());
                continue;
            }
            log.debug("Cannot handle ITI-59 request of type {}", (Object)ClassUtils.getShortCanonicalName((Object)dsmlMessage, (String)"<null>"));
        }
        auditDataset.setRequestItems(requestItems);
        return auditDataset;
    }

    public boolean enrichAuditDatasetFromResponse(Iti59AuditDataset auditDataset, Object responseObject, AuditContext auditContext) {
        int i;
        if (auditDataset.getRequestItems() == null) {
            log.debug("The request was empty, nothing to audit");
            return true;
        }
        BatchResponse batchResponse = (BatchResponse)responseObject;
        if (batchResponse == null || batchResponse.getBatchResponses() == null) {
            for (Iti59AuditDataset.RequestItem requestItem : auditDataset.getRequestItems()) {
                if (requestItem == null) continue;
                requestItem.setOutcomeCode(EventOutcomeIndicator.SeriousFailure);
            }
            return false;
        }
        HashMap<String, Object> byRequestId = new HashMap<String, Object>();
        Object[] byNumber = new Object[batchResponse.getBatchResponses().size()];
        for (i = 0; i < batchResponse.getBatchResponses().size(); ++i) {
            Object value = batchResponse.getBatchResponses().get(i).getValue();
            if (value instanceof LDAPResult) {
                LDAPResult ldapResult = (LDAPResult)value;
                if (StringUtils.isEmpty((CharSequence)ldapResult.getRequestID())) {
                    byNumber[i] = ldapResult;
                    continue;
                }
                byRequestId.put(ldapResult.getRequestID(), ldapResult);
                continue;
            }
            if (!(value instanceof ErrorResponse)) continue;
            ErrorResponse errorResponse = (ErrorResponse)value;
            if (StringUtils.isEmpty((CharSequence)errorResponse.getRequestID())) {
                byNumber[i] = errorResponse;
                continue;
            }
            byRequestId.put(errorResponse.getRequestID(), errorResponse);
        }
        for (i = 0; i < auditDataset.getRequestItems().length; ++i) {
            Iti59AuditDataset.RequestItem requestItem = auditDataset.getRequestItems()[i];
            if (requestItem == null) continue;
            if (StringUtils.isEmpty((CharSequence)requestItem.getRequestId())) {
                Iti59AuditStrategy.setOutcomeCode(requestItem, i < byNumber.length ? byNumber[i] : null, "Could not find response for the ID-less ITI-59 request number {}: either too few responses, or wrong type, or has a request ID", i);
                continue;
            }
            Iti59AuditStrategy.setOutcomeCode(requestItem, byRequestId.get(requestItem.getRequestId()), "Could not find response for the ITI-59 sub-request with ID '{}': either no ID match, or wrong type", requestItem.getRequestId());
        }
        return true;
    }

    private static void setOutcomeCode(Iti59AuditDataset.RequestItem requestItem, Object value, String failureLogMessage, Object ... failureLogArgs) {
        if (value instanceof LDAPResult) {
            LDAPResult ldapResult = (LDAPResult)value;
            requestItem.setOutcomeCode(ldapResult.getResultCode() != null && ldapResult.getResultCode().getCode() == 0 ? EventOutcomeIndicator.Success : EventOutcomeIndicator.SeriousFailure);
            requestItem.setOutcomeDescription(ldapResult.getErrorMessage());
        } else if (value instanceof ErrorResponse) {
            requestItem.setOutcomeCode(EventOutcomeIndicator.SeriousFailure);
            requestItem.setOutcomeDescription(((ErrorResponse)value).getMessage());
        } else {
            requestItem.setOutcomeCode(EventOutcomeIndicator.MajorFailure);
            log.debug(failureLogMessage, failureLogArgs);
        }
    }

    public AuditMessage[] makeAuditMessage(AuditContext auditContext, Iti59AuditDataset auditDataset) {
        return (AuditMessage[])Stream.of(auditDataset.getRequestItems()).filter(requestItem -> StringUtils.isNotBlank((CharSequence)requestItem.getUid())).map(requestItem -> this.makeAuditMessage(auditContext, auditDataset, (Iti59AuditDataset.RequestItem)requestItem)).toArray(AuditMessage[]::new);
    }

    protected abstract AuditMessage makeAuditMessage(AuditContext var1, Iti59AuditDataset var2, Iti59AuditDataset.RequestItem var3);

    static {
        PARTICIPANT_OBJECT_CODE_MAP.put("HCProfessional".toLowerCase(), ParticipantObjectTypeCode.Person);
        PARTICIPANT_OBJECT_CODE_MAP.put("HCRegulatedOrganization".toLowerCase(), ParticipantObjectTypeCode.Organization);
    }
}

