/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hpd.controls.sorting;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.SortControl;
import javax.naming.ldap.SortKey;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DLTaggedObject;

public class SortControl2
extends BasicControl {
    private final SortControl internal;
    private final SortKey[] keys;

    public SortControl2(boolean criticality, SortKey ... keys) throws IOException {
        super("1.2.840.113556.1.4.473", criticality, null);
        this.keys = Objects.requireNonNull(keys);
        this.internal = new SortControl(keys, criticality);
    }

    public SortControl2(byte[] berBytes, boolean criticality) throws IOException {
        this(criticality, SortControl2.decode(berBytes));
    }

    @Override
    public byte[] getEncodedValue() {
        return this.internal.getEncodedValue();
    }

    private static SortKey[] decode(byte[] berBytes) throws IOException {
        ASN1InputStream inputStream = new ASN1InputStream(berBytes);
        ASN1Sequence sequence = (ASN1Sequence)inputStream.readObject();
        SortKey[] sortKeys = new SortKey[sequence.size()];
        for (int i = 0; i < sequence.size(); ++i) {
            ASN1Sequence item = (ASN1Sequence)sequence.getObjectAt(i);
            String attributeName = SortControl2.decodeString(item.getObjectAt(0));
            String matchingRuleId = null;
            boolean ascendingOrder = true;
            for (int j = 1; j < item.size(); ++j) {
                DLTaggedObject tagged = (DLTaggedObject)item.getObjectAt(j);
                if (tagged.getTagNo() == 0) {
                    matchingRuleId = SortControl2.decodeString((ASN1Encodable)tagged.getBaseObject());
                    continue;
                }
                if (tagged.getTagNo() != 1) continue;
                ascendingOrder = SortControl2.decodeBoolean((ASN1Encodable)tagged.getBaseObject());
            }
            sortKeys[i] = new SortKey(attributeName, ascendingOrder, matchingRuleId);
        }
        return sortKeys;
    }

    private static String decodeString(ASN1Encodable asn1) {
        return StringUtils.trimToNull((String)new String(((ASN1OctetString)asn1).getOctets()));
    }

    private static boolean decodeBoolean(ASN1Encodable asn1) {
        return ((ASN1OctetString)asn1).getOctets()[0] == 0;
    }

    public String toString() {
        return "Sort(" + Arrays.stream(this.keys).map(key -> "(" + key.getAttributeID() + "; " + key.getMatchingRuleID() + "; " + key.isAscending() + ")").collect(Collectors.joining(", ")) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortControl2 that = (SortControl2)o;
        return this.toString().equals(that.toString());
    }

    public SortKey[] getKeys() {
        return this.keys;
    }
}

