/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hpd.controls.sorting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.SortKey;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.hpd.controls.ControlUtils;
import org.openehealth.ipf.commons.ihe.hpd.controls.sorting.SortControl2;
import org.openehealth.ipf.commons.ihe.hpd.controls.sorting.SortResponseControl2;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.DsmlAttr;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.SearchResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.SearchResultEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResponseSorter {
    private static final Logger log = LoggerFactory.getLogger(SearchResponseSorter.class);
    private static final String DEFAULT_MATCHING_RULE = "std";
    private static final Map<String, Comparator<String>> COMPARATORS = new HashMap<String, Comparator<String>>();

    public static void sort(SearchResponse searchResponse, SortControl2 control) throws IOException {
        Comparator comparator;
        String requestId = searchResponse.getRequestID();
        if (control.getKeys().length == 0) {
            log.debug("No sorting keys provided for response with ID {}", (Object)requestId);
            ControlUtils.setControl(searchResponse, (BasicControl)new SortResponseControl2(53, null, control.isCritical()));
            return;
        }
        if (control.getKeys().length > 1) {
            log.debug("More than one sorting key provided in response with ID {}", (Object)requestId);
            ControlUtils.setControl(searchResponse, (BasicControl)new SortResponseControl2(53, null, control.isCritical()));
            return;
        }
        SortKey key = control.getKeys()[0];
        String matchingRuleId = StringUtils.isBlank((CharSequence)key.getMatchingRuleID()) ? DEFAULT_MATCHING_RULE : key.getMatchingRuleID().trim();
        Comparator comparator0 = COMPARATORS.get(matchingRuleId);
        if (comparator0 == null) {
            log.debug("Unknown matching rule ID {} in response with ID {}", (Object)matchingRuleId, (Object)requestId);
            ControlUtils.setControl(searchResponse, (BasicControl)new SortResponseControl2(18, key.getAttributeID(), control.isCritical()));
            return;
        }
        Comparator comparator2 = comparator = key.isAscending() ? comparator0 : (s1, s2) -> -comparator0.compare(s1, s2);
        if (!key.getAttributeID().equalsIgnoreCase("dn")) {
            for (SearchResultEntry entry : searchResponse.getSearchResultEntry()) {
                DsmlAttr attr;
                ArrayList values = new ArrayList();
                Iterator<DsmlAttr> iterator = entry.getAttr().iterator();
                while (iterator.hasNext()) {
                    attr = iterator.next();
                    if (!key.getAttributeID().equalsIgnoreCase(attr.getName())) continue;
                    values.addAll(attr.getValue().stream().map(Object::toString).collect(Collectors.toList()));
                    iterator.remove();
                }
                values.sort(comparator);
                attr = new DsmlAttr();
                attr.setName(key.getAttributeID());
                attr.getValue().addAll(values);
                entry.getAttr().add(attr);
            }
        }
        searchResponse.getSearchResultEntry().sort((entry1, entry2) -> comparator.compare(SearchResponseSorter.extractAttributeValue(entry1, key.getAttributeID()), SearchResponseSorter.extractAttributeValue(entry2, key.getAttributeID())));
        ControlUtils.setControl(searchResponse, (BasicControl)new SortResponseControl2(0, null, control.isCritical()));
    }

    private static String extractAttributeValue(SearchResultEntry entry, String attributeName) {
        if (attributeName.equalsIgnoreCase("dn")) {
            return entry.getDn();
        }
        for (DsmlAttr attr : entry.getAttr()) {
            if (!attributeName.equalsIgnoreCase(attr.getName())) continue;
            return attr.getValue().isEmpty() ? null : (String)attr.getValue().get(0);
        }
        return null;
    }

    public static Map<String, Comparator<String>> getCOMPARATORS() {
        return COMPARATORS;
    }

    static {
        COMPARATORS.put(DEFAULT_MATCHING_RULE, (s1, s2) -> StringUtils.compare((String)s1, (String)s2, (boolean)true));
        COMPARATORS.put("std_i", (s1, s2) -> StringUtils.compareIgnoreCase((String)s1, (String)s2, (boolean)true));
        COMPARATORS.put("std_w", (s1, s2) -> StringUtils.compare((String)StringUtils.normalizeSpace((String)s1), (String)StringUtils.normalizeSpace((String)s2), (boolean)true));
        COMPARATORS.put("std_iw", (s1, s2) -> StringUtils.compareIgnoreCase((String)StringUtils.normalizeSpace((String)s1), (String)StringUtils.normalizeSpace((String)s2), (boolean)true));
    }
}

