/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hpd.controls.pagination;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.xml.bind.JAXBElement;
import org.openehealth.ipf.commons.ihe.hpd.HpdUtils;
import org.openehealth.ipf.commons.ihe.hpd.controls.ControlUtils;
import org.openehealth.ipf.commons.ihe.hpd.controls.handlers.ProducerHandler;
import org.openehealth.ipf.commons.ihe.hpd.controls.handlers.ProducerHandlerBase;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.DsmlMessage;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.SearchRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class ProducerPaginationHandler
extends ProducerHandlerBase<BatchRequest, BatchResponse> {
    private static final Logger log = LoggerFactory.getLogger(ProducerPaginationHandler.class);
    private final int defaultPageSize;

    public ProducerPaginationHandler(ProducerHandler<BatchRequest, BatchResponse> wrappedHandler, int defaultPageSize) {
        super(wrappedHandler);
        this.defaultPageSize = defaultPageSize;
        if (defaultPageSize < 1) {
            throw new IllegalArgumentException("Default page size must be a positive number");
        }
    }

    @Override
    public BatchResponse handle(Object client, BatchRequest batchRequest0) throws Exception {
        BatchRequest batchRequest = new BatchRequest();
        BeanUtils.copyProperties((Object)batchRequest0, (Object)batchRequest, (String[])new String[]{"batchRequests"});
        batchRequest.getBatchRequests().addAll(batchRequest0.getBatchRequests());
        HashMap<String, SearchRequest> requestMap = new HashMap<String, SearchRequest>();
        HashMap responseMap = new HashMap();
        HashMap<String, PagedResultsResponseControl> paginations = new HashMap<String, PagedResultsResponseControl>();
        log.debug("Start handling batch request with ID {}", (Object)batchRequest.getRequestID());
        for (DsmlMessage request : batchRequest.getBatchRequests()) {
            String requestId = request.getRequestID();
            if (!(request instanceof SearchRequest)) continue;
            requestMap.put(requestId, (SearchRequest)request);
            PagedResultsResponseControl pagination = (PagedResultsResponseControl)ControlUtils.extractControl(request, "1.2.840.113556.1.4.319");
            if (pagination == null) continue;
            paginations.put(requestId, pagination);
        }
        log.debug("Expect pagination for requests with IDs {}", paginations.keySet());
        block1: while (true) {
            BatchResponse batchResponse = (BatchResponse)this.getWrappedHandler().handle(client, batchRequest);
            HashSet expectedPaginationResponses = new HashSet(paginations.keySet());
            for (JAXBElement<?> jaxbElement : batchResponse.getBatchResponses()) {
                Object value = jaxbElement.getValue();
                String requestId = HpdUtils.extractResponseRequestId(value);
                expectedPaginationResponses.remove(requestId);
                if (value instanceof SearchResponse) {
                    Integer resultCode;
                    SearchResponse searchResponse = (SearchResponse)value;
                    PagedResultsResponseControl pagination = (PagedResultsResponseControl)ControlUtils.extractControl(searchResponse, "1.2.840.113556.1.4.319");
                    Integer n = resultCode = searchResponse.getSearchResultDone() != null && searchResponse.getSearchResultDone().getResultCode() != null ? Integer.valueOf(searchResponse.getSearchResultDone().getResultCode().getCode()) : null;
                    if (resultCode == null || resultCode != 0) {
                        if (paginations.containsKey(requestId)) {
                            log.debug("Got result code {} in response with ID {} --> break pagination", (Object)resultCode, (Object)requestId);
                            paginations.remove(requestId);
                        } else {
                            log.debug("Got result code {} in response with ID {} --> there was no pagination, do nothing", (Object)resultCode, (Object)requestId);
                        }
                    } else if (paginations.containsKey(requestId)) {
                        if (pagination == null) {
                            log.debug("Expected pagination control in response with ID {}, got none --> break pagination", (Object)requestId);
                            paginations.remove(requestId);
                        } else if (pagination.getCookie() == null) {
                            log.debug("Got pagination control for response with ID {} without cookie --> pagination finished", (Object)requestId);
                            paginations.remove(requestId);
                        } else {
                            log.debug("Got pagination control for response with ID {} with cookie --> request next page", (Object)requestId);
                            PagedResultsResponseControl responseControl = (PagedResultsResponseControl)paginations.get(requestId);
                            PagedResultsControl requestControl = new PagedResultsControl(responseControl.getResultSize(), pagination.getCookie(), true);
                            paginations.put(requestId, ControlUtils.convert(requestControl));
                        }
                    } else if (pagination != null) {
                        if (pagination.getCookie() == null) {
                            log.debug("Expected no pagination control in response with ID {}, got one without cookie --> do nothing", (Object)requestId);
                        } else {
                            log.debug("Expected no pagination control in response with ID {}, got one with cookie --> request next page with default page size", (Object)requestId);
                            PagedResultsControl requestControl = new PagedResultsControl(this.defaultPageSize, pagination.getCookie(), true);
                            paginations.put(requestId, ControlUtils.convert(requestControl));
                        }
                    } else {
                        log.debug("Expected no pagination control in response with ID {}, got none --> do nothing", (Object)requestId);
                    }
                    if (responseMap.containsKey(requestId)) {
                        SearchResponse oldSearchResponse = (SearchResponse)((JAXBElement)responseMap.get(requestId)).getValue();
                        searchResponse.getSearchResultEntry().addAll(0, oldSearchResponse.getSearchResultEntry());
                    }
                } else if (paginations.containsKey(requestId)) {
                    log.debug("Got {} instead of SearchResponse for request with ID {} --> pagination not applicable", (Object)value.getClass().getSimpleName(), (Object)requestId);
                    paginations.remove(requestId);
                } else {
                    log.debug("Got {} for request with ID {} --> do nothing", (Object)value.getClass().getSimpleName(), (Object)requestId);
                }
                responseMap.put(requestId, jaxbElement);
            }
            if (!expectedPaginationResponses.isEmpty()) {
                log.debug("Did not get responses for requests {} --> exclude them from pagination", expectedPaginationResponses);
                expectedPaginationResponses.forEach(paginations::remove);
            }
            if (paginations.isEmpty()) {
                log.debug("Finished handling batch request with ID {}", (Object)batchRequest.getRequestID());
                batchResponse.getBatchResponses().clear();
                batchResponse.getBatchResponses().addAll(responseMap.values());
                return batchResponse;
            }
            log.debug("Create pagination request for request IDs {}", paginations.keySet());
            batchRequest.getBatchRequests().clear();
            Iterator<Object> iterator = paginations.entrySet().iterator();
            while (true) {
                if (!iterator.hasNext()) continue block1;
                Map.Entry entry = (Map.Entry)iterator.next();
                SearchRequest searchRequest = (SearchRequest)requestMap.get(entry.getKey());
                ControlUtils.setControl(searchRequest, (BasicControl)entry.getValue());
                batchRequest.getBatchRequests().add(searchRequest);
            }
            break;
        }
    }
}

