/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hpd.controls.pagination;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.cache.Cache;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.openehealth.ipf.commons.ihe.hpd.controls.pagination.PaginationStorage;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ObjectFactory;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.SearchResultEntry;
import org.openehealth.ipf.commons.xml.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcachePaginationStorage
implements PaginationStorage {
    private static final Logger log = LoggerFactory.getLogger(EhcachePaginationStorage.class);
    private static final JAXBContext JAXB_CONTEXT;
    private final Cache<String, Object> cache;
    private final boolean needSerialization;

    public EhcachePaginationStorage(Cache<String, Object> cache, boolean needSerialization) {
        this.cache = Objects.requireNonNull(cache);
        this.needSerialization = needSerialization;
    }

    @Override
    public void store(byte[] cookie, List<SearchResultEntry> entries) {
        log.debug("Store {} entries for cookie with hash {}", (Object)entries.size(), (Object)Arrays.hashCode(cookie));
        if (this.needSerialization) {
            Container container = new Container(entries);
            String value = XmlUtils.renderJaxb((JAXBContext)JAXB_CONTEXT, (Object)container, (Boolean)false);
            this.cache.put((Object)new String(cookie), (Object)value);
        } else {
            this.cache.put((Object)new String(cookie), entries);
        }
    }

    @Override
    public PaginationStorage.TakeResult take(PagedResultsResponseControl pagination) throws Exception {
        List<SearchResultEntry> entries;
        byte[] cookie = pagination.getCookie();
        Object value = this.cache.get((Object)new String(cookie));
        if (value == null) {
            log.debug("No entries for cookie with hash {}", (Object)Arrays.hashCode(cookie));
            return new PaginationStorage.TakeResult(null, false);
        }
        if (this.needSerialization) {
            Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
            Container container = (Container)unmarshaller.unmarshal(XmlUtils.source((String)((String)value)));
            entries = container.entries;
        } else {
            entries = (List<SearchResultEntry>)value;
        }
        int entriesCount = entries.size();
        int requestedCount = pagination.getResultSize();
        if (entriesCount > requestedCount) {
            log.debug("Return {} entries for cookie with hash {}, let {} in the storage", new Object[]{requestedCount, Arrays.hashCode(cookie), entries.size() - requestedCount});
            ArrayList<SearchResultEntry> entriesToStore = new ArrayList<SearchResultEntry>(entries.subList(requestedCount, entriesCount));
            this.store(cookie, entriesToStore);
            ArrayList<SearchResultEntry> entriesToDeliver = new ArrayList<SearchResultEntry>(entries.subList(0, requestedCount));
            return new PaginationStorage.TakeResult(entriesToDeliver, true);
        }
        log.debug("Return {} last entries for cookie with hash {} and delete the cache", (Object)entriesCount, (Object)Arrays.hashCode(cookie));
        this.cache.remove((Object)new String(cookie));
        return new PaginationStorage.TakeResult(entries, false);
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class, Container.class});
        }
        catch (JAXBException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @XmlRootElement
    private static class Container {
        @XmlElement(name="entry")
        public List<SearchResultEntry> entries;

        public Container() {
        }

        public Container(List<SearchResultEntry> entries) {
            this.entries = entries;
        }
    }
}

