/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hpd;

import java.util.function.Consumer;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.core.modules.api.ValidationException;
import org.openehealth.ipf.commons.ihe.hpd.HpdException;
import org.openehealth.ipf.commons.ihe.hpd.stub.chcidd.DownloadRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.chcidd.DownloadResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.chpidd.ObjectFactory;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.AddRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.DelRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.DsmlMessage;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ErrorResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ModifyDNRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ModifyRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.SearchRequest;
import org.openehealth.ipf.commons.xml.XsdValidator;

public class HpdValidator {
    public static final JAXBContext JAXB_CONTEXT;
    private static final XsdValidator XSD_VALIDATOR;

    private static void check(boolean condition, String message) {
        if (!condition) {
            throw new HpdException(message, ErrorResponse.ErrorType.MALFORMED_REQUEST);
        }
    }

    private static void validateWithXsd(Object object, String schemaName) {
        try {
            JAXBSource source = new JAXBSource(JAXB_CONTEXT, object);
            XSD_VALIDATOR.validate((Source)source, schemaName);
        }
        catch (ValidationException e) {
            throw new HpdException((Exception)((Object)e), ErrorResponse.ErrorType.MALFORMED_REQUEST);
        }
        catch (Exception e) {
            throw new HpdException(e, ErrorResponse.ErrorType.OTHER);
        }
    }

    private static void validateBatchRequest(BatchRequest batch, Class<? extends DsmlMessage>[] allowedElementTypes, Consumer<DsmlMessage> requestValidator) {
        HpdValidator.check(batch.getBatchRequests() != null, "Batch is null");
        HpdValidator.check(!batch.getBatchRequests().isEmpty(), "Batch is empty");
        for (DsmlMessage dsml : batch.getBatchRequests()) {
            HpdValidator.check(dsml != null, "Batch element is null");
            HpdValidator.check(ArrayUtils.contains((Object[])allowedElementTypes, dsml.getClass()), "Bad batch element type " + ClassUtils.getSimpleName((Object)dsml));
            requestValidator.accept(dsml);
        }
    }

    private static void validateSearchRequest(SearchRequest request, String dc, String o, String c) {
        try {
            LdapName ldapName = new LdapName(request.getDn());
            for (Rdn rdn : ldapName.getRdns()) {
                String value = (String)rdn.getValue();
                switch (rdn.getType().toLowerCase()) {
                    case "dc": {
                        HpdValidator.check(dc.equalsIgnoreCase(value), "DN.DC must be equal to " + dc);
                        break;
                    }
                    case "o": {
                        if (o != null) {
                            HpdValidator.check(o.equalsIgnoreCase(value), "DN.O must be equal to " + o);
                            break;
                        }
                        HpdValidator.check(StringUtils.isNotBlank((CharSequence)value), "DN.O must be not empty");
                        break;
                    }
                    case "c": {
                        if (c != null) {
                            HpdValidator.check(c.equalsIgnoreCase(value), "DN.C must be equal to " + c);
                            break;
                        }
                        HpdValidator.check(StringUtils.isNotBlank((CharSequence)value), "DN.C must be not empty");
                    }
                }
            }
        }
        catch (InvalidNameException e) {
            throw new HpdException(e, ErrorResponse.ErrorType.MALFORMED_REQUEST);
        }
    }

    public static void validateIti58Request(BatchRequest batchRequest) {
        HpdValidator.validateWithXsd(batchRequest, "/schema/DSMLv2.xsd");
        HpdValidator.validateBatchRequest(batchRequest, new Class[]{SearchRequest.class}, element -> HpdValidator.validateSearchRequest((SearchRequest)element, "HPD", null, null));
    }

    public static void validateIti58Response(BatchResponse batchResponse) {
        HpdValidator.validateWithXsd(batchResponse, "/schema/DSMLv2.xsd");
    }

    public static void validateIti59Request(BatchRequest batchRequest) {
        HpdValidator.validateWithXsd(batchRequest, "/schema/DSMLv2.xsd");
        HpdValidator.validateBatchRequest(batchRequest, new Class[]{AddRequest.class, ModifyRequest.class, ModifyDNRequest.class, DelRequest.class}, element -> {});
    }

    public static void validateIti59Response(BatchResponse batchResponse) {
        HpdValidator.validateWithXsd(batchResponse, "/schema/DSMLv2.xsd");
    }

    public static void validateChPiddRequest(org.openehealth.ipf.commons.ihe.hpd.stub.chpidd.DownloadRequest downloadRequest) {
        HpdValidator.validateWithXsd(downloadRequest, "/schema/PIDD.xsd");
    }

    public static void validateChPiddResponse(org.openehealth.ipf.commons.ihe.hpd.stub.chpidd.DownloadResponse downloadResponse) {
        HpdValidator.validateWithXsd(downloadResponse, "/schema/PIDD.xsd");
        if (downloadResponse.getBatchRequest() != null) {
            for (BatchRequest batchRequest : downloadResponse.getBatchRequest()) {
                HpdValidator.validateBatchRequest(batchRequest, new Class[]{AddRequest.class, ModifyRequest.class, ModifyDNRequest.class, DelRequest.class}, element -> {});
            }
        }
    }

    public static void validateChCiqRequest(BatchRequest batchRequest) {
        HpdValidator.validateWithXsd(batchRequest, "/schema/DSMLv2.xsd");
        HpdValidator.validateBatchRequest(batchRequest, new Class[]{SearchRequest.class}, element -> HpdValidator.validateSearchRequest((SearchRequest)element, "CPI", "BAG", "CH"));
    }

    public static void validateChCiqResponse(BatchResponse batchResponse) {
        HpdValidator.validateWithXsd(batchResponse, "/schema/DSMLv2.xsd");
    }

    public static void validateChCiddRequest(DownloadRequest downloadRequest) {
        HpdValidator.validateWithXsd(downloadRequest, "/schema/CIDD.xsd");
    }

    public static void validateChCiddResponse(DownloadResponse downloadResponse) {
        HpdValidator.validateWithXsd(downloadResponse, "/schema/CIDD.xsd");
        if (downloadResponse.getBatchRequest() != null) {
            for (BatchRequest batchRequest : downloadResponse.getBatchRequest()) {
                HpdValidator.validateBatchRequest(batchRequest, new Class[]{AddRequest.class, ModifyRequest.class, ModifyDNRequest.class, DelRequest.class}, element -> {});
            }
        }
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ObjectFactory.class, ObjectFactory.class, org.openehealth.ipf.commons.ihe.hpd.stub.chcidd.ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new ExceptionInInitializerError(e);
        }
        XSD_VALIDATOR = new XsdValidator();
    }
}

