/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hpd;

import java.util.function.Consumer;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.core.modules.api.ValidationException;
import org.openehealth.ipf.commons.ihe.hpd.HpdException;
import org.openehealth.ipf.commons.ihe.hpd.stub.chpidd.DownloadRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.chpidd.DownloadResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.chpidd.ObjectFactory;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.AddRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.DelRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.DsmlMessage;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ErrorResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ModifyDNRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ModifyRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.SearchRequest;
import org.openehealth.ipf.commons.xml.XsdValidator;

public class HpdValidator {
    private static final JAXBContext JAXB_CONTEXT;
    private static final XsdValidator XSD_VALIDATOR;

    private static void check(boolean condition, String message) {
        if (!condition) {
            throw new HpdException(message, ErrorResponse.ErrorType.MALFORMED_REQUEST);
        }
    }

    private static void validateWithXsd(Object object, String schemaName) {
        try {
            JAXBSource source = new JAXBSource(JAXB_CONTEXT, object);
            XSD_VALIDATOR.validate((Source)source, schemaName);
        }
        catch (ValidationException e) {
            throw new HpdException((Exception)((Object)e), ErrorResponse.ErrorType.MALFORMED_REQUEST);
        }
        catch (Exception e) {
            throw new HpdException(e, ErrorResponse.ErrorType.OTHER);
        }
    }

    private static void validateBatchRequest(BatchRequest batch, Class<? extends DsmlMessage>[] allowedElementTypes, Consumer<DsmlMessage> requestValidator) {
        HpdValidator.check(batch.getBatchRequests() != null, "Batch is null");
        HpdValidator.check(!batch.getBatchRequests().isEmpty(), "Batch is empty");
        for (DsmlMessage dsml : batch.getBatchRequests()) {
            HpdValidator.check(dsml != null, "Batch element is null");
            HpdValidator.check(ArrayUtils.contains((Object[])allowedElementTypes, dsml.getClass()), "Bad batch element type " + ClassUtils.getSimpleName((Object)dsml));
            requestValidator.accept(dsml);
        }
    }

    private static void validateSearchRequest(SearchRequest request) {
        try {
            LdapName ldapName = new LdapName(request.getDn());
            boolean oCheck = false;
            boolean dcCheck = false;
            for (Rdn rdn : ldapName.getRdns()) {
                String value = (String)rdn.getValue();
                switch (rdn.getType().toLowerCase()) {
                    case "o": {
                        oCheck = StringUtils.isNotBlank((CharSequence)value);
                        break;
                    }
                    case "dc": {
                        dcCheck = "HPD".equals(value);
                    }
                }
            }
            HpdValidator.check(oCheck, "Missing DN.O");
            HpdValidator.check(dcCheck, "DN.DC not equal to 'HPD'");
        }
        catch (InvalidNameException e) {
            throw new HpdException(e, ErrorResponse.ErrorType.MALFORMED_REQUEST);
        }
    }

    public static void validateIti58Request(BatchRequest batchRequest) {
        HpdValidator.validateWithXsd(batchRequest, "/schema/DSMLv2.xsd");
        HpdValidator.validateBatchRequest(batchRequest, new Class[]{SearchRequest.class}, element -> HpdValidator.validateSearchRequest((SearchRequest)element));
    }

    public static void validateIti58Response(BatchResponse batchResponse) {
        HpdValidator.validateWithXsd(batchResponse, "/schema/DSMLv2.xsd");
    }

    public static void validateIti59Request(BatchRequest batchRequest) {
        HpdValidator.validateWithXsd(batchRequest, "/schema/DSMLv2.xsd");
        HpdValidator.validateBatchRequest(batchRequest, new Class[]{AddRequest.class, ModifyRequest.class, ModifyDNRequest.class, DelRequest.class}, element -> {});
    }

    public static void validateIti59Response(BatchResponse batchResponse) {
        HpdValidator.validateWithXsd(batchResponse, "/schema/DSMLv2.xsd");
    }

    public static void validateChPiddRequest(DownloadRequest downloadRequest) {
        HpdValidator.validateWithXsd(downloadRequest, "/schema/PIDD.xsd");
    }

    public static void validateChpiddResponse(DownloadResponse downloadResponse) {
        HpdValidator.validateWithXsd(downloadResponse, "/schema/PIDD.xsd");
        if (downloadResponse.getBatchRequest() != null) {
            for (BatchRequest batchRequest : downloadResponse.getBatchRequest()) {
                HpdValidator.validateBatchRequest(batchRequest, new Class[]{AddRequest.class, ModifyRequest.class, ModifyDNRequest.class, DelRequest.class}, element -> {});
            }
        }
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ObjectFactory.class, ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new ExceptionInInitializerError(e);
        }
        XSD_VALIDATOR = new XsdValidator();
    }
}

