/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hpd.iti59;

import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventIdCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCodeRole;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.audit.model.ParticipantObjectIdentificationType;
import org.openehealth.ipf.commons.audit.model.TypeValuePairType;
import org.openehealth.ipf.commons.audit.types.EventId;
import org.openehealth.ipf.commons.ihe.core.atna.AuditDataset;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategySupport;
import org.openehealth.ipf.commons.ihe.hpd.atna.HpdAuditorTestBase;
import org.openehealth.ipf.commons.ihe.hpd.audit.codes.HpdParticipantObjectIdTypeCode;
import org.openehealth.ipf.commons.ihe.hpd.iti59.Iti59AuditDataset;
import org.openehealth.ipf.commons.ihe.hpd.iti59.Iti59AuditStrategy;
import org.openehealth.ipf.commons.ihe.hpd.iti59.Iti59ClientAuditStrategy;
import org.openehealth.ipf.commons.ihe.hpd.iti59.Iti59ServerAuditStrategy;

public class Iti59AuditStrategyTest
extends HpdAuditorTestBase {
    @Test
    public void testServerSide() {
        this.testRequest(true, (Iti59AuditStrategy)new Iti59ServerAuditStrategy());
    }

    @Test
    public void testClientSide() {
        this.testRequest(false, (Iti59AuditStrategy)new Iti59ClientAuditStrategy());
    }

    private void testRequest(boolean serverSide, Iti59AuditStrategy strategy) {
        Iti59AuditDataset auditDataset = this.getHpdAuditDataset(strategy);
        AuditMessage[] auditMessages = Iti59AuditStrategyTest.makeAuditMessages((AuditStrategySupport)strategy, (AuditContext)this.auditContext, (AuditDataset)auditDataset);
        Assert.assertEquals((long)3L, (long)auditMessages.length);
        for (AuditMessage auditMessage : auditMessages) {
            auditMessage.validate();
            System.out.println(Iti59AuditStrategyTest.printAuditMessage((AuditMessage)auditMessage));
            Assert.assertEquals((long)1L, (long)auditMessage.getParticipantObjectIdentifications().size());
            ParticipantObjectIdentificationType participant = (ParticipantObjectIdentificationType)auditMessage.getParticipantObjectIdentifications().get(0);
            Assert.assertEquals((Object)ParticipantObjectTypeCodeRole.Provider, (Object)participant.getParticipantObjectTypeCodeRole());
            Assert.assertEquals((Object)HpdParticipantObjectIdTypeCode.RelativeDistinguishedName, (Object)participant.getParticipantObjectIDTypeCode());
        }
        this.assertCommonHpdAuditAttributes(auditMessages[0], EventOutcomeIndicator.Success, (EventId)(serverSide ? EventIdCode.Import : EventIdCode.Export), EventActionCode.Update, serverSide);
        ParticipantObjectIdentificationType participant = (ParticipantObjectIdentificationType)auditMessages[2].getParticipantObjectIdentifications().get(0);
        Assert.assertEquals((long)1L, (long)participant.getParticipantObjectDetails().size());
        Assert.assertEquals((Object)"new uid", (Object)((TypeValuePairType)participant.getParticipantObjectDetails().get(0)).getType());
        Assert.assertEquals((Object)"2.22.222.2222:klmno", (Object)new String(((TypeValuePairType)participant.getParticipantObjectDetails().get(0)).getValue()));
    }

    private Iti59AuditDataset getHpdAuditDataset(Iti59AuditStrategy strategy) {
        Iti59AuditDataset auditDataset = strategy.createAuditDataset();
        auditDataset.setEventOutcomeIndicator(EventOutcomeIndicator.Success);
        auditDataset.setRemoteAddress("141.44.162.126");
        auditDataset.setSourceUserId("http://141.44.162.126:8090/services/iti55-response");
        auditDataset.setDestinationUserId("http://www.icw.int/pxs/iti55-service");
        auditDataset.setRequestPayload("<query><coffee /></query>");
        auditDataset.setPurposesOfUse(PURPOSES_OF_USE);
        auditDataset.getHumanUsers().add(new AuditDataset.HumanUser("alias<user@issuer>", "Dr. Klaus-Peter Kohlrabi", (Collection)USER_ROLES));
        Iti59AuditDataset.RequestItem requestItem1 = new Iti59AuditDataset.RequestItem("queryIdExtension@queryIdRoot", EventActionCode.Update);
        requestItem1.setUid("1.2.3.4.5.6:abcde");
        requestItem1.setParticipantObjectTypeCode(ParticipantObjectTypeCode.Organization);
        requestItem1.setOutcomeCode(EventOutcomeIndicator.Success);
        Iti59AuditDataset.RequestItem requestItem2 = new Iti59AuditDataset.RequestItem("queryIdExtension@queryIdRoot", EventActionCode.Create);
        requestItem2.setUid("2.3.4.5.6.7:qrstu");
        requestItem2.setParticipantObjectTypeCode(ParticipantObjectTypeCode.Person);
        requestItem2.setOutcomeCode(EventOutcomeIndicator.MinorFailure);
        Iti59AuditDataset.RequestItem requestItem3 = new Iti59AuditDataset.RequestItem("queryIdExtension@queryIdRoot", EventActionCode.Execute);
        requestItem3.setUid(null);
        requestItem3.setNewUid("1.3.5.7:fghij");
        requestItem3.setParticipantObjectTypeCode(ParticipantObjectTypeCode.Person);
        requestItem3.setOutcomeCode(EventOutcomeIndicator.Success);
        Iti59AuditDataset.RequestItem requestItem4 = new Iti59AuditDataset.RequestItem("queryIdExtension@queryIdRoot", EventActionCode.Execute);
        requestItem4.setUid("1.11.111.1111:klmno");
        requestItem4.setNewUid("2.22.222.2222:klmno");
        requestItem4.setParticipantObjectTypeCode(ParticipantObjectTypeCode.Organization);
        requestItem4.setOutcomeCode(EventOutcomeIndicator.Success);
        auditDataset.setRequestItems(new Iti59AuditDataset.RequestItem[]{requestItem1, requestItem2, requestItem3, requestItem4});
        return auditDataset;
    }
}

