/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hpd.iti59;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategySupport;
import org.openehealth.ipf.commons.ihe.hpd.iti59.Iti59AuditDataset;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.AddRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.DelRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.DsmlMessage;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ErrorResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.LDAPResult;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ModifyDNRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ModifyRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Iti59AuditStrategy
extends AuditStrategySupport<Iti59AuditDataset> {
    private static final Logger log = LoggerFactory.getLogger(Iti59AuditStrategy.class);
    private static final String ATTR_NAME = "hcIdentifier";

    protected Iti59AuditStrategy(boolean serverSide) {
        super(serverSide);
    }

    public Iti59AuditDataset createAuditDataset() {
        return new Iti59AuditDataset(this.isServerSide());
    }

    public Iti59AuditDataset enrichAuditDatasetFromRequest(Iti59AuditDataset auditDataset, Object requestObject, Map<String, Object> parameters) {
        BatchRequest batchRequest = (BatchRequest)requestObject;
        if (batchRequest == null || batchRequest.getBatchRequests() == null || batchRequest.getBatchRequests().isEmpty()) {
            log.debug("Empty batch request");
            return auditDataset;
        }
        Iti59AuditDataset.RequestItem[] requestItems = new Iti59AuditDataset.RequestItem[batchRequest.getBatchRequests().size()];
        for (int i = 0; i < batchRequest.getBatchRequests().size(); ++i) {
            Set<String> providerIds;
            DsmlMessage dsmlMessage = batchRequest.getBatchRequests().get(i);
            if (dsmlMessage instanceof AddRequest) {
                AddRequest addRequest = (AddRequest)dsmlMessage;
                providerIds = addRequest.getAttr().stream().filter(x -> ATTR_NAME.equalsIgnoreCase(x.getName())).flatMap(x -> x.getValue().stream()).map(Object::toString).collect(Collectors.toSet());
                requestItems[i] = new Iti59AuditDataset.RequestItem(StringUtils.trimToNull((String)addRequest.getRequestID()), EventActionCode.Create, providerIds);
                continue;
            }
            if (dsmlMessage instanceof ModifyRequest) {
                ModifyRequest modifyRequest = (ModifyRequest)dsmlMessage;
                providerIds = modifyRequest.getModification().stream().filter(x -> ATTR_NAME.equalsIgnoreCase(x.getName())).flatMap(x -> x.getValue().stream()).map(Object::toString).collect(Collectors.toSet());
                requestItems[i] = new Iti59AuditDataset.RequestItem(StringUtils.trimToNull((String)modifyRequest.getRequestID()), EventActionCode.Update, providerIds);
                continue;
            }
            if (dsmlMessage instanceof ModifyDNRequest) {
                ModifyDNRequest modifyDNRequest = (ModifyDNRequest)dsmlMessage;
                requestItems[i] = new Iti59AuditDataset.RequestItem(StringUtils.trimToNull((String)modifyDNRequest.getRequestID()), EventActionCode.Update, Collections.emptySet());
                requestItems[i].setDn(modifyDNRequest.getDn());
                requestItems[i].setNewRdn(modifyDNRequest.getNewrdn());
                continue;
            }
            if (dsmlMessage instanceof DelRequest) {
                DelRequest delRequest = (DelRequest)dsmlMessage;
                requestItems[i] = new Iti59AuditDataset.RequestItem(StringUtils.trimToNull((String)delRequest.getRequestID()), EventActionCode.Delete, Collections.emptySet());
                requestItems[i].setDn(delRequest.getDn());
                continue;
            }
            log.debug("Cannot handle ITI-59 request of type {}", (Object)ClassUtils.getShortCanonicalName((Object)dsmlMessage, (String)"<null>"));
        }
        auditDataset.setRequestItems(requestItems);
        return auditDataset;
    }

    public boolean enrichAuditDatasetFromResponse(Iti59AuditDataset auditDataset, Object responseObject, AuditContext auditContext) {
        int i;
        if (auditDataset.getRequestItems() == null) {
            log.debug("The request was empty, nothing to audit");
            return true;
        }
        BatchResponse batchResponse = (BatchResponse)responseObject;
        if (batchResponse == null || batchResponse.getBatchResponses() == null) {
            for (Iti59AuditDataset.RequestItem requestItem : auditDataset.getRequestItems()) {
                if (requestItem == null) continue;
                requestItem.setOutcomeCode(EventOutcomeIndicator.SeriousFailure);
            }
            return false;
        }
        HashMap<String, Object> byRequestId = new HashMap<String, Object>();
        Object[] byNumber = new Object[batchResponse.getBatchResponses().size()];
        for (i = 0; i < batchResponse.getBatchResponses().size(); ++i) {
            Object value = batchResponse.getBatchResponses().get(i).getValue();
            if (value instanceof LDAPResult) {
                LDAPResult ldapResult = (LDAPResult)value;
                if (StringUtils.isEmpty((CharSequence)ldapResult.getRequestID())) {
                    byNumber[i] = ldapResult;
                    continue;
                }
                byRequestId.put(ldapResult.getRequestID(), ldapResult);
                continue;
            }
            if (!(value instanceof ErrorResponse)) continue;
            ErrorResponse errorResponse = (ErrorResponse)value;
            if (StringUtils.isEmpty((CharSequence)errorResponse.getRequestID())) {
                byNumber[i] = errorResponse;
                continue;
            }
            byRequestId.put(errorResponse.getRequestID(), errorResponse);
        }
        for (i = 0; i < auditDataset.getRequestItems().length; ++i) {
            Iti59AuditDataset.RequestItem requestItem = auditDataset.getRequestItems()[i];
            if (requestItem == null) continue;
            if (StringUtils.isEmpty((CharSequence)requestItem.getRequestId())) {
                Iti59AuditStrategy.setOutcomeCode(requestItem, i < byNumber.length ? byNumber[i] : null, "Could not find response for the ID-less ITI-59 request number {}: either too few responses, or wrong type, or has a request ID", i);
                continue;
            }
            Iti59AuditStrategy.setOutcomeCode(requestItem, byRequestId.get(requestItem.getRequestId()), "Could not find response for the ITI-59 sub-request with ID '{}': either no ID match, or wrong type", requestItem.getRequestId());
        }
        return true;
    }

    private static void setOutcomeCode(Iti59AuditDataset.RequestItem requestItem, Object value, String failureLogMessage, Object ... failureLogArgs) {
        if (value instanceof LDAPResult) {
            LDAPResult ldapResult = (LDAPResult)value;
            requestItem.setOutcomeCode(ldapResult.getResultCode() != null && ldapResult.getResultCode().getCode() == 0 ? EventOutcomeIndicator.Success : EventOutcomeIndicator.SeriousFailure);
            requestItem.setOutcomeDescription(ldapResult.getErrorMessage());
        } else if (value instanceof ErrorResponse) {
            requestItem.setOutcomeCode(EventOutcomeIndicator.SeriousFailure);
            requestItem.setOutcomeDescription(((ErrorResponse)value).getMessage());
        } else {
            requestItem.setOutcomeCode(EventOutcomeIndicator.MajorFailure);
            log.debug(failureLogMessage, failureLogArgs);
        }
    }

    public EventOutcomeIndicator getEventOutcomeIndicator(Object response) {
        return null;
    }

    public AuditMessage[] makeAuditMessage(AuditContext auditContext, Iti59AuditDataset auditDataset) {
        return (AuditMessage[])Stream.of(auditDataset.getRequestItems()).map(requestItem -> this.makeAuditMessage(auditContext, auditDataset, (Iti59AuditDataset.RequestItem)requestItem)).toArray(AuditMessage[]::new);
    }

    protected abstract AuditMessage makeAuditMessage(AuditContext var1, Iti59AuditDataset var2, Iti59AuditDataset.RequestItem var3);
}

