/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hpd.iti59;

import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventIdCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCodeRole;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.audit.types.EventId;
import org.openehealth.ipf.commons.ihe.core.atna.AuditDataset;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategySupport;
import org.openehealth.ipf.commons.ihe.hpd.atna.HpdAuditorTestBase;
import org.openehealth.ipf.commons.ihe.hpd.iti59.Iti59AuditDataset;
import org.openehealth.ipf.commons.ihe.hpd.iti59.Iti59AuditStrategy;
import org.openehealth.ipf.commons.ihe.hpd.iti59.Iti59ClientAuditStrategy;
import org.openehealth.ipf.commons.ihe.hpd.iti59.Iti59ServerAuditStrategy;

public class Iti59AuditStrategyTest
extends HpdAuditorTestBase {
    @Test
    public void testServerSide() {
        this.testRequest(true, (Iti59AuditStrategy)new Iti59ServerAuditStrategy());
    }

    @Test
    public void testClientSide() {
        this.testRequest(false, (Iti59AuditStrategy)new Iti59ClientAuditStrategy());
    }

    private void testRequest(boolean serverSide, Iti59AuditStrategy strategy) {
        Iti59AuditDataset auditDataset = this.getHpdAuditDataset(strategy);
        AuditMessage[] auditMessages = Iti59AuditStrategyTest.makeAuditMessages((AuditStrategySupport)strategy, (AuditContext)this.auditContext, (AuditDataset)auditDataset);
        Assert.assertEquals((long)2L, (long)auditMessages.length);
        for (AuditMessage auditMessage : auditMessages) {
            auditMessage.validate();
        }
        this.assertCommonHpdAuditAttributes(auditMessages[0], EventOutcomeIndicator.Success, (EventId)(serverSide ? EventIdCode.Import : EventIdCode.Export), EventActionCode.Update, serverSide);
        Assert.assertEquals((long)PROVIDER_IDS.length, (long)auditMessages[0].findParticipantObjectIdentifications(poit -> poit.getParticipantObjectTypeCodeRole() == ParticipantObjectTypeCodeRole.Provider).size());
    }

    private Iti59AuditDataset getHpdAuditDataset(Iti59AuditStrategy strategy) {
        Iti59AuditDataset auditDataset = strategy.createAuditDataset();
        auditDataset.setEventOutcomeIndicator(EventOutcomeIndicator.Success);
        auditDataset.setRemoteAddress("141.44.162.126");
        auditDataset.setUserName("alias<user@issuer>");
        auditDataset.setSourceUserId("http://141.44.162.126:8090/services/iti55-response");
        auditDataset.setDestinationUserId("http://www.icw.int/pxs/iti55-service");
        auditDataset.setRequestPayload("<query><coffee /></query>");
        auditDataset.setPurposesOfUse(NEW_PURPOSES_OF_USE);
        auditDataset.getUserRoles().addAll(NEW_USER_ROLES);
        Iti59AuditDataset.RequestItem requestItem1 = new Iti59AuditDataset.RequestItem("queryIdExtension@queryIdRoot", EventActionCode.Update, new HashSet<String>(Arrays.asList(PROVIDER_IDS)));
        requestItem1.setDn("oldDn");
        requestItem1.setNewRdn("newDn");
        requestItem1.setOutcomeCode(EventOutcomeIndicator.Success);
        Iti59AuditDataset.RequestItem requestItem2 = new Iti59AuditDataset.RequestItem("queryIdExtension@queryIdRoot", EventActionCode.Create, new HashSet<String>(Arrays.asList(PROVIDER_IDS)));
        requestItem2.setOutcomeCode(EventOutcomeIndicator.Success);
        auditDataset.setRequestItems(new Iti59AuditDataset.RequestItem[]{requestItem1, requestItem2});
        return auditDataset;
    }
}

