/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hpd.iti59;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategySupport;
import org.openehealth.ipf.commons.ihe.core.atna.AuditorManager;
import org.openehealth.ipf.commons.ihe.hpd.iti59.Iti59AuditDataset;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.AddRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.DelRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.DsmlMessage;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ErrorResponse;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.LDAPResult;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ModifyDNRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ModifyRequest;
import org.openhealthtools.ihe.atna.auditor.codes.rfc3881.RFC3881EventCodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Iti59AuditStrategy
extends AuditStrategySupport<Iti59AuditDataset> {
    private static final Logger log = LoggerFactory.getLogger(Iti59AuditStrategy.class);
    private static final String ATTR_NAME = "hcIdentifier";

    public Iti59AuditStrategy(boolean serverSide) {
        super(serverSide);
    }

    public Iti59AuditDataset createAuditDataset() {
        return new Iti59AuditDataset(this.isServerSide());
    }

    public Iti59AuditDataset enrichAuditDatasetFromRequest(Iti59AuditDataset auditDataset, Object requestObject, Map<String, Object> parameters) {
        BatchRequest batchRequest = (BatchRequest)requestObject;
        if (batchRequest == null || batchRequest.getBatchRequests() == null || batchRequest.getBatchRequests().isEmpty()) {
            log.debug("Empty batch request");
            return auditDataset;
        }
        Iti59AuditDataset.RequestItem[] requestItems = new Iti59AuditDataset.RequestItem[batchRequest.getBatchRequests().size()];
        for (int i = 0; i < batchRequest.getBatchRequests().size(); ++i) {
            Set<String> providerIds;
            DsmlMessage dsmlMessage = batchRequest.getBatchRequests().get(i);
            if (dsmlMessage instanceof AddRequest) {
                AddRequest addRequest = (AddRequest)dsmlMessage;
                providerIds = addRequest.getAttr().stream().filter(x -> ATTR_NAME.equalsIgnoreCase(x.getName())).flatMap(x -> x.getValue().stream()).collect(Collectors.toSet());
                requestItems[i] = new Iti59AuditDataset.RequestItem(StringUtils.trimToNull((String)addRequest.getRequestID()), RFC3881EventCodes.RFC3881EventActionCodes.CREATE, providerIds, null, null);
                continue;
            }
            if (dsmlMessage instanceof ModifyRequest) {
                ModifyRequest modifyRequest = (ModifyRequest)dsmlMessage;
                providerIds = modifyRequest.getModification().stream().filter(x -> ATTR_NAME.equalsIgnoreCase(x.getName())).flatMap(x -> x.getValue().stream()).collect(Collectors.toSet());
                requestItems[i] = new Iti59AuditDataset.RequestItem(StringUtils.trimToNull((String)modifyRequest.getRequestID()), RFC3881EventCodes.RFC3881EventActionCodes.UPDATE, providerIds, null, null);
                continue;
            }
            if (dsmlMessage instanceof ModifyDNRequest) {
                ModifyDNRequest modifyDNRequest = (ModifyDNRequest)dsmlMessage;
                requestItems[i] = new Iti59AuditDataset.RequestItem(StringUtils.trimToNull((String)modifyDNRequest.getRequestID()), RFC3881EventCodes.RFC3881EventActionCodes.UPDATE, null, modifyDNRequest.getDn(), modifyDNRequest.getNewrdn());
                continue;
            }
            if (dsmlMessage instanceof DelRequest) {
                DelRequest delRequest = (DelRequest)dsmlMessage;
                requestItems[i] = new Iti59AuditDataset.RequestItem(StringUtils.trimToNull((String)delRequest.getRequestID()), RFC3881EventCodes.RFC3881EventActionCodes.DELETE, null, delRequest.getDn(), null);
                continue;
            }
            log.debug("Cannot handle ITI-59 request of type {}", (Object)ClassUtils.getShortCanonicalName((Object)dsmlMessage, (String)"<null>"));
        }
        auditDataset.setRequestItems(requestItems);
        return auditDataset;
    }

    public boolean enrichAuditDatasetFromResponse(Iti59AuditDataset auditDataset, Object responseObject) {
        int i;
        if (auditDataset.getRequestItems() == null) {
            log.debug("The request was empty, nothing to audit");
            return true;
        }
        BatchResponse batchResponse = (BatchResponse)responseObject;
        if (batchResponse == null || batchResponse.getBatchResponses() == null) {
            for (Iti59AuditDataset.RequestItem requestItem : auditDataset.getRequestItems()) {
                if (requestItem == null) continue;
                requestItem.setOutcomeCode(RFC3881EventCodes.RFC3881EventOutcomeCodes.SERIOUS_FAILURE);
            }
            return false;
        }
        HashMap<String, Object> byRequestId = new HashMap<String, Object>();
        Object[] byNumber = new Object[batchResponse.getBatchResponses().size()];
        for (i = 0; i < batchResponse.getBatchResponses().size(); ++i) {
            Object value = batchResponse.getBatchResponses().get(i).getValue();
            if (value instanceof LDAPResult) {
                LDAPResult ldapResult = (LDAPResult)value;
                if (StringUtils.isEmpty((CharSequence)ldapResult.getRequestID())) {
                    byNumber[i] = ldapResult;
                    continue;
                }
                byRequestId.put(ldapResult.getRequestID(), ldapResult);
                continue;
            }
            if (!(value instanceof ErrorResponse)) continue;
            ErrorResponse errorResponse = (ErrorResponse)value;
            if (StringUtils.isEmpty((CharSequence)errorResponse.getRequestID())) {
                byNumber[i] = errorResponse;
                continue;
            }
            byRequestId.put(errorResponse.getRequestID(), errorResponse);
        }
        for (i = 0; i < auditDataset.getRequestItems().length; ++i) {
            Iti59AuditDataset.RequestItem requestItem = auditDataset.getRequestItems()[i];
            if (requestItem == null) continue;
            if (StringUtils.isEmpty((CharSequence)requestItem.getRequestId())) {
                Iti59AuditStrategy.setOutcomeCode(requestItem, i < byNumber.length ? byNumber[i] : null, "Could not find response for the ID-less ITI-59 request number {}: either too few responses, or wrong type, or has a request ID", i);
                continue;
            }
            Iti59AuditStrategy.setOutcomeCode(requestItem, byRequestId.get(requestItem.getRequestId()), "Could not find response for the ITI-59 sub-request with ID '{}': either no ID match, or wrong type", requestItem.getRequestId());
        }
        return true;
    }

    private static void setOutcomeCode(Iti59AuditDataset.RequestItem requestItem, Object value, String failureLogMessage, Object ... failureLogArgs) {
        if (value instanceof LDAPResult) {
            LDAPResult ldapResult = (LDAPResult)value;
            requestItem.setOutcomeCode(ldapResult.getResultCode() != null && ldapResult.getResultCode().getCode() == 0 ? RFC3881EventCodes.RFC3881EventOutcomeCodes.SUCCESS : RFC3881EventCodes.RFC3881EventOutcomeCodes.SERIOUS_FAILURE);
        } else if (value instanceof ErrorResponse) {
            requestItem.setOutcomeCode(RFC3881EventCodes.RFC3881EventOutcomeCodes.SERIOUS_FAILURE);
        } else {
            requestItem.setOutcomeCode(RFC3881EventCodes.RFC3881EventOutcomeCodes.MAJOR_FAILURE);
            log.debug(failureLogMessage, failureLogArgs);
        }
    }

    public RFC3881EventCodes.RFC3881EventOutcomeCodes getEventOutcomeCode(Object responseObject) {
        return null;
    }

    public void doAudit(Iti59AuditDataset auditDataset) {
        for (Iti59AuditDataset.RequestItem requestItem : auditDataset.getRequestItems()) {
            if (requestItem == null) continue;
            AuditorManager.getHpdAuditor().auditIti59(this.isServerSide(), requestItem.getActionCode(), requestItem.getOutcomeCode(), auditDataset.getUserId(), auditDataset.getUserName(), auditDataset.getServiceEndpointUrl(), auditDataset.getClientIpAddress(), requestItem.getProviderIds(), requestItem.getDn(), requestItem.getNewRdn(), auditDataset.getPurposesOfUse(), auditDataset.getUserRoles());
        }
    }
}

