/*
 * Copyright 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.openehealth.ipf.commons.ihe.hpd;

import lombok.Getter;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ErrorResponse.ErrorType;

/**
 * @author Dmytro Rud
 */
public class HpdException extends RuntimeException {

    @Getter private final ErrorType type;

    public HpdException(String message, ErrorType type) {
        super(message);
        this.type = Validate.notNull(type);
    }

    public HpdException(Exception exception, ErrorType type) {
        super(exception.getMessage());
        this.type = Validate.notNull(type);
    }
}
