/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hpd;

import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.core.modules.api.ValidationException;
import org.openehealth.ipf.commons.ihe.hpd.HpdException;
import org.openehealth.ipf.commons.ihe.hpd.HpdUtils;
import org.openehealth.ipf.commons.ihe.hpd.stub.ErrorType;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.BatchRequest;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.DsmlMessage;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.ObjectFactory;
import org.openehealth.ipf.commons.ihe.hpd.stub.dsmlv2.SearchRequest;
import org.openehealth.ipf.commons.xml.XsdValidator;

public class HpdRequestValidator {
    private static final String XSD_DOCUMENT = "/wsdl/DSMLv2.xsd";
    private static final JAXBContext JAXB_CONTEXT;
    private static final XsdValidator XSD_VALIDATOR;

    private void check(boolean condition, String message) {
        if (!condition) {
            throw new HpdException(message, ErrorType.MALFORMED_REQUEST);
        }
    }

    private static void validateWithXsd(Object object) {
        try {
            JAXBSource source = new JAXBSource(JAXB_CONTEXT, object);
            XSD_VALIDATOR.validate((Source)source, XSD_DOCUMENT);
        }
        catch (ValidationException e) {
            throw new HpdException((Exception)((Object)e), ErrorType.MALFORMED_REQUEST);
        }
        catch (Exception e) {
            throw new HpdException(e, ErrorType.OTHER);
        }
    }

    public void validateBatchRequest(BatchRequest request) {
        HpdRequestValidator.validateWithXsd(request);
        this.check(request.getBatchRequests() != null, "Request list is null");
        this.check(!request.getBatchRequests().isEmpty(), "Request list is empty");
        for (DsmlMessage dsml : request.getBatchRequests()) {
            this.check(dsml instanceof SearchRequest, "Only SearchRequests are supported");
            this.validateSearchRequest((SearchRequest)dsml);
        }
    }

    private void validateSearchRequest(SearchRequest request) {
        Map<String, String> dn = HpdUtils.parseLdapAttribute(request.getDn());
        this.check(StringUtils.isNotBlank((CharSequence)dn.get("O")), "Missing DN.O");
        this.check("HPD".equals(dn.get("DC")), "DN.DC not equal to 'HPD'");
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        XSD_VALIDATOR = new XsdValidator();
    }
}

