/*
 * Copyright 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.openehealth.ipf.commons.ihe.hpd;

import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Dmytro Rud
 */
@Slf4j
public class HpdUtils {

    public static Map<String, String> parseLdapAttribute(String attribute) {
        Map<String, String> result = new HashMap<>();
        for (String fragment: attribute.split("[;,]")) {
            int pos = fragment.indexOf('=');
            if (pos > 0) {
                result.put(fragment.substring(0, pos).trim().toUpperCase(), fragment.substring(pos + 1).trim());
            } else {
                log.debug("Could not parse {}", fragment);
            }
        }
        return result;
    }
}
