/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.translation;

import java.net.URISyntaxException;
import java.util.Objects;
import org.openehealth.ipf.commons.core.URN;
import org.openehealth.ipf.commons.ihe.fhir.translation.UriMapper;

public abstract class AbstractUriMapper
implements UriMapper {
    @Override
    public String uriToOid(String uri) throws URISyntaxException {
        String oid = this.translateURN(uri, "oid");
        if (oid != null) {
            return oid;
        }
        oid = this.mapUriToOid(uri);
        if (oid != null) {
            return oid;
        }
        return null;
    }

    @Override
    public String uriToNamespace(String uri) throws URISyntaxException {
        String namespace = this.translateURN(uri, "pin");
        if (namespace != null) {
            return namespace;
        }
        namespace = this.mapUriToNamespace(uri);
        if (namespace != null) {
            return namespace;
        }
        return null;
    }

    @Override
    public String oidToUri(String oid) throws URISyntaxException {
        try {
            String uri = this.mapOidToUri(oid);
            if (uri != null && !oid.equals(uri)) {
                return uri;
            }
        }
        catch (Exception exception) {}
        return new URN("oid", oid).toString();
    }

    protected abstract String mapUriToOid(String var1);

    protected abstract String mapUriToNamespace(String var1);

    protected abstract String mapOidToUri(String var1);

    private String translateURN(String uri, String nss) throws URISyntaxException {
        URN urn;
        if (URN.isURN((String)uri) && Objects.equals((urn = URN.create((String)uri)).getNamespaceId(), nss)) {
            return urn.getNamespaceSpecificString();
        }
        return null;
    }
}

