/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.iti78;

import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.hl7v2.HapiContext;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.FastDateFormat;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.hl7.fhir.instance.model.Enumerations;
import org.hl7.fhir.instance.model.IdType;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.openehealth.ipf.commons.ihe.fhir.Constants;
import org.openehealth.ipf.commons.ihe.fhir.Utils;
import org.openehealth.ipf.commons.ihe.fhir.translation.TranslatorFhirToHL7v2;
import org.openehealth.ipf.commons.ihe.fhir.translation.UriMapper;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.CustomModelClassUtils;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.HapiContextFactory;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.pdq.v25.message.QBP_Q21;
import org.openehealth.ipf.gazelle.validation.profile.pixpdq.PixPdqTransactions;
import org.openehealth.ipf.modules.hl7.dsl.Repeatable;
import org.openehealth.ipf.modules.hl7.message.MessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdqmRequestToPdqQueryTranslator
implements TranslatorFhirToHL7v2,
GroovyObject {
    private static final String SEARCH_TAG = "search";
    private static final String GET_TAG = "get";
    private String queryName;
    private String senderDeviceName;
    private String senderFacilityName;
    private String receiverDeviceName;
    private String receiverFacilityName;
    private String pdqSupplierResourceIdentifierUri;
    private String pdqSupplierResourceIdentifierOid;
    private final UriMapper uriMapper;
    private static final HapiContext PDQ_QUERY_CONTEXT;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    public PdqmRequestToPdqQueryTranslator(UriMapper uriMapper) {
        void uriMapper2;
        MetaClass metaClass;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        CallSite[] callSiteArray = PdqmRequestToPdqQueryTranslator.$getCallSiteArray();
        this.queryName = string5 = "IHE PDQ Query";
        this.senderDeviceName = string4 = "unknown";
        this.senderFacilityName = string3 = "unknown";
        this.receiverDeviceName = string2 = "unknown";
        this.receiverFacilityName = string = "unknown";
        this.metaClass = metaClass = this.$getStaticMetaClass();
        callSiteArray[0].call(Validate.class, (Object)uriMapper2, (Object)"URI Mapper must not be null");
        void var9_9 = uriMapper2;
        this.uriMapper = (UriMapper)ScriptBytecodeAdapter.castToType((Object)var9_9, UriMapper.class);
    }

    public void setPdqSupplierResourceIdentifierUri(String pdqSupplierResourceIdentifierUri) {
        CallSite[] callSiteArray = PdqmRequestToPdqQueryTranslator.$getCallSiteArray();
        callSiteArray[1].call(Validate.class, (Object)pdqSupplierResourceIdentifierUri, (Object)"Resource Identifier URI must not be null");
        String string = pdqSupplierResourceIdentifierUri;
        this.pdqSupplierResourceIdentifierUri = ShortTypeHandling.castToString((Object)string);
        Object object = callSiteArray[2].call((Object)this.uriMapper, (Object)pdqSupplierResourceIdentifierUri);
        this.pdqSupplierResourceIdentifierOid = ShortTypeHandling.castToString((Object)object);
    }

    public QBP_Q21 translateFhirToHL7v2(Object request, Map<String, Object> parameters) {
        CallSite[] callSiteArray = PdqmRequestToPdqQueryTranslator.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)request, null) && ScriptBytecodeAdapter.compareNotEqual(parameters, null) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(parameters))) {
                return (QBP_Q21)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].callCurrent((GroovyObject)this, (Object)SEARCH_TAG, parameters), QBP_Q21.class);
            }
            return (QBP_Q21)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].callCurrent((GroovyObject)this, (Object)GET_TAG, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((IdType)ScriptBytecodeAdapter.castToType((Object)request, IdType.class)), IdType.class)), QBP_Q21.class);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)request, null) && ScriptBytecodeAdapter.compareNotEqual(parameters, null) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].call(parameters))) {
            return (QBP_Q21)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].callCurrent((GroovyObject)this, (Object)SEARCH_TAG, parameters), QBP_Q21.class);
        }
        return this.translateFhirReadToHL7v2(GET_TAG, (IdType)ScriptBytecodeAdapter.castToType((Object)request, IdType.class));
    }

    protected QBP_Q21 translateFhirReadToHL7v2(String queryTagPrefix, IdType resourceId) {
        CallSite[] callSiteArray = PdqmRequestToPdqQueryTranslator.$getCallSiteArray();
        Map parameters = ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[8].callGetProperty(Constants.class), ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[9].callGetProperty(IAnyResource.class), callSiteArray[10].callConstructor(TokenParam.class, (Object)this.pdqSupplierResourceIdentifierUri, callSiteArray[11].callGetProperty((Object)resourceId))})});
        return (QBP_Q21)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].callCurrent((GroovyObject)this, (Object)queryTagPrefix, (Object)parameters), QBP_Q21.class);
    }

    protected QBP_Q21 translateFhirSearchToHL7v2(String queryTagPrefix, Map<String, Object> parameters) {
        CallSite[] callSiteArray = PdqmRequestToPdqQueryTranslator.$getCallSiteArray();
        Reference qry = new Reference((Object)((QBP_Q21)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].call(MessageUtils.class, (Object)PDQ_QUERY_CONTEXT, (Object)"QBP", (Object)"Q22", (Object)"2.5"), QBP_Q21.class)));
        String string = this.senderDeviceName;
        callSiteArray[14].call(callSiteArray[15].callGetProperty((Object)((QBP_Q21)qry.get())), (Object)3, (Object)string);
        String string2 = this.senderFacilityName;
        callSiteArray[16].call(callSiteArray[17].callGetProperty((Object)((QBP_Q21)qry.get())), (Object)4, (Object)string2);
        String string3 = this.receiverDeviceName;
        callSiteArray[18].call(callSiteArray[19].callGetProperty((Object)((QBP_Q21)qry.get())), (Object)5, (Object)string3);
        String string4 = this.receiverFacilityName;
        callSiteArray[20].call(callSiteArray[21].callGetProperty((Object)((QBP_Q21)qry.get())), (Object)6, (Object)string4);
        Object object = callSiteArray[22].call(Utils.class);
        callSiteArray[23].call(callSiteArray[24].callGetProperty((Object)((QBP_Q21)qry.get())), (Object)7, object);
        Object object2 = callSiteArray[25].call(callSiteArray[26].call(UUID.class));
        callSiteArray[27].call(callSiteArray[28].callGetProperty((Object)((QBP_Q21)qry.get())), (Object)10, object2);
        String string5 = this.queryName;
        callSiteArray[29].call(callSiteArray[30].callGetProperty((Object)((QBP_Q21)qry.get())), (Object)1, (Object)string5);
        Object object3 = callSiteArray[31].call((Object)new GStringImpl(new Object[]{queryTagPrefix}, new String[]{"", "_"}), callSiteArray[32].call(callSiteArray[33].call(UUID.class)));
        callSiteArray[34].call(callSiteArray[35].callGetProperty((Object)((QBP_Q21)qry.get())), (Object)2, object3);
        Map map = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[36].call(parameters, callSiteArray[37].callGetProperty(Constants.class)), Map.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)map)) {
            throw (Throwable)callSiteArray[38].callConstructor(InvalidRequestException.class, (Object)"No request parameters found");
        }
        List requestedDomains = null;
        String identifierNamespace = null;
        String identifierOid = null;
        String identifierValue = null;
        TokenParam resourceIdParam = (TokenParam)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].call((Object)map, callSiteArray[40].callGetProperty(IAnyResource.class)), TokenParam.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)resourceIdParam)) {
            String string6 = this.pdqSupplierResourceIdentifierUri;
            ScriptBytecodeAdapter.setProperty((Object)string6, null, (Object)resourceIdParam, (String)"system");
            Object object4 = callSiteArray[41].callCurrent((GroovyObject)this, (Object)resourceIdParam);
            identifierNamespace = ShortTypeHandling.castToString((Object)callSiteArray[42].call(object4, (Object)0));
            identifierOid = ShortTypeHandling.castToString((Object)callSiteArray[43].call(object4, (Object)1));
            identifierValue = ShortTypeHandling.castToString((Object)callSiteArray[44].call(object4, (Object)2));
        }
        TokenAndListParam identifierParam = (TokenAndListParam)ScriptBytecodeAdapter.castToType((Object)callSiteArray[45].call((Object)map, callSiteArray[46].callGetProperty(Patient.class)), TokenAndListParam.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)identifierParam)) {
            List identifiers = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[47].callCurrent((GroovyObject)this, (Object)identifierParam), List.class);
            List searchIdentifier = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[48].callSafe((Object)identifiers, (Object)new GeneratedClosure(this, this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    CallSite[] callSiteArray = _translateFhirSearchToHL7v2_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _translateFhirSearchToHL7v2_closure1.$getCallSiteArray();
                    if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].call(it), (Object)3) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGetPropertySafe(callSiteArray[2].call(it, (Object)2)));
                    }
                    return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].call(it), (Object)3) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].callGetPropertySafe(callSiteArray[5].call(it, (Object)2)));
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _translateFhirSearchToHL7v2_closure1.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _translateFhirSearchToHL7v2_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "size";
                    stringArray[1] = "empty";
                    stringArray[2] = "getAt";
                    stringArray[3] = "size";
                    stringArray[4] = "empty";
                    stringArray[5] = "getAt";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[6];
                    _translateFhirSearchToHL7v2_closure1.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_translateFhirSearchToHL7v2_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _translateFhirSearchToHL7v2_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }), List.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)searchIdentifier)) {
                List list = searchIdentifier;
                identifierNamespace = ShortTypeHandling.castToString((Object)callSiteArray[49].call((Object)list, (Object)0));
                identifierOid = ShortTypeHandling.castToString((Object)callSiteArray[50].call((Object)list, (Object)1));
                identifierValue = ShortTypeHandling.castToString((Object)callSiteArray[51].call((Object)list, (Object)2));
            }
            Object object5 = callSiteArray[52].call(callSiteArray[53].callSafe((Object)identifiers, (Object)new GeneratedClosure(this, this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    CallSite[] callSiteArray = _translateFhirSearchToHL7v2_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _translateFhirSearchToHL7v2_closure2.$getCallSiteArray();
                    if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].call(it), (Object)2) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call(it, (Object)2));
                    }
                    return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].call(it), (Object)2) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(it, (Object)2));
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _translateFhirSearchToHL7v2_closure2.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _translateFhirSearchToHL7v2_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "size";
                    stringArray[1] = "getAt";
                    stringArray[2] = "size";
                    stringArray[3] = "getAt";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[4];
                    _translateFhirSearchToHL7v2_closure2.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_translateFhirSearchToHL7v2_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _translateFhirSearchToHL7v2_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }), (Object)new GeneratedClosure(this, this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    CallSite[] callSiteArray = _translateFhirSearchToHL7v2_closure3.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _translateFhirSearchToHL7v2_closure3.$getCallSiteArray();
                    return callSiteArray[0].call(it, (Object)1);
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _translateFhirSearchToHL7v2_closure3.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _translateFhirSearchToHL7v2_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "getAt";
                    return new CallSiteArray(_translateFhirSearchToHL7v2_closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _translateFhirSearchToHL7v2_closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            });
            requestedDomains = (List)ScriptBytecodeAdapter.castToType((Object)object5, List.class);
        }
        if (DefaultTypeTransformation.booleanUnbox(requestedDomains) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[54].call(requestedDomains, (Object)this.pdqSupplierResourceIdentifierOid))) {
            callSiteArray[55].call(requestedDomains, (Object)this.pdqSupplierResourceIdentifierOid);
        }
        DateParam birthDateParam = (DateParam)ScriptBytecodeAdapter.castToType((Object)callSiteArray[56].call((Object)map, callSiteArray[57].callGetProperty(Patient.class)), DateParam.class);
        String birthDateString = ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox((Object)birthDateParam) ? callSiteArray[58].call(callSiteArray[59].call(FastDateFormat.class, (Object)"yyyyMMdd"), callSiteArray[60].call((Object)birthDateParam)) : null);
        TokenParam genderParam = (TokenParam)ScriptBytecodeAdapter.castToType((Object)callSiteArray[61].call((Object)map, callSiteArray[62].callGetProperty(Patient.class)), TokenParam.class);
        String genderString = ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox((Object)genderParam) ? callSiteArray[63].call(callSiteArray[64].call(callSiteArray[65].call(Enumerations.AdministrativeGender.class, callSiteArray[66].callGetProperty((Object)genderParam))), (Object)"hl7v2fhir-patient-administrativeGender") : null);
        Map searchParams = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"@PID.3.1", identifierValue, "@PID.3.4.1", identifierNamespace, "@PID.3.4.2", identifierOid, "@PID.3.4.3", DefaultTypeTransformation.booleanUnbox((Object)identifierOid) ? "ISO" : null, "@PID.5.1", callSiteArray[67].callCurrent((GroovyObject)this, callSiteArray[68].callCurrent((GroovyObject)this, callSiteArray[69].call((Object)map, callSiteArray[70].callGetProperty(Patient.class)), (Object)false)), "@PID.5.2", callSiteArray[71].callCurrent((GroovyObject)this, callSiteArray[72].callCurrent((GroovyObject)this, callSiteArray[73].call((Object)map, callSiteArray[74].callGetProperty(Patient.class)), (Object)false)), "@PID.7", birthDateString, "@PID.8", genderString, "@PID.11.1", callSiteArray[75].callCurrent((GroovyObject)this, callSiteArray[76].call((Object)map, callSiteArray[77].callGetProperty(Patient.class)), (Object)true), "@PID.11.3", callSiteArray[78].callCurrent((GroovyObject)this, callSiteArray[79].call((Object)map, callSiteArray[80].callGetProperty(Patient.class)), (Object)true), "@PID.11.4", callSiteArray[81].callCurrent((GroovyObject)this, callSiteArray[82].call((Object)map, callSiteArray[83].callGetProperty(Patient.class)), (Object)true), "@PID.11.5", callSiteArray[84].callCurrent((GroovyObject)this, callSiteArray[85].call((Object)map, callSiteArray[86].callGetProperty(Patient.class)), (Object)true), "@PID.11.6", callSiteArray[87].callCurrent((GroovyObject)this, callSiteArray[88].call((Object)map, callSiteArray[89].callGetProperty(Patient.class)), (Object)true), "@PID.6.1", callSiteArray[90].callCurrent((GroovyObject)this, callSiteArray[91].callCurrent((GroovyObject)this, callSiteArray[92].call((Object)map, callSiteArray[93].callGetProperty(Constants.class)), (Object)false)), "@PID.6.2", callSiteArray[94].callCurrent((GroovyObject)this, callSiteArray[95].callCurrent((GroovyObject)this, callSiteArray[96].call((Object)map, callSiteArray[97].callGetProperty(Constants.class)), (Object)false)), "@PID.13.1", callSiteArray[98].callCurrent((GroovyObject)this, callSiteArray[99].call((Object)map, callSiteArray[100].callGetProperty(Patient.class)), (Object)true), "@PID.25", callSiteArray[101].callCurrent((GroovyObject)this, callSiteArray[102].call((Object)map, callSiteArray[103].callGetProperty(Constants.class)))});
        callSiteArray[104].callStatic(PdqmRequestToPdqQueryTranslator.class, (Object)searchParams, callSiteArray[105].call(callSiteArray[106].callGetProperty((Object)((QBP_Q21)qry.get())), (Object)3));
        callSiteArray[107].callSafe((Object)requestedDomains, (Object)new GeneratedClosure(this, this, qry){
            private /* synthetic */ Reference qry;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _translateFhirSearchToHL7v2_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.qry = reference = qry;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _translateFhirSearchToHL7v2_closure4.$getCallSiteArray();
                return callSiteArray[0].call(Utils.class, callSiteArray[1].call(Utils.class, callSiteArray[2].call(callSiteArray[3].callGetProperty(this.qry.get()), (Object)8)), it);
            }

            public QBP_Q21 getQry() {
                CallSite[] callSiteArray = _translateFhirSearchToHL7v2_closure4.$getCallSiteArray();
                return (QBP_Q21)ScriptBytecodeAdapter.castToType((Object)this.qry.get(), QBP_Q21.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _translateFhirSearchToHL7v2_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateFhirSearchToHL7v2_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "populateIdentifier";
                stringArray[1] = "nextRepetition";
                stringArray[2] = "getAt";
                stringArray[3] = "QPD";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _translateFhirSearchToHL7v2_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_translateFhirSearchToHL7v2_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _translateFhirSearchToHL7v2_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        String string7 = "I";
        callSiteArray[108].call(callSiteArray[109].callGetProperty((Object)((QBP_Q21)qry.get())), (Object)1, (Object)string7);
        return (QBP_Q21)qry.get();
    }

    private String searchString(StringParam param, boolean forceExactSearch) {
        CallSite[] callSiteArray = PdqmRequestToPdqQueryTranslator.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)param, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[110].callGetProperty((Object)param))) {
            return ShortTypeHandling.castToString(null);
        }
        return ShortTypeHandling.castToString((Object)(forceExactSearch || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[111].callGetProperty((Object)param)) ? callSiteArray[112].callGetProperty((Object)param) : callSiteArray[113].call(callSiteArray[114].callGetProperty((Object)param), (Object)"*")));
    }

    private List<String> searchStringList(StringAndListParam param, boolean forceExactSearch) {
        Reference forceExactSearch2 = new Reference((Object)forceExactSearch);
        CallSite[] callSiteArray = PdqmRequestToPdqQueryTranslator.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[115].call(callSiteArray[116].callSafe((Object)param), (Object)new GeneratedClosure(this, this, forceExactSearch2){
            private /* synthetic */ Reference forceExactSearch;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _searchStringList_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.forceExactSearch = reference = forceExactSearch;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _searchStringList_closure5.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].call(callSiteArray[2].callGetProperty(it)), this.forceExactSearch.get());
            }

            public boolean getForceExactSearch() {
                CallSite[] callSiteArray = _searchStringList_closure5.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.forceExactSearch.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _searchStringList_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _searchStringList_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "searchString";
                stringArray[1] = "find";
                stringArray[2] = "valuesAsQueryTokens";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _searchStringList_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_searchStringList_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _searchStringList_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), List.class);
    }

    private List<String> searchUri(UriParam param) {
        CallSite[] callSiteArray = PdqmRequestToPdqQueryTranslator.$getCallSiteArray();
        String namespace = null;
        String oid = null;
        if (ScriptBytecodeAdapter.compareEqual((Object)param, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[117].callGetProperty((Object)param))) {
            return (List)ScriptBytecodeAdapter.castToType(null, List.class);
        }
        Object object = callSiteArray[118].call((Object)this.uriMapper, callSiteArray[119].callGetProperty((Object)param));
        namespace = ShortTypeHandling.castToString((Object)object);
        Object object2 = callSiteArray[120].call((Object)this.uriMapper, callSiteArray[121].callGetProperty((Object)param));
        oid = ShortTypeHandling.castToString((Object)object2);
        if (!(DefaultTypeTransformation.booleanUnbox((Object)namespace) || DefaultTypeTransformation.booleanUnbox((Object)oid))) {
            throw (Throwable)callSiteArray[122].call(Utils.class, callSiteArray[123].callGetProperty((Object)param));
        }
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{namespace, oid});
    }

    private List<List<String>> searchUriList(UriAndListParam param) {
        CallSite[] callSiteArray = PdqmRequestToPdqQueryTranslator.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[124].call(callSiteArray[125].callSafe((Object)param), (Object)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _searchUriList_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _searchUriList_closure6.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].call(callSiteArray[2].callGetProperty(it)));
            }

            public Object doCall() {
                CallSite[] callSiteArray = _searchUriList_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _searchUriList_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "searchUri";
                stringArray[1] = "find";
                stringArray[2] = "valuesAsQueryTokens";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _searchUriList_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_searchUriList_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _searchUriList_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), List.class);
    }

    private String searchNumber(NumberParam param) {
        CallSite[] callSiteArray = PdqmRequestToPdqQueryTranslator.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)param, null)) {
            return ShortTypeHandling.castToString(null);
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[126].call(callSiteArray[127].callGetPropertySafe((Object)param)));
    }

    private List<String> searchToken(TokenParam identifierParam) {
        CallSite[] callSiteArray = PdqmRequestToPdqQueryTranslator.$getCallSiteArray();
        String namespace = null;
        String oid = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)identifierParam)) {
            Object object = callSiteArray[128].call((Object)this.uriMapper, callSiteArray[129].callGetProperty((Object)identifierParam));
            namespace = ShortTypeHandling.castToString((Object)object);
            Object object2 = callSiteArray[130].call((Object)this.uriMapper, callSiteArray[131].callGetProperty((Object)identifierParam));
            oid = ShortTypeHandling.castToString((Object)object2);
            if (!(DefaultTypeTransformation.booleanUnbox((Object)namespace) || DefaultTypeTransformation.booleanUnbox((Object)oid))) {
                throw (Throwable)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[132].callGetProperty((Object)identifierParam)) ? callSiteArray[133].call(Utils.class, callSiteArray[134].callGetProperty((Object)identifierParam)) : callSiteArray[135].call(Utils.class, callSiteArray[136].callGetProperty((Object)identifierParam)));
            }
        }
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{namespace, oid, callSiteArray[137].callGetPropertySafe((Object)identifierParam)});
    }

    private List<List<String>> searchTokenList(TokenAndListParam param) {
        CallSite[] callSiteArray = PdqmRequestToPdqQueryTranslator.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[138].call(callSiteArray[139].callSafe((Object)param), (Object)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _searchTokenList_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _searchTokenList_closure7.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].callSafe(callSiteArray[2].callGetPropertySafe(it)));
            }

            public Object doCall() {
                CallSite[] callSiteArray = _searchTokenList_closure7.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _searchTokenList_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "searchToken";
                stringArray[1] = "find";
                stringArray[2] = "valuesAsQueryTokens";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _searchTokenList_closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_searchTokenList_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _searchTokenList_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), List.class);
    }

    private Object firstOrNull(List<?> list) {
        CallSite[] callSiteArray = PdqmRequestToPdqQueryTranslator.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[140].callGetPropertySafe(list)) ? null : callSiteArray[141].call(list, (Object)0);
    }

    public static void fillSearchParameters(Map<String, Object> parameters, Repeatable target) {
        Reference target2 = new Reference((Object)target);
        CallSite[] callSiteArray = PdqmRequestToPdqQueryTranslator.$getCallSiteArray();
        callSiteArray[142].call(callSiteArray[143].call(parameters, (Object)new GeneratedClosure(PdqmRequestToPdqQueryTranslator.class, PdqmRequestToPdqQueryTranslator.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _fillSearchParameters_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _fillSearchParameters_closure8.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _fillSearchParameters_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fillSearchParameters_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "value";
                return new CallSiteArray(_fillSearchParameters_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _fillSearchParameters_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), (Object)new GeneratedClosure(PdqmRequestToPdqQueryTranslator.class, PdqmRequestToPdqQueryTranslator.class, target2){
            private /* synthetic */ Reference target;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _fillSearchParameters_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.target = reference = target;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _fillSearchParameters_closure9.$getCallSiteArray();
                Object field = callSiteArray[0].call(Utils.class, this.target.get());
                Object object = callSiteArray[1].callGetProperty(it);
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[2].call(field, (Object)1), (String)"value");
                Object object2 = callSiteArray[3].callGetProperty(it);
                ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)callSiteArray[4].call(field, (Object)2), (String)"value");
                return object2;
            }

            public Repeatable getTarget() {
                CallSite[] callSiteArray = _fillSearchParameters_closure9.$getCallSiteArray();
                return (Repeatable)ScriptBytecodeAdapter.castToType((Object)this.target.get(), Repeatable.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _fillSearchParameters_closure9.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fillSearchParameters_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "nextRepetition";
                stringArray[1] = "key";
                stringArray[2] = "getAt";
                stringArray[3] = "value";
                stringArray[4] = "getAt";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _fillSearchParameters_closure9.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_fillSearchParameters_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _fillSearchParameters_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PdqmRequestToPdqQueryTranslator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = PdqmRequestToPdqQueryTranslator.$getCallSiteArray()[144].call(HapiContextFactory.class, PdqmRequestToPdqQueryTranslator.$getCallSiteArray()[145].call(CustomModelClassUtils.class, (Object)"pdq", (Object)"2.5"), PdqmRequestToPdqQueryTranslator.$getCallSiteArray()[146].callGetProperty(PixPdqTransactions.class));
        PDQ_QUERY_CONTEXT = (HapiContext)ScriptBytecodeAdapter.castToType((Object)object, HapiContext.class);
    }

    public static final String getSEARCH_TAG() {
        return SEARCH_TAG;
    }

    public static final String getGET_TAG() {
        return GET_TAG;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public void setQueryName(String string) {
        this.queryName = string;
    }

    public String getSenderDeviceName() {
        return this.senderDeviceName;
    }

    public void setSenderDeviceName(String string) {
        this.senderDeviceName = string;
    }

    public String getSenderFacilityName() {
        return this.senderFacilityName;
    }

    public void setSenderFacilityName(String string) {
        this.senderFacilityName = string;
    }

    public String getReceiverDeviceName() {
        return this.receiverDeviceName;
    }

    public void setReceiverDeviceName(String string) {
        this.receiverDeviceName = string;
    }

    public String getReceiverFacilityName() {
        return this.receiverFacilityName;
    }

    public void setReceiverFacilityName(String string) {
        this.receiverFacilityName = string;
    }

    public String getPdqSupplierResourceIdentifierUri() {
        return this.pdqSupplierResourceIdentifierUri;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "notNull";
        stringArray[1] = "notNull";
        stringArray[2] = "uriToOid";
        stringArray[3] = "isEmpty";
        stringArray[4] = "translateFhirSearchToHL7v2";
        stringArray[5] = "translateFhirReadToHL7v2";
        stringArray[6] = "isEmpty";
        stringArray[7] = "translateFhirSearchToHL7v2";
        stringArray[8] = "FHIR_REQUEST_PARAMETERS";
        stringArray[9] = "SP_RES_ID";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "idPart";
        stringArray[12] = "translateFhirSearchToHL7v2";
        stringArray[13] = "makeMessage";
        stringArray[14] = "putAt";
        stringArray[15] = "MSH";
        stringArray[16] = "putAt";
        stringArray[17] = "MSH";
        stringArray[18] = "putAt";
        stringArray[19] = "MSH";
        stringArray[20] = "putAt";
        stringArray[21] = "MSH";
        stringArray[22] = "hl7Timestamp";
        stringArray[23] = "putAt";
        stringArray[24] = "MSH";
        stringArray[25] = "toString";
        stringArray[26] = "randomUUID";
        stringArray[27] = "putAt";
        stringArray[28] = "MSH";
        stringArray[29] = "putAt";
        stringArray[30] = "QPD";
        stringArray[31] = "plus";
        stringArray[32] = "toString";
        stringArray[33] = "randomUUID";
        stringArray[34] = "putAt";
        stringArray[35] = "QPD";
        stringArray[36] = GET_TAG;
        stringArray[37] = "FHIR_REQUEST_PARAMETERS";
        stringArray[38] = "<$constructor$>";
        stringArray[39] = GET_TAG;
        stringArray[40] = "SP_RES_ID";
        stringArray[41] = "searchToken";
        stringArray[42] = "getAt";
        stringArray[43] = "getAt";
        stringArray[44] = "getAt";
        stringArray[45] = GET_TAG;
        stringArray[46] = "SP_IDENTIFIER";
        stringArray[47] = "searchTokenList";
        stringArray[48] = "find";
        stringArray[49] = "getAt";
        stringArray[50] = "getAt";
        stringArray[51] = "getAt";
        stringArray[52] = "collect";
        stringArray[53] = "findAll";
        stringArray[54] = "contains";
        stringArray[55] = "add";
        stringArray[56] = GET_TAG;
        stringArray[57] = "SP_BIRTHDATE";
        stringArray[58] = "format";
        stringArray[59] = "getInstance";
        stringArray[60] = "getValue";
        stringArray[61] = GET_TAG;
        stringArray[62] = "SP_GENDER";
        stringArray[63] = "mapReverse";
        stringArray[64] = "toCode";
        stringArray[65] = "fromCode";
        stringArray[66] = "value";
        stringArray[67] = "firstOrNull";
        stringArray[68] = "searchStringList";
        stringArray[69] = GET_TAG;
        stringArray[70] = "SP_FAMILY";
        stringArray[71] = "firstOrNull";
        stringArray[72] = "searchStringList";
        stringArray[73] = GET_TAG;
        stringArray[74] = "SP_GIVEN";
        stringArray[75] = "searchString";
        stringArray[76] = GET_TAG;
        stringArray[77] = "SP_ADDRESS";
        stringArray[78] = "searchString";
        stringArray[79] = GET_TAG;
        stringArray[80] = "SP_ADDRESSCITY";
        stringArray[81] = "searchString";
        stringArray[82] = GET_TAG;
        stringArray[83] = "SP_ADDRESSSTATE";
        stringArray[84] = "searchString";
        stringArray[85] = GET_TAG;
        stringArray[86] = "SP_ADDRESSPOSTALCODE";
        stringArray[87] = "searchString";
        stringArray[88] = GET_TAG;
        stringArray[89] = "SP_ADDRESSCOUNTRY";
        stringArray[90] = "firstOrNull";
        stringArray[91] = "searchStringList";
        stringArray[92] = GET_TAG;
        stringArray[93] = "SP_MOTHERS_MAIDEN_NAME_FAMILY";
        stringArray[94] = "firstOrNull";
        stringArray[95] = "searchStringList";
        stringArray[96] = GET_TAG;
        stringArray[97] = "SP_MOTHERS_MAIDEN_NAME_GIVEN";
        stringArray[98] = "searchString";
        stringArray[99] = GET_TAG;
        stringArray[100] = "SP_TELECOM";
        stringArray[101] = "searchNumber";
        stringArray[102] = GET_TAG;
        stringArray[103] = "SP_MULTIPLE_BIRTH_ORDER_NUMBER";
        stringArray[104] = "fillSearchParameters";
        stringArray[105] = "getAt";
        stringArray[106] = "QPD";
        stringArray[107] = "each";
        stringArray[108] = "putAt";
        stringArray[109] = "RCP";
        stringArray[110] = "empty";
        stringArray[111] = "exact";
        stringArray[112] = "value";
        stringArray[113] = "plus";
        stringArray[114] = "value";
        stringArray[115] = "collect";
        stringArray[116] = "getValuesAsQueryTokens";
        stringArray[117] = "empty";
        stringArray[118] = "uriToNamespace";
        stringArray[119] = "value";
        stringArray[120] = "uriToOid";
        stringArray[121] = "value";
        stringArray[122] = "unknownPatientDomain";
        stringArray[123] = "value";
        stringArray[124] = "collect";
        stringArray[125] = "getValuesAsQueryTokens";
        stringArray[126] = "toString";
        stringArray[127] = "value";
        stringArray[128] = "uriToNamespace";
        stringArray[129] = "system";
        stringArray[130] = "uriToOid";
        stringArray[131] = "system";
        stringArray[132] = "value";
        stringArray[133] = "unknownPatientDomain";
        stringArray[134] = "system";
        stringArray[135] = "unknownTargetDomainValue";
        stringArray[136] = "system";
        stringArray[137] = "value";
        stringArray[138] = "collect";
        stringArray[139] = "getValuesAsQueryTokens";
        stringArray[140] = "empty";
        stringArray[141] = "getAt";
        stringArray[142] = "each";
        stringArray[143] = "findAll";
        stringArray[144] = "createHapiContext";
        stringArray[145] = "createFactory";
        stringArray[146] = "ITI21";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[147];
        PdqmRequestToPdqQueryTranslator.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(PdqmRequestToPdqQueryTranslator.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = PdqmRequestToPdqQueryTranslator.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

