/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.iti78;

import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.valueset.BundleEntrySearchModeEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v25.segment.PID;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.hl7.fhir.instance.model.Address;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.ContactPoint;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.DateType;
import org.hl7.fhir.instance.model.Enumerations;
import org.hl7.fhir.instance.model.HumanName;
import org.hl7.fhir.instance.model.IdType;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.valuesets.V3MaritalStatus;
import org.hl7.fhir.instance.model.valuesets.V3NullFlavor;
import org.openehealth.ipf.commons.ihe.fhir.Utils;
import org.openehealth.ipf.commons.ihe.fhir.iti78.PdqPatient;
import org.openehealth.ipf.commons.ihe.fhir.iti78.PdqmRequestToPdqQueryTranslator;
import org.openehealth.ipf.commons.ihe.fhir.translation.TranslatorHL7v2ToFhir;
import org.openehealth.ipf.commons.ihe.fhir.translation.UriMapper;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.pdq.v25.message.RSP_K21;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdqResponseToPdqmResponseTranslator
implements TranslatorHL7v2ToFhir,
GroovyObject {
    private static final Logger LOG;
    private final UriMapper uriMapper;
    private String pdqSupplierResourceIdentifierUri;
    private String pdqSupplierResourceIdentifierOid;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    public PdqResponseToPdqmResponseTranslator(UriMapper uriMapper) {
        void uriMapper2;
        MetaClass metaClass;
        CallSite[] callSiteArray = PdqResponseToPdqmResponseTranslator.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        callSiteArray[0].call(Validate.class, (Object)uriMapper2, (Object)"URI Mapper must not be null");
        void var4_4 = uriMapper2;
        this.uriMapper = (UriMapper)ScriptBytecodeAdapter.castToType((Object)var4_4, UriMapper.class);
    }

    public void setPdqSupplierResourceIdentifierUri(String pdqSupplierResourceIdentifierUri) {
        CallSite[] callSiteArray = PdqResponseToPdqmResponseTranslator.$getCallSiteArray();
        callSiteArray[1].call(Validate.class, (Object)pdqSupplierResourceIdentifierUri, (Object)"Resource Identifier URI must not be null");
        String string = pdqSupplierResourceIdentifierUri;
        this.pdqSupplierResourceIdentifierUri = ShortTypeHandling.castToString((Object)string);
        Object object = callSiteArray[2].call((Object)this.uriMapper, (Object)pdqSupplierResourceIdentifierUri);
        this.pdqSupplierResourceIdentifierOid = ShortTypeHandling.castToString((Object)object);
    }

    @Override
    public Object translateHL7v2ToFhir(Message message, Map<String, Object> parameters) {
        CallSite[] callSiteArray = PdqResponseToPdqmResponseTranslator.$getCallSiteArray();
        String ackCode = ShortTypeHandling.castToString((Object)callSiteArray[3].callGetProperty(callSiteArray[4].call(callSiteArray[5].callGetProperty((Object)message), (Object)2)));
        boolean returnBundle = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].call(callSiteArray[7].callGetProperty(callSiteArray[8].call(callSiteArray[9].callGetProperty((Object)message), (Object)2)), callSiteArray[10].callGetProperty(PdqmRequestToPdqQueryTranslator.class)));
        String string = ackCode;
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"OK")) {
            return returnBundle ? callSiteArray[11].callCurrent((GroovyObject)this, callSiteArray[12].call((Object)message)) : callSiteArray[13].callCurrent((GroovyObject)this, callSiteArray[14].call((Object)message));
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"NF")) {
            return callSiteArray[15].callCurrent((GroovyObject)this, null);
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"AE")) {
            return callSiteArray[16].callCurrent((GroovyObject)this, (Object)message);
        }
        throw (Throwable)callSiteArray[17].callConstructor(InternalErrorException.class, callSiteArray[18].call((Object)"Unexpected ack code ", (Object)ackCode));
    }

    protected PdqPatient handleRegularResource(Object responseCollection) {
        CallSite[] callSiteArray = PdqResponseToPdqmResponseTranslator.$getCallSiteArray();
        List result = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[19].callCurrent((GroovyObject)this, responseCollection), List.class);
        return (PdqPatient)((Object)ScriptBytecodeAdapter.castToType(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[20].callGetProperty((Object)result)) ? null : callSiteArray[21].call((Object)result, (Object)0), PdqPatient.class));
    }

    protected List<PdqPatient> handleRegularSearchResponse(Object responseCollection) {
        CallSite[] callSiteArray = PdqResponseToPdqmResponseTranslator.$getCallSiteArray();
        List resultList = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].callConstructor(ArrayList.class), List.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)responseCollection)) {
            Object response = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].call(responseCollection), Iterator.class);
            while (iterator.hasNext()) {
                response = iterator.next();
                PdqPatient patient = (PdqPatient)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].callCurrent((GroovyObject)this, response), PdqPatient.class));
                callSiteArray[25].callGetProperty(ResourceMetadataKeyEnum.class);
                callSiteArray[26].call((Object)resultList, (Object)patient);
            }
        }
        return resultList;
    }

    protected void addSearchScore(PdqPatient pdqPatient, Object response) {
        CallSite[] callSiteArray = PdqResponseToPdqmResponseTranslator.$getCallSiteArray();
        callSiteArray[27].call(callSiteArray[28].callGetProperty(ResourceMetadataKeyEnum.class), (Object)pdqPatient, callSiteArray[29].call(callSiteArray[30].callGetProperty(BundleEntrySearchModeEnum.class)));
        callSiteArray[31].call((Object)pdqPatient);
        String searchScoreString = ShortTypeHandling.castToString((Object)callSiteArray[32].callGetPropertySafe(callSiteArray[33].call(callSiteArray[34].callGetProperty(response), (Object)1)));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)searchScoreString, null)) {
            double searchScore = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[35].call(callSiteArray[36].call(Integer.class, (Object)searchScoreString), (Object)100));
            callSiteArray[37].call(callSiteArray[38].callGetProperty(ResourceMetadataKeyEnum.class), (Object)pdqPatient, callSiteArray[39].callConstructor(DecimalDt.class, (Object)searchScore));
        }
    }

    protected PdqPatient pidToPatient(Object response) {
        CallSite[] callSiteArray = PdqResponseToPdqmResponseTranslator.$getCallSiteArray();
        PdqPatient patient = (PdqPatient)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[40].callConstructor(PdqPatient.class), PdqPatient.class));
        PID pid = (PID)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].callGetProperty(response), PID.class);
        Object resourcePid = callSiteArray[42].call(callSiteArray[43].call(callSiteArray[44].call((Object)pid, (Object)3)), (Object)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _pidToPatient_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object pid3) {
                CallSite[] callSiteArray = _pidToPatient_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)this), (Object)callSiteArray[1].callGetProperty(callSiteArray[2].call(callSiteArray[3].call(pid3, (Object)4), (Object)2)));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _pidToPatient_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "pdqSupplierResourceIdentifierOid";
                stringArray[1] = "value";
                stringArray[2] = "getAt";
                stringArray[3] = "getAt";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _pidToPatient_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_pidToPatient_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _pidToPatient_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        if (DefaultTypeTransformation.booleanUnbox((Object)resourcePid)) {
            callSiteArray[45].call((Object)patient, callSiteArray[46].callConstructor(IdType.class, (Object)"Patient", callSiteArray[47].callGetProperty(callSiteArray[48].call(resourcePid, (Object)1))));
        } else {
            callSiteArray[49].call((Object)LOG, (Object)"No ID found with resource system URI {}", (Object)this.pdqSupplierResourceIdentifierUri);
        }
        callSiteArray[50].callCurrent((GroovyObject)this, callSiteArray[51].call(callSiteArray[52].call((Object)pid, (Object)3)), callSiteArray[53].call((Object)patient));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[54].callGetProperty(callSiteArray[55].call((Object)pid, (Object)5)))) {
            callSiteArray[56].callCurrent((GroovyObject)this, callSiteArray[57].call(callSiteArray[58].call((Object)pid, (Object)5)), callSiteArray[59].call((Object)patient));
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[60].callGetProperty(callSiteArray[61].call((Object)pid, (Object)6)))) {
            callSiteArray[62].call((Object)patient, callSiteArray[63].callCurrent((GroovyObject)this, callSiteArray[64].call((Object)pid, (Object)6)));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[65].callGetPropertySafe(callSiteArray[66].call((Object)pid, (Object)7)))) {
            callSiteArray[67].call((Object)patient, callSiteArray[68].call(DateType.class, callSiteArray[69].callGetProperty(callSiteArray[70].call((Object)pid, (Object)7))));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[71].callGetPropertySafe(callSiteArray[72].call((Object)pid, (Object)8)))) {
            callSiteArray[73].call((Object)patient, callSiteArray[74].call(Enumerations.AdministrativeGender.class, callSiteArray[75].callSafe(callSiteArray[76].callGetProperty(callSiteArray[77].call((Object)pid, (Object)8)), (Object)"hl7v2fhir-patient-administrativeGender")));
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[78].callGetProperty(callSiteArray[79].call((Object)pid, (Object)11)))) {
            callSiteArray[80].callCurrent((GroovyObject)this, callSiteArray[81].call(callSiteArray[82].call((Object)pid, (Object)11)), callSiteArray[83].call((Object)patient));
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[84].callGetProperty(callSiteArray[85].call((Object)pid, (Object)13)))) {
            callSiteArray[86].callCurrent((GroovyObject)this, callSiteArray[87].call(callSiteArray[88].call((Object)pid, (Object)13)), callSiteArray[89].call((Object)patient), callSiteArray[90].callGetProperty(ContactPoint.ContactPointUse.class), callSiteArray[91].callGetProperty(ContactPoint.ContactPointSystem.class));
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[92].callGetProperty(callSiteArray[93].call((Object)pid, (Object)14)))) {
            callSiteArray[94].callCurrent((GroovyObject)this, callSiteArray[95].call(callSiteArray[96].call((Object)pid, (Object)14)), callSiteArray[97].call((Object)patient), callSiteArray[98].callGetProperty(ContactPoint.ContactPointUse.class), callSiteArray[99].callGetProperty(ContactPoint.ContactPointSystem.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[100].callGetPropertySafe(callSiteArray[101].call((Object)pid, (Object)15)))) {
            CodeableConcept language = (CodeableConcept)ScriptBytecodeAdapter.castToType((Object)callSiteArray[102].callConstructor(CodeableConcept.class), CodeableConcept.class);
            callSiteArray[103].call(callSiteArray[104].call((Object)language), callSiteArray[105].callGetProperty(callSiteArray[106].call((Object)pid, (Object)15)));
            callSiteArray[107].call(callSiteArray[108].call((Object)patient), (Object)language);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[109].callGetPropertySafe(callSiteArray[110].call((Object)pid, (Object)16)))) {
            Object object;
            Object object2;
            Object object3;
            CodeableConcept maritalStatus = (CodeableConcept)ScriptBytecodeAdapter.castToType((Object)callSiteArray[111].callConstructor(CodeableConcept.class), CodeableConcept.class);
            String mapped = ShortTypeHandling.castToString((Object)callSiteArray[112].call(callSiteArray[113].callGetProperty(callSiteArray[114].call((Object)pid, (Object)16)), (Object)"hl7v2fhir-patient-maritalStatus"));
            Object mappedMaritalStatus = null;
            String string = mapped;
            mappedMaritalStatus = ScriptBytecodeAdapter.isCase((Object)string, (Object)"UNK") ? (object3 = callSiteArray[115].callGetProperty(V3NullFlavor.class)) : (ScriptBytecodeAdapter.isCase((Object)string, (Object)"U") ? (object2 = callSiteArray[116].call(callSiteArray[117].call(callSiteArray[118].call(callSiteArray[119].callConstructor(Coding.class), (Object)"http://hl7.org/fhir/marital-status"), (Object)"U"), (Object)"Unmarried")) : (object = callSiteArray[120].call(V3MaritalStatus.class, (Object)mapped)));
            callSiteArray[121].call(callSiteArray[122].call(callSiteArray[123].call(callSiteArray[124].call((Object)maritalStatus), (Object)mapped), callSiteArray[125].callGetProperty(mappedMaritalStatus)), callSiteArray[126].callGetProperty(mappedMaritalStatus));
            callSiteArray[127].call((Object)patient, (Object)maritalStatus);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[128].callGetProperty(callSiteArray[129].call((Object)pid, (Object)18)))) {
            callSiteArray[130].call((Object)patient, callSiteArray[131].callCurrent((GroovyObject)this, callSiteArray[132].call((Object)pid, (Object)18)));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[133].callGetProperty(callSiteArray[134].call((Object)pid, (Object)19)))) {
            callSiteArray[135].call((Object)patient, callSiteArray[136].callCurrent((GroovyObject)this, callSiteArray[137].call((Object)pid, (Object)19)));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[138].callGetProperty(callSiteArray[139].call((Object)pid, (Object)25)))) {
            callSiteArray[140].call((Object)patient, callSiteArray[141].callConstructor(IntegerType.class, callSiteArray[142].callGetProperty(callSiteArray[143].call((Object)pid, (Object)25))));
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[144].callGetProperty(callSiteArray[145].call((Object)pid, (Object)24)))) {
            callSiteArray[146].call((Object)patient, callSiteArray[147].callConstructor(BooleanType.class, (Object)ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[148].callGetProperty(callSiteArray[149].call((Object)pid, (Object)24)), (Object)"Y")));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[150].callGetProperty(callSiteArray[151].call((Object)pid, (Object)29)))) {
            callSiteArray[152].call((Object)patient, callSiteArray[153].call(DateTimeType.class, callSiteArray[154].callGetProperty(callSiteArray[155].call((Object)pid, (Object)29))));
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[156].callGetProperty(callSiteArray[157].call((Object)pid, (Object)30)))) {
            callSiteArray[158].call((Object)patient, callSiteArray[159].callConstructor(BooleanType.class, (Object)ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[160].callGetProperty(callSiteArray[161].call((Object)pid, (Object)30)), (Object)"Y")));
        }
        return patient;
    }

    protected List<PdqPatient> handleErrorResponse(RSP_K21 message) {
        CallSite[] callSiteArray = PdqResponseToPdqmResponseTranslator.$getCallSiteArray();
        int errorField = DefaultTypeTransformation.intUnbox((Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[162].callGetPropertySafe(callSiteArray[163].call(callSiteArray[164].call(callSiteArray[165].callGetProperty((Object)message), (Object)2), (Object)3))) ? callSiteArray[166].call(Integer.class, callSiteArray[167].callGetPropertySafe(callSiteArray[168].call(callSiteArray[169].call(callSiteArray[170].callGetProperty((Object)message), (Object)2), (Object)3))) : Integer.valueOf(0)));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (errorField == 8) {
                throw (Throwable)callSiteArray[171].call(Utils.class);
            }
            throw (Throwable)callSiteArray[172].call(Utils.class);
        }
        if (errorField == 8) {
            throw (Throwable)callSiteArray[173].call(Utils.class);
        }
        throw (Throwable)callSiteArray[174].call(Utils.class);
    }

    private void convertIdentifiers(Object cxs, List<Identifier> identifiers) {
        CallSite[] callSiteArray = PdqResponseToPdqmResponseTranslator.$getCallSiteArray();
        Object cx = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[175].call(cxs), Iterator.class);
        while (iterator.hasNext()) {
            cx = iterator.next();
            callSiteArray[176].call(identifiers, callSiteArray[177].callCurrent((GroovyObject)this, cx));
        }
    }

    protected Identifier convertIdentifier(Object cx) {
        CallSite[] callSiteArray = PdqResponseToPdqmResponseTranslator.$getCallSiteArray();
        Identifier identifier = (Identifier)ScriptBytecodeAdapter.castToType((Object)callSiteArray[178].call(callSiteArray[179].call(callSiteArray[180].call(callSiteArray[181].callConstructor(Identifier.class), callSiteArray[182].callGetProperty(Identifier.IdentifierUse.class)), callSiteArray[183].call((Object)this.uriMapper, callSiteArray[184].callGetPropertySafe(callSiteArray[185].call(callSiteArray[186].call(cx, (Object)4), (Object)2)))), callSiteArray[187].callGetPropertySafe(callSiteArray[188].call(cx, (Object)1))), Identifier.class);
        return identifier;
    }

    protected void convertAddresses(Object xads, List<Address> addresses) {
        CallSite[] callSiteArray = PdqResponseToPdqmResponseTranslator.$getCallSiteArray();
        Object xad = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[189].call(xads), Iterator.class);
        while (iterator.hasNext()) {
            xad = iterator.next();
            callSiteArray[190].call(addresses, callSiteArray[191].callCurrent((GroovyObject)this, xad));
        }
    }

    protected Address convertAddress(Object xad) {
        CallSite[] callSiteArray = PdqResponseToPdqmResponseTranslator.$getCallSiteArray();
        Address address = (Address)ScriptBytecodeAdapter.castToType((Object)callSiteArray[192].call(callSiteArray[193].call(callSiteArray[194].call(callSiteArray[195].call(callSiteArray[196].call(callSiteArray[197].call(callSiteArray[198].callConstructor(Address.class), callSiteArray[199].callGetPropertySafe(callSiteArray[200].call(xad, (Object)3))), callSiteArray[201].callGetPropertySafe(callSiteArray[202].call(xad, (Object)6))), callSiteArray[203].callGetPropertySafe(callSiteArray[204].call(xad, (Object)5))), callSiteArray[205].callGetPropertySafe(callSiteArray[206].call(xad, (Object)4))), callSiteArray[207].callGetPropertySafe(callSiteArray[208].call(xad, (Object)9))), callSiteArray[209].callCurrent((GroovyObject)this, callSiteArray[210].call(xad, (Object)7), callSiteArray[211].callGetProperty(Address.AddressUse.class))), Address.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[212].callGetPropertySafe(callSiteArray[213].call(xad, (Object)1)))) {
            callSiteArray[214].call((Object)address, callSiteArray[215].callGetPropertySafe(callSiteArray[216].call(xad, (Object)1)));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[217].callGetPropertySafe(callSiteArray[218].call(xad, (Object)2)))) {
            callSiteArray[219].call((Object)address, callSiteArray[220].callGetPropertySafe(callSiteArray[221].call(xad, (Object)2)));
        }
        return address;
    }

    protected void convertNames(Object xpns, List<HumanName> names) {
        CallSite[] callSiteArray = PdqResponseToPdqmResponseTranslator.$getCallSiteArray();
        Object xpn = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[222].call(xpns), Iterator.class);
        while (iterator.hasNext()) {
            xpn = iterator.next();
            callSiteArray[223].call(names, callSiteArray[224].callCurrent((GroovyObject)this, xpn));
        }
    }

    protected HumanName convertName(Object xpn) {
        CallSite[] callSiteArray = PdqResponseToPdqmResponseTranslator.$getCallSiteArray();
        HumanName name = (HumanName)ScriptBytecodeAdapter.castToType((Object)callSiteArray[225].call(callSiteArray[226].callConstructor(HumanName.class), callSiteArray[227].callCurrent((GroovyObject)this, callSiteArray[228].call(xpn, (Object)7), callSiteArray[229].callGetProperty(HumanName.NameUse.class))), HumanName.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[230].callGetPropertySafe(callSiteArray[231].call(xpn, (Object)1)))) {
            callSiteArray[232].call((Object)name, callSiteArray[233].callGetProperty(callSiteArray[234].call(xpn, (Object)1)));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[235].callGetPropertySafe(callSiteArray[236].call(xpn, (Object)2)))) {
            callSiteArray[237].call((Object)name, callSiteArray[238].callGetProperty(callSiteArray[239].call(xpn, (Object)2)));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[240].callGetPropertySafe(callSiteArray[241].call(xpn, (Object)3)))) {
            callSiteArray[242].call((Object)name, callSiteArray[243].callGetProperty(callSiteArray[244].call(xpn, (Object)3)));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[245].callGetPropertySafe(callSiteArray[246].call(xpn, (Object)4)))) {
            callSiteArray[247].call((Object)name, callSiteArray[248].callGetProperty(callSiteArray[249].call(xpn, (Object)4)));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[250].callGetPropertySafe(callSiteArray[251].call(xpn, (Object)5)))) {
            callSiteArray[252].call((Object)name, callSiteArray[253].callGetProperty(callSiteArray[254].call(xpn, (Object)5)));
        }
        return name;
    }

    private void convertTelecoms(Object xtns, List<ContactPoint> telecoms, ContactPoint.ContactPointUse defaultUse, ContactPoint.ContactPointSystem defaultSystem) {
        CallSite[] callSiteArray = PdqResponseToPdqmResponseTranslator.$getCallSiteArray();
        Object xtn = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[255].call(xtns), Iterator.class);
        while (iterator.hasNext()) {
            xtn = iterator.next();
            callSiteArray[256].call(telecoms, callSiteArray[257].callCurrent((GroovyObject)this, xtn, (Object)defaultUse, (Object)defaultSystem));
        }
    }

    protected ContactPoint convertTelecom(Object xtn, ContactPoint.ContactPointUse defaultUse, ContactPoint.ContactPointSystem defaultSystem) {
        CallSite[] callSiteArray = PdqResponseToPdqmResponseTranslator.$getCallSiteArray();
        ContactPoint telecom = (ContactPoint)ScriptBytecodeAdapter.castToType((Object)callSiteArray[258].call(callSiteArray[259].call(callSiteArray[260].call(callSiteArray[261].callConstructor(ContactPoint.class), callSiteArray[262].callCurrent((GroovyObject)this, callSiteArray[263].call(xtn, (Object)2), (Object)defaultUse)), callSiteArray[264].callCurrent((GroovyObject)this, callSiteArray[265].call(xtn, (Object)3), (Object)defaultSystem)), callSiteArray[266].callGetPropertySafe(callSiteArray[267].call(xtn, (Object)1))), ContactPoint.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[268].callGetPropertySafe(callSiteArray[269].call(xtn, (Object)4)))) {
            callSiteArray[270].call(callSiteArray[271].call(callSiteArray[272].call((Object)telecom, callSiteArray[273].callGetProperty(ContactPoint.ContactPointSystem.class)), callSiteArray[274].callGetPropertySafe(callSiteArray[275].call(xtn, (Object)4))), callSiteArray[276].callGetProperty(ContactPoint.ContactPointUse.class));
        }
        return telecom;
    }

    protected ContactPoint.ContactPointUse telecomUse(Object field, ContactPoint.ContactPointUse defaultUse) {
        CallSite[] callSiteArray = PdqResponseToPdqmResponseTranslator.$getCallSiteArray();
        Object object = callSiteArray[278].callGetPropertySafe(field);
        String fhirTelecomUse = ShortTypeHandling.castToString((Object)callSiteArray[277].call(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : "", (Object)"hl7v2fhir-telecom-use"));
        return (ContactPoint.ContactPointUse)ShortTypeHandling.castToEnum((Object)(DefaultTypeTransformation.booleanUnbox((Object)fhirTelecomUse) ? callSiteArray[279].call(ContactPoint.ContactPointUse.class, (Object)fhirTelecomUse) : defaultUse), ContactPoint.ContactPointUse.class);
    }

    protected ContactPoint.ContactPointSystem telecomSystem(Object field, ContactPoint.ContactPointSystem defaultSystem) {
        CallSite[] callSiteArray = PdqResponseToPdqmResponseTranslator.$getCallSiteArray();
        Object object = callSiteArray[281].callGetPropertySafe(field);
        String fhirTelecomSystem = ShortTypeHandling.castToString((Object)callSiteArray[280].call(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : "", (Object)"hl7v2fhir-telecom-type"));
        return (ContactPoint.ContactPointSystem)ShortTypeHandling.castToEnum((Object)(DefaultTypeTransformation.booleanUnbox((Object)fhirTelecomSystem) ? callSiteArray[282].call(ContactPoint.ContactPointSystem.class, (Object)fhirTelecomSystem) : defaultSystem), ContactPoint.ContactPointSystem.class);
    }

    protected HumanName.NameUse nameUse(Object field, HumanName.NameUse defaultUse) {
        CallSite[] callSiteArray = PdqResponseToPdqmResponseTranslator.$getCallSiteArray();
        Object object = callSiteArray[284].callGetPropertySafe(field);
        String fhirNameUse = ShortTypeHandling.castToString((Object)callSiteArray[283].call(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : "", (Object)"hl7v2fhir-name-use"));
        return (HumanName.NameUse)ShortTypeHandling.castToEnum((Object)(DefaultTypeTransformation.booleanUnbox((Object)fhirNameUse) ? callSiteArray[285].call(HumanName.NameUse.class, (Object)fhirNameUse) : defaultUse), HumanName.NameUse.class);
    }

    protected Address.AddressUse addressUse(Object field, Address.AddressUse defaultUse) {
        CallSite[] callSiteArray = PdqResponseToPdqmResponseTranslator.$getCallSiteArray();
        Object object = callSiteArray[287].callGetPropertySafe(field);
        String addressUse = ShortTypeHandling.castToString((Object)callSiteArray[286].call(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : "", (Object)"hl7v2fhir-address-use"));
        return (Address.AddressUse)ShortTypeHandling.castToEnum((Object)(DefaultTypeTransformation.booleanUnbox((Object)addressUse) ? callSiteArray[288].call(Address.AddressUse.class, (Object)addressUse) : defaultUse), Address.AddressUse.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PdqResponseToPdqmResponseTranslator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = PdqResponseToPdqmResponseTranslator.$getCallSiteArray()[289].call(LoggerFactory.class, PdqResponseToPdqmResponseTranslator.class);
        LOG = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    public String getPdqSupplierResourceIdentifierUri() {
        return this.pdqSupplierResourceIdentifierUri;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "notNull";
        stringArray[1] = "notNull";
        stringArray[2] = "uriToOid";
        stringArray[3] = "value";
        stringArray[4] = "getAt";
        stringArray[5] = "QAK";
        stringArray[6] = "startsWith";
        stringArray[7] = "value";
        stringArray[8] = "getAt";
        stringArray[9] = "QPD";
        stringArray[10] = "SEARCH_TAG";
        stringArray[11] = "handleRegularSearchResponse";
        stringArray[12] = "QUERY_RESPONSE";
        stringArray[13] = "handleRegularResource";
        stringArray[14] = "QUERY_RESPONSE";
        stringArray[15] = "handleRegularSearchResponse";
        stringArray[16] = "handleErrorResponse";
        stringArray[17] = "<$constructor$>";
        stringArray[18] = "plus";
        stringArray[19] = "handleRegularSearchResponse";
        stringArray[20] = "empty";
        stringArray[21] = "get";
        stringArray[22] = "<$constructor$>";
        stringArray[23] = "iterator";
        stringArray[24] = "pidToPatient";
        stringArray[25] = "ENTRY_SCORE";
        stringArray[26] = "add";
        stringArray[27] = "put";
        stringArray[28] = "ENTRY_SEARCH_MODE";
        stringArray[29] = "name";
        stringArray[30] = "MATCH";
        stringArray[31] = "setUserData";
        stringArray[32] = "value";
        stringArray[33] = "getAt";
        stringArray[34] = "QRI";
        stringArray[35] = "div";
        stringArray[36] = "valueOf";
        stringArray[37] = "put";
        stringArray[38] = "ENTRY_SCORE";
        stringArray[39] = "<$constructor$>";
        stringArray[40] = "<$constructor$>";
        stringArray[41] = "PID";
        stringArray[42] = "find";
        stringArray[43] = "call";
        stringArray[44] = "getAt";
        stringArray[45] = "setId";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "value";
        stringArray[48] = "getAt";
        stringArray[49] = "warn";
        stringArray[50] = "convertIdentifiers";
        stringArray[51] = "call";
        stringArray[52] = "getAt";
        stringArray[53] = "getIdentifier";
        stringArray[54] = "empty";
        stringArray[55] = "getAt";
        stringArray[56] = "convertNames";
        stringArray[57] = "call";
        stringArray[58] = "getAt";
        stringArray[59] = "getName";
        stringArray[60] = "empty";
        stringArray[61] = "getAt";
        stringArray[62] = "setMothersMaidenName";
        stringArray[63] = "convertName";
        stringArray[64] = "getAt";
        stringArray[65] = "value";
        stringArray[66] = "getAt";
        stringArray[67] = "setBirthDateElement";
        stringArray[68] = "parseV3";
        stringArray[69] = "value";
        stringArray[70] = "getAt";
        stringArray[71] = "value";
        stringArray[72] = "getAt";
        stringArray[73] = "setGender";
        stringArray[74] = "fromCode";
        stringArray[75] = "map";
        stringArray[76] = "value";
        stringArray[77] = "getAt";
        stringArray[78] = "empty";
        stringArray[79] = "getAt";
        stringArray[80] = "convertAddresses";
        stringArray[81] = "call";
        stringArray[82] = "getAt";
        stringArray[83] = "getAddress";
        stringArray[84] = "empty";
        stringArray[85] = "getAt";
        stringArray[86] = "convertTelecoms";
        stringArray[87] = "call";
        stringArray[88] = "getAt";
        stringArray[89] = "getTelecom";
        stringArray[90] = "HOME";
        stringArray[91] = "PHONE";
        stringArray[92] = "empty";
        stringArray[93] = "getAt";
        stringArray[94] = "convertTelecoms";
        stringArray[95] = "call";
        stringArray[96] = "getAt";
        stringArray[97] = "getTelecom";
        stringArray[98] = "WORK";
        stringArray[99] = "PHONE";
        stringArray[100] = "value";
        stringArray[101] = "getAt";
        stringArray[102] = "<$constructor$>";
        stringArray[103] = "setCode";
        stringArray[104] = "addCoding";
        stringArray[105] = "value";
        stringArray[106] = "getAt";
        stringArray[107] = "setLanguage";
        stringArray[108] = "addCommunication";
        stringArray[109] = "value";
        stringArray[110] = "getAt";
        stringArray[111] = "<$constructor$>";
        stringArray[112] = "map";
        stringArray[113] = "value";
        stringArray[114] = "getAt";
        stringArray[115] = "UNK";
        stringArray[116] = "setDisplay";
        stringArray[117] = "setCode";
        stringArray[118] = "setSystem";
        stringArray[119] = "<$constructor$>";
        stringArray[120] = "fromCode";
        stringArray[121] = "setDisplay";
        stringArray[122] = "setSystem";
        stringArray[123] = "setCode";
        stringArray[124] = "addCoding";
        stringArray[125] = "system";
        stringArray[126] = "display";
        stringArray[127] = "setMaritalStatus";
        stringArray[128] = "value";
        stringArray[129] = "getAt";
        stringArray[130] = "addIdentifier";
        stringArray[131] = "convertIdentifier";
        stringArray[132] = "getAt";
        stringArray[133] = "value";
        stringArray[134] = "getAt";
        stringArray[135] = "addIdentifier";
        stringArray[136] = "convertIdentifier";
        stringArray[137] = "getAt";
        stringArray[138] = "value";
        stringArray[139] = "getAt";
        stringArray[140] = "setMultipleBirth";
        stringArray[141] = "<$constructor$>";
        stringArray[142] = "value";
        stringArray[143] = "getAt";
        stringArray[144] = "value";
        stringArray[145] = "getAt";
        stringArray[146] = "setMultipleBirth";
        stringArray[147] = "<$constructor$>";
        stringArray[148] = "value";
        stringArray[149] = "getAt";
        stringArray[150] = "value";
        stringArray[151] = "getAt";
        stringArray[152] = "setDeceased";
        stringArray[153] = "parseV3";
        stringArray[154] = "value";
        stringArray[155] = "getAt";
        stringArray[156] = "value";
        stringArray[157] = "getAt";
        stringArray[158] = "setDeceased";
        stringArray[159] = "<$constructor$>";
        stringArray[160] = "value";
        stringArray[161] = "getAt";
        stringArray[162] = "value";
        stringArray[163] = "getAt";
        stringArray[164] = "getAt";
        stringArray[165] = "ERR";
        stringArray[166] = "parseInt";
        stringArray[167] = "value";
        stringArray[168] = "getAt";
        stringArray[169] = "getAt";
        stringArray[170] = "ERR";
        stringArray[171] = "unknownTargetDomainValue";
        stringArray[172] = "unexpectedProblem";
        stringArray[173] = "unknownTargetDomainValue";
        stringArray[174] = "unexpectedProblem";
        stringArray[175] = "iterator";
        stringArray[176] = "add";
        stringArray[177] = "convertIdentifier";
        stringArray[178] = "setValue";
        stringArray[179] = "setSystem";
        stringArray[180] = "setUse";
        stringArray[181] = "<$constructor$>";
        stringArray[182] = "OFFICIAL";
        stringArray[183] = "oidToUri";
        stringArray[184] = "value";
        stringArray[185] = "getAt";
        stringArray[186] = "getAt";
        stringArray[187] = "value";
        stringArray[188] = "getAt";
        stringArray[189] = "iterator";
        stringArray[190] = "add";
        stringArray[191] = "convertAddress";
        stringArray[192] = "setUse";
        stringArray[193] = "setDistrict";
        stringArray[194] = "setState";
        stringArray[195] = "setPostalCode";
        stringArray[196] = "setCountry";
        stringArray[197] = "setCity";
        stringArray[198] = "<$constructor$>";
        stringArray[199] = "value";
        stringArray[200] = "getAt";
        stringArray[201] = "value";
        stringArray[202] = "getAt";
        stringArray[203] = "value";
        stringArray[204] = "getAt";
        stringArray[205] = "value";
        stringArray[206] = "getAt";
        stringArray[207] = "value";
        stringArray[208] = "getAt";
        stringArray[209] = "addressUse";
        stringArray[210] = "getAt";
        stringArray[211] = "HOME";
        stringArray[212] = "value";
        stringArray[213] = "getAt";
        stringArray[214] = "addLine";
        stringArray[215] = "value";
        stringArray[216] = "getAt";
        stringArray[217] = "value";
        stringArray[218] = "getAt";
        stringArray[219] = "addLine";
        stringArray[220] = "value";
        stringArray[221] = "getAt";
        stringArray[222] = "iterator";
        stringArray[223] = "add";
        stringArray[224] = "convertName";
        stringArray[225] = "setUse";
        stringArray[226] = "<$constructor$>";
        stringArray[227] = "nameUse";
        stringArray[228] = "getAt";
        stringArray[229] = "OFFICIAL";
        stringArray[230] = "value";
        stringArray[231] = "getAt";
        stringArray[232] = "addFamily";
        stringArray[233] = "value";
        stringArray[234] = "getAt";
        stringArray[235] = "value";
        stringArray[236] = "getAt";
        stringArray[237] = "addGiven";
        stringArray[238] = "value";
        stringArray[239] = "getAt";
        stringArray[240] = "value";
        stringArray[241] = "getAt";
        stringArray[242] = "addGiven";
        stringArray[243] = "value";
        stringArray[244] = "getAt";
        stringArray[245] = "value";
        stringArray[246] = "getAt";
        stringArray[247] = "addSuffix";
        stringArray[248] = "value";
        stringArray[249] = "getAt";
        stringArray[250] = "value";
        stringArray[251] = "getAt";
        stringArray[252] = "addPrefix";
        stringArray[253] = "value";
        stringArray[254] = "getAt";
        stringArray[255] = "iterator";
        stringArray[256] = "add";
        stringArray[257] = "convertTelecom";
        stringArray[258] = "setValue";
        stringArray[259] = "setSystem";
        stringArray[260] = "setUse";
        stringArray[261] = "<$constructor$>";
        stringArray[262] = "telecomUse";
        stringArray[263] = "getAt";
        stringArray[264] = "telecomSystem";
        stringArray[265] = "getAt";
        stringArray[266] = "value";
        stringArray[267] = "getAt";
        stringArray[268] = "value";
        stringArray[269] = "getAt";
        stringArray[270] = "setUse";
        stringArray[271] = "setValue";
        stringArray[272] = "setSystem";
        stringArray[273] = "EMAIL";
        stringArray[274] = "value";
        stringArray[275] = "getAt";
        stringArray[276] = "NULL";
        stringArray[277] = "map";
        stringArray[278] = "value";
        stringArray[279] = "fromCode";
        stringArray[280] = "map";
        stringArray[281] = "value";
        stringArray[282] = "fromCode";
        stringArray[283] = "map";
        stringArray[284] = "value";
        stringArray[285] = "fromCode";
        stringArray[286] = "map";
        stringArray[287] = "value";
        stringArray[288] = "fromCode";
        stringArray[289] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[290];
        PdqResponseToPdqmResponseTranslator.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(PdqResponseToPdqmResponseTranslator.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = PdqResponseToPdqmResponseTranslator.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

