/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.iti78;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.Extension;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.NumberClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import org.hl7.fhir.instance.model.HumanName;
import org.hl7.fhir.instance.model.Patient;

@ResourceDef(name="Patient", id="pdqm", profile="http://www.ihe.net/ITI-78/Profile/pdqm")
public class PdqPatient
extends Patient {
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    public static final StringClientParam FAMILY = new StringClientParam("family");
    public static final StringClientParam GIVEN = new StringClientParam("given");
    public static final DateClientParam BIRTHDATE = new DateClientParam("birthdate");
    public static final StringClientParam ADDRESS = new StringClientParam("address");
    public static final TokenClientParam GENDER = new TokenClientParam("gender");
    public static final TokenClientParam RESOURCE_IDENTIFIER = new TokenClientParam("_id");
    public static final StringClientParam TELECOM = new StringClientParam("telecom");
    public static final NumberClientParam MULTIPLE_BIRTH_ORDER_NUMBER = new NumberClientParam("multipleBirthInteger");
    public static final StringClientParam SP_MOTHERS_MAIDEN_NAME_GIVEN = new StringClientParam("mothersMaidenName.given");
    public static final StringClientParam SP_MOTHERS_MAIDEN_NAME_FAMILY = new StringClientParam("mothersMaidenName.family");
    @Child(name="mothersMaidenName")
    @Extension(url="http://www.ihe.net/ITI-78/Profile/pdqm#mothersMaidenName", isModifier=false, definedLocally=false)
    @Description(shortDefinition="Mother's maiden name of a patient")
    private HumanName mothersMaidenName;

    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mothersMaidenName});
    }

    public HumanName getMothersMaidenName() {
        if (this.mothersMaidenName == null) {
            this.mothersMaidenName = new HumanName();
        }
        return this.mothersMaidenName;
    }

    public void setMothersMaidenName(HumanName mothersMaidenName) {
        this.mothersMaidenName = mothersMaidenName;
    }
}

