/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir;

import ca.uhn.fhir.rest.client.IGenericClient;
import ca.uhn.fhir.rest.gclient.IClientExecutable;
import ca.uhn.fhir.rest.gclient.ICriterion;
import ca.uhn.fhir.rest.gclient.IQuery;
import java.util.Map;
import org.hl7.fhir.instance.model.Bundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.openehealth.ipf.commons.ihe.fhir.ClientRequestFactory;

public class QueryClientRequestFactory
implements ClientRequestFactory<IQuery<Bundle>> {
    private final Class<? extends IBaseResource> type;

    public QueryClientRequestFactory(Class<? extends IBaseResource> type) {
        this.type = type;
    }

    @Override
    public IClientExecutable<IQuery<Bundle>, Bundle> getClientExecutable(IGenericClient client, Object requestData, Map<String, Object> parameters) {
        IQuery query = requestData instanceof ICriterion ? client.search().forResource(this.type).where((ICriterion)requestData) : client.search().byUrl(requestData.toString());
        if (parameters.containsKey("_count")) {
            query.count(Integer.parseInt(parameters.get("_count").toString()));
        }
        return query.returnBundle(Bundle.class);
    }
}

