/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir;

import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.openehealth.ipf.commons.ihe.fhir.AbstractBundleProvider;
import org.openehealth.ipf.commons.ihe.fhir.FhirValidator;
import org.openehealth.ipf.commons.ihe.fhir.RequestConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyBundleProvider
extends AbstractBundleProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LazyBundleProvider.class);
    private final boolean cacheResults;
    private int size = -1;
    private List<IBaseResource> cachedResults = new ArrayList<IBaseResource>();
    private ResultRanges resultRanges = new ResultRanges();

    public LazyBundleProvider(RequestConsumer consumer, boolean cacheResults, Object payload, Map<String, Object> headers, FhirValidator validator) {
        super(consumer, payload, headers, validator);
        this.cacheResults = cacheResults;
    }

    public List<IBaseResource> getResources(int fromIndex, int toIndex) {
        if (!this.cacheResults) {
            return this.getPartialResult(fromIndex, toIndex);
        }
        LOG.debug("Cached results contain the following ranges: {}. Requesting resources from index {} to {}", new Object[]{this.resultRanges, fromIndex, toIndex});
        Range wanted = Range.closedOpen((Comparable)Integer.valueOf(fromIndex), (Comparable)Integer.valueOf(toIndex));
        RangeSet<Integer> needed = this.resultRanges.required((Range<Integer>)wanted);
        LOG.debug("Requiring the following ranges {}", needed);
        for (Range requiredRange : needed.asDescendingSetOfRanges()) {
            LOG.debug("Now requesting the following range {}", (Object)requiredRange);
            List<IBaseResource> results = this.getPartialResult((Integer)requiredRange.lowerEndpoint(), (Integer)requiredRange.upperEndpoint());
            LOG.debug("Got back a list of size {}", (Object)results.size());
            if (results.isEmpty()) continue;
            this.cacheAll((Integer)requiredRange.lowerEndpoint(), results);
            this.resultRanges.add((Range<Integer>)Range.closedOpen((Comparable)((Integer)requiredRange.lowerEndpoint()), (Comparable)Integer.valueOf((Integer)requiredRange.lowerEndpoint() + results.size())));
        }
        LOG.debug("Cached results now contain the following ranges: {}", (Object)this.resultRanges);
        return this.cachedResults.subList(fromIndex, Math.min(this.cachedResults.size(), Math.min(this.cachedResults.size(), toIndex)));
    }

    private List<IBaseResource> getPartialResult(int fromIndex, int toIndex) {
        Map<String, Object> headers = this.getHeaders();
        headers.put("FhirFromIndex", fromIndex);
        headers.put("FhirToIndex", toIndex);
        return this.obtainResources(this.getPayload(), headers);
    }

    public int size() {
        if (!this.cacheResults || this.size < 0) {
            Map<String, Object> headers = this.getHeaders();
            headers.put("FhirRequestSizeOnly", null);
            this.size = this.getConsumer().handleSizeRequest(this.getPayload(), headers);
        }
        return this.size;
    }

    private void cacheAll(int fromIndex, List<IBaseResource> resources) {
        if (this.cachedResults.size() <= fromIndex) {
            int i = this.cachedResults.size();
            while (i < fromIndex) {
                LOG.debug("Adding null for index {}", (Object)i);
                this.cachedResults.add(null);
                ++i;
            }
            this.cachedResults.addAll(resources);
        } else {
            int i = 0;
            while (i < resources.size()) {
                this.cachedResults.set(fromIndex + i, resources.get(i));
                ++i;
            }
        }
    }

    private static class ResultRanges {
        private RangeSet<Integer> rangeSet = TreeRangeSet.create();

        private ResultRanges() {
        }

        public RangeSet<Integer> required(Range<Integer> wantedRange) {
            RangeSet intersection = this.rangeSet.subRangeSet(wantedRange);
            return TreeRangeSet.create((RangeSet)intersection.complement().subRangeSet(wantedRange));
        }

        public void add(Range<Integer> wantedRange) {
            this.rangeSet.add(wantedRange.canonical(DiscreteDomain.integers()));
        }

        public String toString() {
            return this.rangeSet.toString();
        }
    }
}

