/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir;

import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.openehealth.ipf.commons.ihe.fhir.AbstractBundleProvider;
import org.openehealth.ipf.commons.ihe.fhir.FhirValidator;
import org.openehealth.ipf.commons.ihe.fhir.RequestConsumer;

public class EagerBundleProvider
extends AbstractBundleProvider {
    private transient List<IBaseResource> resources;

    public EagerBundleProvider(RequestConsumer consumer, Object payload, Map<String, Object> headers, FhirValidator validator) {
        super(consumer, payload, headers, validator);
    }

    public List<IBaseResource> getResources(int fromIndex, int toIndex) {
        List<IBaseResource> resources = this.fetchResources();
        return resources.subList(fromIndex, Math.min(toIndex, resources.size()));
    }

    public int size() {
        return this.fetchResources().size();
    }

    private List<IBaseResource> fetchResources() {
        if (this.resources == null) {
            this.resources = this.obtainResources(this.getPayload(), this.getHeaders());
        }
        return this.resources;
    }
}

