/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.narrative.INarrativeGenerator;
import ca.uhn.fhir.rest.server.FifoMemoryPagingProvider;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.rest.server.interceptor.LoggingInterceptor;
import ca.uhn.fhir.rest.server.interceptor.ResponseHighlighterInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.openehealth.ipf.commons.ihe.fhir.AbstractPlainProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelFhirServlet
extends RestfulServer {
    private static final Logger LOG = LoggerFactory.getLogger(CamelFhirServlet.class);
    private static final Map<String, Collection<IResourceProvider>> RESOURCE_PROVIDERS = new HashMap<String, Collection<IResourceProvider>>();
    private static final Map<String, Collection<Object>> PLAIN_PROVIDERS = new HashMap<String, Collection<Object>>();
    private static final Map<String, CamelFhirServlet> SERVLETS = new HashMap<String, CamelFhirServlet>();
    private static final String SERVLET_LOGGING_PARAMETER_NAME = "logging";
    private static final String SERVLET_RESPONSE_HIGHLIGHTING_PARAMETER_NAME = "highlight";
    private static final String SERVLET_PRETTY_PRINT_PARAMETER_NAME = "pretty";
    private static final String SERVLET_PAGING_PROVIDER_SIZE_PARAMETER_NAME = "pagingProviderSize";
    private static final String SERVLET_DEFAULT_PAGE_SIZE_PARAMETER_NAME = "defaultPageSize";
    private static final String SERVLET_MAX_PAGE_SIZE_PARAMETER_NAME = "maximumPageSize";
    public static final String DEFAULT_SERVLET_NAME = "FhirServlet";
    private String servletName = "FhirServlet";
    private boolean logging;
    private boolean responseHighlighting;
    private boolean prettyPrint;
    private int pagingProviderSize = 50;
    private int defaultPageSize = 20;
    private int maximumPageSize = 100;

    public void init(ServletConfig config) throws ServletException {
        String maximumPageSizeParameter;
        String defaultPageSizeParameter;
        this.servletName = config.getServletName();
        SERVLETS.put(this.servletName, this);
        LOG.debug("Initializing CamelFhirServlet " + this.servletName);
        this.logging = Boolean.parseBoolean(config.getInitParameter(SERVLET_LOGGING_PARAMETER_NAME));
        this.responseHighlighting = Boolean.parseBoolean(config.getInitParameter(SERVLET_RESPONSE_HIGHLIGHTING_PARAMETER_NAME));
        this.prettyPrint = Boolean.parseBoolean(config.getInitParameter(SERVLET_PRETTY_PRINT_PARAMETER_NAME));
        String pagingProviderSizeParameter = config.getInitParameter(SERVLET_PAGING_PROVIDER_SIZE_PARAMETER_NAME);
        if (pagingProviderSizeParameter != null && !pagingProviderSizeParameter.isEmpty()) {
            this.pagingProviderSize = Integer.parseInt(pagingProviderSizeParameter);
        }
        if ((defaultPageSizeParameter = config.getInitParameter(SERVLET_DEFAULT_PAGE_SIZE_PARAMETER_NAME)) != null && !defaultPageSizeParameter.isEmpty()) {
            this.defaultPageSize = Integer.parseInt(defaultPageSizeParameter);
        }
        if ((maximumPageSizeParameter = config.getInitParameter(SERVLET_MAX_PAGE_SIZE_PARAMETER_NAME)) != null && !maximumPageSizeParameter.isEmpty()) {
            this.maximumPageSize = Integer.parseInt(maximumPageSizeParameter);
        }
        super.init(config);
    }

    protected IPagingProvider getDefaultPagingProvider(int pagingProviderSize) {
        FifoMemoryPagingProvider pagingProvider = new FifoMemoryPagingProvider(this.getPagingProviderSize());
        pagingProvider.setDefaultPageSize(this.getDefaultPageSize());
        pagingProvider.setMaximumPageSize(this.getMaximumPageSize());
        return pagingProvider;
    }

    protected INarrativeGenerator getDefaultNarrativeGenerator() {
        return null;
    }

    protected void initialize() throws ServletException {
        this.setFhirContext(FhirContext.forDstu2Hl7Org());
        this.setResourceProviders(RESOURCE_PROVIDERS.get(this.getServletName()));
        this.setPlainProviders(PLAIN_PROVIDERS.get(this.getServletName()));
        if (this.logging) {
            LoggingInterceptor loggingInterceptor = new LoggingInterceptor();
            this.registerInterceptor((IServerInterceptor)loggingInterceptor);
            loggingInterceptor.setLoggerName(CamelFhirServlet.class.getName());
            loggingInterceptor.setMessageFormat("Source[${remoteAddr}] Operation[${operationType} ${idOrResourceName}] User-Agent[${requestHeader.user-agent}] Params[${requestParameters}]");
        }
        if (this.responseHighlighting) {
            ResponseHighlighterInterceptor interceptor = new ResponseHighlighterInterceptor();
            this.registerInterceptor((IServerInterceptor)interceptor);
        }
        this.setPagingProvider(this.getDefaultPagingProvider(this.pagingProviderSize));
        this.setDefaultPrettyPrint(this.prettyPrint);
        this.getFhirContext().setNarrativeGenerator(this.getDefaultNarrativeGenerator());
    }

    public static synchronized void registerProvider(String name, AbstractPlainProvider provider) {
        if (provider instanceof IResourceProvider) {
            if (!RESOURCE_PROVIDERS.containsKey(name)) {
                RESOURCE_PROVIDERS.put(name, new ArrayList());
            }
            RESOURCE_PROVIDERS.get(name).add((IResourceProvider)provider);
        } else {
            if (!PLAIN_PROVIDERS.containsKey(name)) {
                PLAIN_PROVIDERS.put(name, new ArrayList());
            }
            PLAIN_PROVIDERS.get(name).add(provider);
        }
    }

    public static synchronized void unregisterProvider(String name, AbstractPlainProvider provider) throws Exception {
        if (provider instanceof IResourceProvider) {
            RESOURCE_PROVIDERS.get(name).remove(provider);
        } else {
            PLAIN_PROVIDERS.get(name).remove(provider);
        }
        SERVLETS.get(name).unregisterProvider(provider);
    }

    public String getServletName() {
        return this.servletName;
    }

    protected int getMaximumPageSize() {
        return this.maximumPageSize;
    }

    protected int getDefaultPageSize() {
        return this.defaultPageSize;
    }

    protected int getPagingProviderSize() {
        return this.pagingProviderSize;
    }
}

