/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir;

import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.server.IBundleProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.instance.model.Bundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.openehealth.ipf.commons.ihe.fhir.FhirValidator;
import org.openehealth.ipf.commons.ihe.fhir.RequestConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPlainProvider
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPlainProvider.class);
    private RequestConsumer consumer;
    private FhirValidator validator = FhirValidator.NO_VALIDATION;

    public void setValidator(FhirValidator validator) {
        this.validator = validator;
    }

    protected final <R extends IBaseResource> R requestResource(Object payload, Class<R> resultType, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.requestResource(payload, null, resultType, httpServletRequest, httpServletResponse);
    }

    protected final <R extends IBaseResource> R requestResource(Object payload, Map<String, Object> parameters, Class<R> resultType, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (this.consumer == null) {
            throw new IllegalStateException("Consumer is not initialized");
        }
        Map<String, Object> headers = this.enrichParameters(parameters, httpServletRequest);
        this.validator.validateRequest(payload, parameters);
        R response = this.consumer.handleResourceRequest(payload, headers, resultType);
        this.validator.validateResponse(response);
        return response;
    }

    protected final <R extends IBaseResource> List<R> requestBundle(Object payload, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.requestBundle(payload, null, httpServletRequest, httpServletResponse);
    }

    protected final <R extends IBaseResource> List<R> requestBundle(Object payload, Map<String, Object> parameters, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (this.consumer == null) {
            throw new IllegalStateException("Consumer is not initialized");
        }
        Map<String, Object> headers = this.enrichParameters(parameters, httpServletRequest);
        this.validator.validateRequest(payload, parameters);
        List response = this.consumer.handleBundleRequest(payload, headers);
        this.validator.validateResponse(response);
        return response;
    }

    protected final IBundleProvider requestBundleProvider(Object payload, Map<String, Object> parameters, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (this.consumer == null) {
            throw new IllegalStateException("Consumer is not initialized");
        }
        Map<String, Object> headers = this.enrichParameters(parameters, httpServletRequest);
        this.validator.validateRequest(payload, parameters);
        return this.consumer.handleBundleProviderRequest(payload, headers, this.validator);
    }

    protected final MethodOutcome requestAction(Object payload, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.requestAction(payload, null, httpServletRequest, httpServletResponse);
    }

    protected final MethodOutcome requestAction(Object payload, Map<String, Object> parameters, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (this.consumer == null) {
            throw new IllegalStateException("Consumer is not initialized");
        }
        Map<String, Object> headers = this.enrichParameters(parameters, httpServletRequest);
        this.validator.validateRequest(payload, parameters);
        MethodOutcome response = this.consumer.handleAction(payload, headers);
        this.validator.validateResponse(response);
        return response;
    }

    protected final Bundle requestTransaction(Object payload, Map<String, Object> parameters, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (this.consumer == null) {
            throw new IllegalStateException("Consumer is not initialized");
        }
        Map<String, Object> headers = this.enrichParameters(parameters, httpServletRequest);
        this.validator.validateRequest(payload, parameters);
        Bundle response = this.consumer.handleTransactionRequest(payload, headers);
        this.validator.validateResponse(response);
        return response;
    }

    private Map<String, Object> enrichParameters(Map<String, Object> parameters, HttpServletRequest httpServletRequest) {
        HashMap<String, Object> enriched = new HashMap<String, Object>();
        enriched.put("FhirHttpUri", httpServletRequest.getRequestURI());
        enriched.put("FhirHttpUrl", httpServletRequest.getRequestURL());
        enriched.put("FhirHttpMethod", httpServletRequest.getMethod());
        enriched.put("FhirHttpQuery", httpServletRequest.getQueryString());
        enriched.put("FhirHttpCharacterEncoding", httpServletRequest.getCharacterEncoding());
        enriched.put("FhirHttpContentType", httpServletRequest.getContentType());
        enriched.put("FhirHttpProtocolVersion", httpServletRequest.getProtocol());
        enriched.put("FhirHttpClientIpAddress", httpServletRequest.getRemoteAddr());
        enriched.put("FhirHttpHeaders", AbstractPlainProvider.extractHttpHeaders(httpServletRequest));
        if (parameters == null) {
            parameters = new HashMap<String, Object>();
        }
        enriched.put("FhirRequestParameters", parameters);
        return enriched;
    }

    private static Map<String, List<String>> extractHttpHeaders(HttpServletRequest httpServletRequest) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        Enumeration enumNames = httpServletRequest.getHeaderNames();
        if (enumNames != null) {
            while (enumNames.hasMoreElements()) {
                String name = (String)enumNames.nextElement();
                Enumeration enumValues = httpServletRequest.getHeaders(name);
                if (enumValues == null) continue;
                ArrayList<String> list = new ArrayList<String>();
                while (enumValues.hasMoreElements()) {
                    list.add((String)enumValues.nextElement());
                }
                if (list.isEmpty()) continue;
                result.put(name, list);
            }
        }
        return result;
    }

    public RequestConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(RequestConsumer consumer) {
        if (this.consumer != null) {
            throw new IllegalStateException("This provider is already used by a different consumer: " + consumer);
        }
        this.consumer = consumer;
        LOG.info("Connected consumer {} to provider {}", (Object)consumer, (Object)this);
    }

    public void unsetConsumer(RequestConsumer consumer) {
        if (this.consumer == consumer) {
            this.consumer = null;
            LOG.info("Disconnected consumer {} from provider {}", (Object)consumer, (Object)this);
        }
    }
}

