/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir;

import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.rest.server.IBundleProvider;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.openehealth.ipf.commons.ihe.fhir.FhirValidator;
import org.openehealth.ipf.commons.ihe.fhir.RequestConsumer;

public abstract class AbstractBundleProvider
implements IBundleProvider {
    private final RequestConsumer consumer;
    private Object payload;
    private Map<String, Object> headers;
    private FhirValidator validator;

    public AbstractBundleProvider(RequestConsumer consumer, Object payload, Map<String, Object> headers, FhirValidator validator) {
        this.consumer = consumer;
        this.payload = payload;
        this.headers = headers;
        this.validator = validator;
    }

    public InstantDt getPublished() {
        return InstantDt.withCurrentTime();
    }

    public Integer preferredPageSize() {
        return null;
    }

    protected List<IBaseResource> obtainResources(Object payload, Map<String, Object> headers) {
        List<IBaseResource> resources = this.consumer.handleBundleRequest(payload, headers);
        this.validator.validateResponse(resources);
        return resources;
    }

    protected RequestConsumer getConsumer() {
        return this.consumer;
    }

    protected Map<String, Object> getHeaders() {
        return this.headers;
    }

    protected Object getPayload() {
        return this.payload;
    }
}

