/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.translation;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openehealth.ipf.commons.ihe.fhir.translation.DefaultUriMapper;
import org.openehealth.ipf.commons.ihe.fhir.translation.UriMapper;
import org.openehealth.ipf.commons.map.BidiMappingService;
import org.openehealth.ipf.commons.map.MappingService;

public class DefaultUriMapperTest {
    private BidiMappingService mappingService;
    private UriMapper uriMapper;

    @Before
    public void setup() {
        this.mappingService = new BidiMappingService();
        this.mappingService.setMappingScript(this.getClass().getResource("/mapping.map"));
        this.uriMapper = new DefaultUriMapper((MappingService)this.mappingService, "uriToOid", "uriToNamespace");
    }

    @Test
    public void testTranslateOidUrn() throws Exception {
        String oid = "1.2.3.4.5.6.7.8.9";
        Assert.assertEquals((Object)oid, (Object)this.uriMapper.uriToOid("urn:oid:" + oid));
    }

    @Test
    public void testTranslateUriToOid() throws Exception {
        String uri = "http://org.openehealth/ipf/commons/ihe/fhir/1";
        Assert.assertEquals((Object)"1.2.3.4", (Object)this.uriMapper.uriToOid(uri));
    }

    @Test
    public void testTranslateUriToOidFails() throws Exception {
        String uri = "http://org.openehealth/ipf/commons/ihe/fhir/9";
        Assert.assertNull((Object)this.uriMapper.uriToOid(uri));
    }

    @Test
    public void testTranslatePinUrn() throws Exception {
        String namespace = "namespace";
        Assert.assertEquals((Object)namespace, (Object)this.uriMapper.uriToNamespace("urn:pin:" + namespace));
    }

    @Test
    public void testTranslateUriToNamespace() throws Exception {
        String namespace = "http://org.openehealth/ipf/commons/ihe/fhir/1";
        Assert.assertEquals((Object)"fhir1", (Object)this.uriMapper.uriToNamespace(namespace));
        namespace = "http://org.openehealth/ipf/commons/ihe/fhir/9";
        Assert.assertNull((Object)this.uriMapper.uriToNamespace(namespace));
    }
}

