/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir;

import org.hl7.fhir.exceptions.FHIRException;

public enum ObjectType {
    _1("1", "Person", "Person"),
    _2("2", "System Object", "System Object"),
    _3("3", "Organization", "Organization"),
    _4("4", "Other", "Other"),
    NULL(null, "?", "?");

    private String code;
    private String definition;
    private String display;

    private ObjectType(String code, String definition, String display) {
        this.code = code;
        this.definition = definition;
        this.display = display;
    }

    public static ObjectType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        ObjectType[] objectTypeArray = ObjectType.values();
        int n = objectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectType objectType = objectTypeArray[n2];
            if (objectType.code.equals(codeString)) {
                return objectType;
            }
            ++n2;
        }
        throw new FHIRException("Unknown V3NullFlavor code '" + codeString + "'");
    }

    public String toCode() {
        return this.code;
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getDisplay() {
        return this.display;
    }

    public String getSystem() {
        return "http://hl7.org/fhir/object-type";
    }
}

