/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.pharm5;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.util.UrlUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.openehealth.ipf.commons.ihe.fhir.FhirSearchAndSortParameters;
import org.openehealth.ipf.commons.ihe.fhir.pharm5.Pharm5Operations;

public class Pharm5SearchParameters
extends FhirSearchAndSortParameters<DocumentReference> {
    private TokenParam patientIdentifier;
    private DateRangeParam date;
    private StringParam authorFamilyName;
    private StringParam authorGivenName;
    private TokenParam identifier;
    private TokenOrListParam status;
    private TokenOrListParam setting;
    private DateRangeParam period;
    private TokenOrListParam facility;
    private TokenOrListParam event;
    private TokenOrListParam securityLabel;
    private TokenOrListParam format;
    private Pharm5Operations operation;
    private SortSpec sortSpec;
    private Set<Include> includeSpec;
    private final FhirContext fhirContext;
    private static final Comparator<DocumentReference> CP_DATE = Comparator.nullsLast(Comparator.comparing(DocumentReference::getDate));
    private static final Comparator<DocumentReference> CP_AUTHOR = Comparator.nullsLast(Comparator.comparing(documentReference -> {
        if (!documentReference.hasAuthor()) {
            return null;
        }
        Reference author = documentReference.getAuthorFirstRep();
        if (author.getResource() instanceof PractitionerRole) {
            PractitionerRole practitionerRole = (PractitionerRole)author.getResource();
            if (!practitionerRole.hasPractitioner()) {
                return null;
            }
            author = practitionerRole.getPractitioner();
        }
        if (author.getResource() == null) {
            return null;
        }
        if (author.getResource() instanceof Practitioner) {
            Practitioner practitioner = (Practitioner)author.getResource();
            if (!practitioner.hasName()) {
                return null;
            }
            HumanName name = practitioner.getNameFirstRep();
            return name.getFamilyElement().getValueNotNull() + name.getGivenAsSingleString();
        }
        return null;
    }));

    public List<TokenParam> getPatientIdParam() {
        return this.patientIdentifier != null ? List.of(this.patientIdentifier) : Collections.emptyList();
    }

    public Pharm5SearchParameters setAuthor(ReferenceAndListParam author) {
        if (author != null) {
            author.getValuesAsQueryTokens().forEach(param -> {
                ReferenceParam ref = (ReferenceParam)param.getValuesAsQueryTokens().get(0);
                String authorChain = ref.getChain();
                if ("family".equals(authorChain)) {
                    this.setAuthorFamilyName(ref.toStringParam(this.getFhirContext()));
                } else if ("given".equals(authorChain)) {
                    this.setAuthorGivenName(ref.toStringParam(this.getFhirContext()));
                }
            });
        }
        return this;
    }

    public Optional<Comparator<DocumentReference>> comparatorFor(String paramName) {
        if ("date".equals(paramName)) {
            return Optional.of(CP_DATE);
        }
        if ("author".equals(paramName)) {
            return Optional.of(CP_AUTHOR);
        }
        return Optional.empty();
    }

    public String getQueryString(FhirContext context) {
        return this.patientIdentifier.getValueAsQueryToken(context);
    }

    public Parameters toParameters() {
        StringBuilder b;
        Parameters parameters = new Parameters();
        if (this.getPatientIdentifier() != null) {
            parameters.addParameter("patient.identifier", (Type)new StringType(this.getPatientIdentifier().getValueAsQueryToken(this.fhirContext)));
        }
        if (this.getDate() != null) {
            this.getDate().getValuesAsQueryTokens().forEach(dateParam -> parameters.addParameter("date", (Type)new StringType(dateParam.getValueAsQueryToken(this.fhirContext))));
        }
        if (this.getAuthorFamilyName() != null) {
            parameters.addParameter("author.family", (Type)new StringType(this.getAuthorFamilyName().getValueAsQueryToken(this.fhirContext)));
        }
        if (this.getAuthorGivenName() != null) {
            parameters.addParameter("author.given", (Type)new StringType(this.getAuthorGivenName().getValueAsQueryToken(this.fhirContext)));
        }
        if (this.getIdentifier() != null) {
            parameters.addParameter("identifier", (Type)new StringType(this.getIdentifier().getValueAsQueryToken(this.fhirContext)));
        }
        if (this.getStatus() != null) {
            parameters.addParameter("status", (Type)new StringType(this.getStatus().getValuesAsQueryTokens().stream().map(tokenParam -> tokenParam.getValueAsQueryToken(this.fhirContext)).collect(Collectors.joining(","))));
        }
        if (this.getSetting() != null) {
            parameters.addParameter("setting", (Type)new StringType(this.getSetting().getValuesAsQueryTokens().stream().map(tokenParam -> tokenParam.getValueAsQueryToken(this.fhirContext)).collect(Collectors.joining(","))));
        }
        if (this.getPeriod() != null) {
            this.getPeriod().getValuesAsQueryTokens().forEach(dateParam -> parameters.addParameter("period", (Type)new StringType(dateParam.getValueAsQueryToken(this.fhirContext))));
        }
        if (this.getFacility() != null) {
            parameters.addParameter("facility", (Type)new StringType(this.getFacility().getValuesAsQueryTokens().stream().map(tokenParam -> tokenParam.getValueAsQueryToken(this.fhirContext)).collect(Collectors.joining(","))));
        }
        if (this.getEvent() != null) {
            parameters.addParameter("event", (Type)new StringType(this.getEvent().getValuesAsQueryTokens().stream().map(tokenParam -> tokenParam.getValueAsQueryToken(this.fhirContext)).collect(Collectors.joining(","))));
        }
        if (this.getSecurityLabel() != null) {
            parameters.addParameter("security-label", (Type)new StringType(this.getSecurityLabel().getValuesAsQueryTokens().stream().map(tokenParam -> tokenParam.getValueAsQueryToken(this.fhirContext)).collect(Collectors.joining(","))));
        }
        if (this.getFormat() != null) {
            parameters.addParameter("format", (Type)new StringType(this.getFormat().getValuesAsQueryTokens().stream().map(tokenParam -> tokenParam.getValueAsQueryToken(this.fhirContext)).collect(Collectors.joining(","))));
        }
        if (this.getSortSpec() != null) {
            boolean first = true;
            b = new StringBuilder();
            for (SortSpec sort = this.getSortSpec(); sort != null; sort = sort.getChain()) {
                if (!first) {
                    b.append(',');
                }
                if (sort.getOrder() == SortOrderEnum.DESC) {
                    b.append('-');
                }
                b.append(sort.getParamName());
                first = false;
            }
            parameters.addParameter("_sort", (Type)new StringType(b.toString()));
        }
        if (this.getIncludeSpec() != null) {
            for (Include nextInclude : this.getIncludeSpec()) {
                b = new StringBuilder();
                b.append(UrlUtil.escapeUrlParam((String)nextInclude.getParamType()));
                b.append(':');
                b.append(UrlUtil.escapeUrlParam((String)nextInclude.getParamName()));
                if (StringUtils.isNotBlank((CharSequence)nextInclude.getParamTargetType())) {
                    b.append(':');
                    b.append(nextInclude.getParamTargetType());
                }
                String paramName = nextInclude.isRecurse() ? "_include:iterate" : "_include";
                parameters.addParameter(paramName, (Type)new StringType(b.toString()));
            }
        }
        return parameters;
    }

    @Generated
    public static Pharm5SearchParametersBuilder builder() {
        return new Pharm5SearchParametersBuilder();
    }

    @Generated
    public String toString() {
        return "Pharm5SearchParameters(patientIdentifier=" + this.getPatientIdentifier() + ", date=" + this.getDate() + ", authorFamilyName=" + this.getAuthorFamilyName() + ", authorGivenName=" + this.getAuthorGivenName() + ", identifier=" + this.getIdentifier() + ", status=" + this.getStatus() + ", setting=" + this.getSetting() + ", period=" + this.getPeriod() + ", facility=" + this.getFacility() + ", event=" + this.getEvent() + ", securityLabel=" + this.getSecurityLabel() + ", format=" + this.getFormat() + ", operation=" + this.getOperation() + ", sortSpec=" + this.getSortSpec() + ", includeSpec=" + this.getIncludeSpec() + ", fhirContext=" + this.getFhirContext() + ")";
    }

    @Generated
    public Pharm5SearchParameters(TokenParam patientIdentifier, DateRangeParam date, StringParam authorFamilyName, StringParam authorGivenName, TokenParam identifier, TokenOrListParam status, TokenOrListParam setting, DateRangeParam period, TokenOrListParam facility, TokenOrListParam event, TokenOrListParam securityLabel, TokenOrListParam format, Pharm5Operations operation, SortSpec sortSpec, Set<Include> includeSpec, FhirContext fhirContext) {
        this.patientIdentifier = patientIdentifier;
        this.date = date;
        this.authorFamilyName = authorFamilyName;
        this.authorGivenName = authorGivenName;
        this.identifier = identifier;
        this.status = status;
        this.setting = setting;
        this.period = period;
        this.facility = facility;
        this.event = event;
        this.securityLabel = securityLabel;
        this.format = format;
        this.operation = operation;
        this.sortSpec = sortSpec;
        this.includeSpec = includeSpec;
        this.fhirContext = fhirContext;
    }

    @Generated
    public TokenParam getPatientIdentifier() {
        return this.patientIdentifier;
    }

    @Generated
    public void setPatientIdentifier(TokenParam patientIdentifier) {
        this.patientIdentifier = patientIdentifier;
    }

    @Generated
    public DateRangeParam getDate() {
        return this.date;
    }

    @Generated
    public void setDate(DateRangeParam date) {
        this.date = date;
    }

    @Generated
    public StringParam getAuthorFamilyName() {
        return this.authorFamilyName;
    }

    @Generated
    public void setAuthorFamilyName(StringParam authorFamilyName) {
        this.authorFamilyName = authorFamilyName;
    }

    @Generated
    public StringParam getAuthorGivenName() {
        return this.authorGivenName;
    }

    @Generated
    public void setAuthorGivenName(StringParam authorGivenName) {
        this.authorGivenName = authorGivenName;
    }

    @Generated
    public TokenParam getIdentifier() {
        return this.identifier;
    }

    @Generated
    public void setIdentifier(TokenParam identifier) {
        this.identifier = identifier;
    }

    @Generated
    public TokenOrListParam getStatus() {
        return this.status;
    }

    @Generated
    public void setStatus(TokenOrListParam status) {
        this.status = status;
    }

    @Generated
    public TokenOrListParam getSetting() {
        return this.setting;
    }

    @Generated
    public void setSetting(TokenOrListParam setting) {
        this.setting = setting;
    }

    @Generated
    public DateRangeParam getPeriod() {
        return this.period;
    }

    @Generated
    public void setPeriod(DateRangeParam period) {
        this.period = period;
    }

    @Generated
    public TokenOrListParam getFacility() {
        return this.facility;
    }

    @Generated
    public void setFacility(TokenOrListParam facility) {
        this.facility = facility;
    }

    @Generated
    public TokenOrListParam getEvent() {
        return this.event;
    }

    @Generated
    public void setEvent(TokenOrListParam event) {
        this.event = event;
    }

    @Generated
    public TokenOrListParam getSecurityLabel() {
        return this.securityLabel;
    }

    @Generated
    public void setSecurityLabel(TokenOrListParam securityLabel) {
        this.securityLabel = securityLabel;
    }

    @Generated
    public TokenOrListParam getFormat() {
        return this.format;
    }

    @Generated
    public void setFormat(TokenOrListParam format) {
        this.format = format;
    }

    @Generated
    public Pharm5Operations getOperation() {
        return this.operation;
    }

    @Generated
    public void setOperation(Pharm5Operations operation) {
        this.operation = operation;
    }

    @Generated
    public SortSpec getSortSpec() {
        return this.sortSpec;
    }

    @Generated
    public void setSortSpec(SortSpec sortSpec) {
        this.sortSpec = sortSpec;
    }

    @Generated
    public Set<Include> getIncludeSpec() {
        return this.includeSpec;
    }

    @Generated
    public void setIncludeSpec(Set<Include> includeSpec) {
        this.includeSpec = includeSpec;
    }

    @Generated
    public FhirContext getFhirContext() {
        return this.fhirContext;
    }

    @Generated
    public static class Pharm5SearchParametersBuilder {
        @Generated
        private TokenParam patientIdentifier;
        @Generated
        private DateRangeParam date;
        @Generated
        private StringParam authorFamilyName;
        @Generated
        private StringParam authorGivenName;
        @Generated
        private TokenParam identifier;
        @Generated
        private TokenOrListParam status;
        @Generated
        private TokenOrListParam setting;
        @Generated
        private DateRangeParam period;
        @Generated
        private TokenOrListParam facility;
        @Generated
        private TokenOrListParam event;
        @Generated
        private TokenOrListParam securityLabel;
        @Generated
        private TokenOrListParam format;
        @Generated
        private Pharm5Operations operation;
        @Generated
        private SortSpec sortSpec;
        @Generated
        private Set<Include> includeSpec;
        @Generated
        private FhirContext fhirContext;

        @Generated
        Pharm5SearchParametersBuilder() {
        }

        @Generated
        public Pharm5SearchParametersBuilder patientIdentifier(TokenParam patientIdentifier) {
            this.patientIdentifier = patientIdentifier;
            return this;
        }

        @Generated
        public Pharm5SearchParametersBuilder date(DateRangeParam date) {
            this.date = date;
            return this;
        }

        @Generated
        public Pharm5SearchParametersBuilder authorFamilyName(StringParam authorFamilyName) {
            this.authorFamilyName = authorFamilyName;
            return this;
        }

        @Generated
        public Pharm5SearchParametersBuilder authorGivenName(StringParam authorGivenName) {
            this.authorGivenName = authorGivenName;
            return this;
        }

        @Generated
        public Pharm5SearchParametersBuilder identifier(TokenParam identifier) {
            this.identifier = identifier;
            return this;
        }

        @Generated
        public Pharm5SearchParametersBuilder status(TokenOrListParam status) {
            this.status = status;
            return this;
        }

        @Generated
        public Pharm5SearchParametersBuilder setting(TokenOrListParam setting) {
            this.setting = setting;
            return this;
        }

        @Generated
        public Pharm5SearchParametersBuilder period(DateRangeParam period) {
            this.period = period;
            return this;
        }

        @Generated
        public Pharm5SearchParametersBuilder facility(TokenOrListParam facility) {
            this.facility = facility;
            return this;
        }

        @Generated
        public Pharm5SearchParametersBuilder event(TokenOrListParam event) {
            this.event = event;
            return this;
        }

        @Generated
        public Pharm5SearchParametersBuilder securityLabel(TokenOrListParam securityLabel) {
            this.securityLabel = securityLabel;
            return this;
        }

        @Generated
        public Pharm5SearchParametersBuilder format(TokenOrListParam format) {
            this.format = format;
            return this;
        }

        @Generated
        public Pharm5SearchParametersBuilder operation(Pharm5Operations operation) {
            this.operation = operation;
            return this;
        }

        @Generated
        public Pharm5SearchParametersBuilder sortSpec(SortSpec sortSpec) {
            this.sortSpec = sortSpec;
            return this;
        }

        @Generated
        public Pharm5SearchParametersBuilder includeSpec(Set<Include> includeSpec) {
            this.includeSpec = includeSpec;
            return this;
        }

        @Generated
        public Pharm5SearchParametersBuilder fhirContext(FhirContext fhirContext) {
            this.fhirContext = fhirContext;
            return this;
        }

        @Generated
        public Pharm5SearchParameters build() {
            return new Pharm5SearchParameters(this.patientIdentifier, this.date, this.authorFamilyName, this.authorGivenName, this.identifier, this.status, this.setting, this.period, this.facility, this.event, this.securityLabel, this.format, this.operation, this.sortSpec, this.includeSpec, this.fhirContext);
        }

        @Generated
        public String toString() {
            return "Pharm5SearchParameters.Pharm5SearchParametersBuilder(patientIdentifier=" + this.patientIdentifier + ", date=" + this.date + ", authorFamilyName=" + this.authorFamilyName + ", authorGivenName=" + this.authorGivenName + ", identifier=" + this.identifier + ", status=" + this.status + ", setting=" + this.setting + ", period=" + this.period + ", facility=" + this.facility + ", event=" + this.event + ", securityLabel=" + this.securityLabel + ", format=" + this.format + ", operation=" + this.operation + ", sortSpec=" + this.sortSpec + ", includeSpec=" + this.includeSpec + ", fhirContext=" + this.fhirContext + ")";
        }
    }
}

