/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.mhd;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.DefaultProfileValidationSupport;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.IValidatorModule;
import ca.uhn.fhir.validation.ValidationResult;
import java.io.IOException;
import java.util.Map;
import org.hl7.fhir.common.hapi.validation.support.CachingValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.CommonCodeSystemsTerminologyService;
import org.hl7.fhir.common.hapi.validation.support.InMemoryTerminologyServerValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.NpmPackageValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.SnapshotGeneratingValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.ValidationSupportChain;
import org.hl7.fhir.common.hapi.validation.validator.FhirInstanceValidator;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.utils.validation.constants.BestPracticeWarningLevel;
import org.openehealth.ipf.commons.ihe.fhir.FhirTransactionValidator;
import org.openehealth.ipf.commons.ihe.fhir.support.FhirUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MhdValidator
extends FhirTransactionValidator.Support {
    private static final Logger log = LoggerFactory.getLogger(MhdValidator.class);
    private final FhirValidator validator;

    public MhdValidator(FhirContext fhirContext) {
        log.info("Initializing Validator for MHD");
        ValidationSupportChain supportChain = new ValidationSupportChain();
        supportChain.addValidationSupport((IValidationSupport)new DefaultProfileValidationSupport(fhirContext));
        supportChain.addValidationSupport((IValidationSupport)new SnapshotGeneratingValidationSupport(fhirContext));
        supportChain.addValidationSupport((IValidationSupport)new CommonCodeSystemsTerminologyService(fhirContext));
        supportChain.addValidationSupport((IValidationSupport)new InMemoryTerminologyServerValidationSupport(fhirContext));
        try {
            NpmPackageValidationSupport npmPackageValidationSupport = new NpmPackageValidationSupport(fhirContext);
            npmPackageValidationSupport.loadPackageFromClasspath("classpath:META-INF/profiles/v421/ihe.iti.mhd.tgz");
            supportChain.addValidationSupport((IValidationSupport)npmPackageValidationSupport);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        FhirInstanceValidator instanceValidator = new FhirInstanceValidator((IValidationSupport)new CachingValidationSupport((IValidationSupport)supportChain));
        instanceValidator.setNoTerminologyChecks(false);
        instanceValidator.setErrorForUnknownProfiles(true);
        instanceValidator.setBestPracticeWarningLevel(BestPracticeWarningLevel.Hint);
        instanceValidator.setAnyExtensionsAllowed(true);
        this.validator = fhirContext.newValidator().setValidateAgainstStandardSchema(false).setValidateAgainstStandardSchematron(false).setConcurrentBundleValidation(true).registerValidatorModule((IValidatorModule)instanceValidator);
        log.info("Initialized Validator for MHD bundles");
    }

    public void validateRequest(Object payload, Map<String, Object> parameters) {
        IBaseResource resource = (IBaseResource)payload;
        ValidationResult validationResult = this.validator.validateWithResult(resource);
        if (!validationResult.isSuccessful()) {
            IBaseOperationOutcome operationOutcome = validationResult.toOperationOutcome();
            throw (UnprocessableEntityException)FhirUtils.exception(UnprocessableEntityException::new, (IBaseOperationOutcome)operationOutcome, (String)"Validation Failed", (Object[])new Object[0]);
        }
    }
}

