/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.mhd;

import ca.uhn.fhir.context.FhirContext;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Resource;
import org.openehealth.ipf.commons.ihe.fhir.mhd.MhdConstants;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.ComprehensiveDocumentReference;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.ComprehensiveFolderList;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.ComprehensiveProvideDocumentBundle;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.ComprehensiveSubmissionSetList;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.FindComprehensiveDocumentReferencesResponseBundle;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.FindDocumentListsResponseBundle;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.FindMinimalDocumentReferencesResponseBundle;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.MhdList;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.MinimalDocumentReference;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.MinimalFolderList;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.MinimalProvideDocumentBundle;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.MinimalSubmissionSetList;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.ProvideDocumentBundleResponse;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.SimplifiedPublishDocumentReference;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.UncontainedComprehensiveDocumentReference;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.UncontainedComprehensiveProvideDocumentBundle;

public enum MhdProfiles implements MhdConstants
{
    ITI65_MINIMAL_BUNDLE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Minimal.ProvideBundle", MinimalProvideDocumentBundle.class),
    ITI65_COMPREHENSIVE_BUNDLE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Comprehensive.ProvideBundle", ComprehensiveProvideDocumentBundle.class),
    ITI65_UNCONTAINED_COMPREHENSIVE_BUNDLE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.UnContained.Comprehensive.ProvideBundle", UncontainedComprehensiveProvideDocumentBundle.class),
    ITI65_PROVIDE_DOCUMENT_BUNDLE_RESPONSE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.ProvideDocumentBundleResponse", ProvideDocumentBundleResponse.class),
    ITI66_FIND_DOCUMENT_LISTS_RESPONSE_BUNDLE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.FindDocumentListsResponseMessage", FindDocumentListsResponseBundle.class),
    ITI67_FIND_DOCUMENT_REFERENCES_RESPONSE_BUNDLE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.FindDocumentReferencesResponseMessage", FindMinimalDocumentReferencesResponseBundle.class),
    ITI67_FIND_DOCUMENT_REFERENCES_COMPREHENSIVE_RESPONSE_BUNDLE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.FindDocumentReferencesComprehensiveResponseMessage", FindComprehensiveDocumentReferencesResponseBundle.class),
    MHD_LIST("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.List", MhdList.class),
    COMPREHENSIVE_SUBMISSIONSET_TYPE_LIST("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Comprehensive.SubmissionSet", ComprehensiveSubmissionSetList.class),
    UNCONTAINED_COMPREHENSIVE_SUBMISSIONSET_TYPE_LIST("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.UnContained.Comprehensive.SubmissionSet", UncontainedComprehensiveProvideDocumentBundle.class),
    MINIMAL_SUBMISSIONSET_TYPE_LIST("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Minimal.SubmissionSet", MinimalSubmissionSetList.class),
    MINIMAL_FOLDER_TYPE_LIST("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Minimal.Folder", MinimalFolderList.class),
    COMPREHENSIVE_FOLDER_TYPE_LIST("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Comprehensive.Folder", ComprehensiveFolderList.class),
    COMPREHENSIVE_DOCUMENT_REFERENCE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Comprehensive.DocumentReference", ComprehensiveDocumentReference.class),
    UNCONTAINED_COMPREHENSIVE_DOCUMENT_REFERENCE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.UnContained.Comprehensive.DocumentReference", UncontainedComprehensiveDocumentReference.class),
    MINIMAL_DOCUMENT_REFERENCE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Minimal.DocumentReference", MinimalDocumentReference.class),
    SIMPLIFIED_PUBLISH_DOCUMENT_REFERENCE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.SimplifiedPublish.DocumentReference", SimplifiedPublishDocumentReference.class);

    private final String url;
    private final Class<? extends IBaseResource> resourceClass;

    private MhdProfiles(String url, Class<? extends IBaseResource> resourceClass) {
        this.url = url;
        this.resourceClass = resourceClass;
    }

    public void setProfile(Resource resource) {
        resource.getMeta().setProfile(List.of(new CanonicalType(this.url)));
    }

    public static void registerDefaultTypes(FhirContext fhirContext) {
        Arrays.stream(MhdProfiles.values()).forEach(profile -> fhirContext.setDefaultTypeForProfile(profile.getUrl(), profile.resourceClass));
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public Class<? extends IBaseResource> getResourceClass() {
        return this.resourceClass;
    }
}

