/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.iti67;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.ReferenceOrListParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Reference;
import org.openehealth.ipf.commons.ihe.fhir.FhirSearchAndSortParameters;

public class Iti67SearchParameters
extends FhirSearchAndSortParameters<DocumentReference> {
    private ReferenceParam patientReference;
    private TokenParam patientIdentifier;
    private DateRangeParam date;
    private StringParam authorFamilyName;
    private StringParam authorGivenName;
    private TokenParam authorIdentifier;
    private TokenParam identifier;
    private TokenOrListParam status;
    private TokenOrListParam category;
    private TokenOrListParam type;
    private TokenOrListParam setting;
    private DateRangeParam period;
    private TokenOrListParam facility;
    private TokenOrListParam event;
    private TokenOrListParam securityLabel;
    private TokenOrListParam format;
    private ReferenceOrListParam related;
    private TokenOrListParam relatedId;
    private TokenParam _id;
    private SortSpec sortSpec;
    private Set<Include> includeSpec;
    private final FhirContext fhirContext;
    private static final Comparator<DocumentReference> CP_DATE = Comparator.nullsLast(Comparator.comparing(DocumentReference::getDate));
    private static final Comparator<DocumentReference> CP_AUTHOR = Comparator.nullsLast(Comparator.comparing(documentReference -> {
        if (!documentReference.hasAuthor()) {
            return null;
        }
        Reference author = documentReference.getAuthorFirstRep();
        if (author.getResource() instanceof PractitionerRole) {
            PractitionerRole practitionerRole = (PractitionerRole)author.getResource();
            if (!practitionerRole.hasPractitioner()) {
                return null;
            }
            author = practitionerRole.getPractitioner();
        }
        if (author.getResource() == null) {
            return null;
        }
        if (author.getResource() instanceof Practitioner) {
            Practitioner practitioner = (Practitioner)author.getResource();
            if (!practitioner.hasName()) {
                return null;
            }
            HumanName name = practitioner.getNameFirstRep();
            return name.getFamilyElement().getValueNotNull() + name.getGivenAsSingleString();
        }
        return null;
    }));

    public List<TokenParam> getPatientIdParam() {
        if (this._id != null) {
            return Collections.singletonList(this._id);
        }
        if (this.patientReference != null) {
            return Collections.singletonList(this.patientReference.toTokenParam(this.fhirContext));
        }
        return Collections.singletonList(this.patientIdentifier);
    }

    public Iti67SearchParameters setAuthor(ReferenceAndListParam author) {
        if (author != null) {
            author.getValuesAsQueryTokens().forEach(param -> {
                ReferenceParam ref = (ReferenceParam)param.getValuesAsQueryTokens().get(0);
                String authorChain = ref.getChain();
                if ("family".equals(authorChain)) {
                    this.setAuthorFamilyName(ref.toStringParam(this.getFhirContext()));
                } else if ("given".equals(authorChain)) {
                    this.setAuthorGivenName(ref.toStringParam(this.getFhirContext()));
                } else if ("identifier".equals(authorChain)) {
                    this.setAuthorIdentifier(ref.toTokenParam(this.getFhirContext()));
                }
            });
        }
        return this;
    }

    public Optional<Comparator<DocumentReference>> comparatorFor(String paramName) {
        if ("date".equals(paramName) || "indexed".equals(paramName)) {
            return Optional.of(CP_DATE);
        }
        if ("author".equals(paramName)) {
            return Optional.of(CP_AUTHOR);
        }
        return Optional.empty();
    }

    @Generated
    public static Iti67SearchParametersBuilder builder() {
        return new Iti67SearchParametersBuilder();
    }

    @Generated
    public String toString() {
        return "Iti67SearchParameters(patientReference=" + this.getPatientReference() + ", patientIdentifier=" + this.getPatientIdentifier() + ", date=" + this.getDate() + ", authorFamilyName=" + this.getAuthorFamilyName() + ", authorGivenName=" + this.getAuthorGivenName() + ", authorIdentifier=" + this.getAuthorIdentifier() + ", identifier=" + this.getIdentifier() + ", status=" + this.getStatus() + ", category=" + this.getCategory() + ", type=" + this.getType() + ", setting=" + this.getSetting() + ", period=" + this.getPeriod() + ", facility=" + this.getFacility() + ", event=" + this.getEvent() + ", securityLabel=" + this.getSecurityLabel() + ", format=" + this.getFormat() + ", related=" + this.getRelated() + ", relatedId=" + this.getRelatedId() + ", _id=" + this.get_id() + ", sortSpec=" + this.getSortSpec() + ", includeSpec=" + this.getIncludeSpec() + ", fhirContext=" + this.getFhirContext() + ")";
    }

    @Generated
    public Iti67SearchParameters(ReferenceParam patientReference, TokenParam patientIdentifier, DateRangeParam date, StringParam authorFamilyName, StringParam authorGivenName, TokenParam authorIdentifier, TokenParam identifier, TokenOrListParam status, TokenOrListParam category, TokenOrListParam type, TokenOrListParam setting, DateRangeParam period, TokenOrListParam facility, TokenOrListParam event, TokenOrListParam securityLabel, TokenOrListParam format, ReferenceOrListParam related, TokenOrListParam relatedId, TokenParam _id, SortSpec sortSpec, Set<Include> includeSpec, FhirContext fhirContext) {
        this.patientReference = patientReference;
        this.patientIdentifier = patientIdentifier;
        this.date = date;
        this.authorFamilyName = authorFamilyName;
        this.authorGivenName = authorGivenName;
        this.authorIdentifier = authorIdentifier;
        this.identifier = identifier;
        this.status = status;
        this.category = category;
        this.type = type;
        this.setting = setting;
        this.period = period;
        this.facility = facility;
        this.event = event;
        this.securityLabel = securityLabel;
        this.format = format;
        this.related = related;
        this.relatedId = relatedId;
        this._id = _id;
        this.sortSpec = sortSpec;
        this.includeSpec = includeSpec;
        this.fhirContext = fhirContext;
    }

    @Generated
    public ReferenceParam getPatientReference() {
        return this.patientReference;
    }

    @Generated
    public void setPatientReference(ReferenceParam patientReference) {
        this.patientReference = patientReference;
    }

    @Generated
    public TokenParam getPatientIdentifier() {
        return this.patientIdentifier;
    }

    @Generated
    public void setPatientIdentifier(TokenParam patientIdentifier) {
        this.patientIdentifier = patientIdentifier;
    }

    @Generated
    public DateRangeParam getDate() {
        return this.date;
    }

    @Generated
    public void setDate(DateRangeParam date) {
        this.date = date;
    }

    @Generated
    public StringParam getAuthorFamilyName() {
        return this.authorFamilyName;
    }

    @Generated
    public void setAuthorFamilyName(StringParam authorFamilyName) {
        this.authorFamilyName = authorFamilyName;
    }

    @Generated
    public StringParam getAuthorGivenName() {
        return this.authorGivenName;
    }

    @Generated
    public void setAuthorGivenName(StringParam authorGivenName) {
        this.authorGivenName = authorGivenName;
    }

    @Generated
    public TokenParam getAuthorIdentifier() {
        return this.authorIdentifier;
    }

    @Generated
    public void setAuthorIdentifier(TokenParam authorIdentifier) {
        this.authorIdentifier = authorIdentifier;
    }

    @Generated
    public TokenParam getIdentifier() {
        return this.identifier;
    }

    @Generated
    public void setIdentifier(TokenParam identifier) {
        this.identifier = identifier;
    }

    @Generated
    public TokenOrListParam getStatus() {
        return this.status;
    }

    @Generated
    public void setStatus(TokenOrListParam status) {
        this.status = status;
    }

    @Generated
    public TokenOrListParam getCategory() {
        return this.category;
    }

    @Generated
    public void setCategory(TokenOrListParam category) {
        this.category = category;
    }

    @Generated
    public TokenOrListParam getType() {
        return this.type;
    }

    @Generated
    public void setType(TokenOrListParam type) {
        this.type = type;
    }

    @Generated
    public TokenOrListParam getSetting() {
        return this.setting;
    }

    @Generated
    public void setSetting(TokenOrListParam setting) {
        this.setting = setting;
    }

    @Generated
    public DateRangeParam getPeriod() {
        return this.period;
    }

    @Generated
    public void setPeriod(DateRangeParam period) {
        this.period = period;
    }

    @Generated
    public TokenOrListParam getFacility() {
        return this.facility;
    }

    @Generated
    public void setFacility(TokenOrListParam facility) {
        this.facility = facility;
    }

    @Generated
    public TokenOrListParam getEvent() {
        return this.event;
    }

    @Generated
    public void setEvent(TokenOrListParam event) {
        this.event = event;
    }

    @Generated
    public TokenOrListParam getSecurityLabel() {
        return this.securityLabel;
    }

    @Generated
    public void setSecurityLabel(TokenOrListParam securityLabel) {
        this.securityLabel = securityLabel;
    }

    @Generated
    public TokenOrListParam getFormat() {
        return this.format;
    }

    @Generated
    public void setFormat(TokenOrListParam format) {
        this.format = format;
    }

    @Generated
    public ReferenceOrListParam getRelated() {
        return this.related;
    }

    @Generated
    public void setRelated(ReferenceOrListParam related) {
        this.related = related;
    }

    @Generated
    public TokenOrListParam getRelatedId() {
        return this.relatedId;
    }

    @Generated
    public void setRelatedId(TokenOrListParam relatedId) {
        this.relatedId = relatedId;
    }

    @Generated
    public TokenParam get_id() {
        return this._id;
    }

    @Generated
    public void set_id(TokenParam _id) {
        this._id = _id;
    }

    @Generated
    public SortSpec getSortSpec() {
        return this.sortSpec;
    }

    @Generated
    public void setSortSpec(SortSpec sortSpec) {
        this.sortSpec = sortSpec;
    }

    @Generated
    public Set<Include> getIncludeSpec() {
        return this.includeSpec;
    }

    @Generated
    public void setIncludeSpec(Set<Include> includeSpec) {
        this.includeSpec = includeSpec;
    }

    @Generated
    public FhirContext getFhirContext() {
        return this.fhirContext;
    }

    @Generated
    public static class Iti67SearchParametersBuilder {
        @Generated
        private ReferenceParam patientReference;
        @Generated
        private TokenParam patientIdentifier;
        @Generated
        private DateRangeParam date;
        @Generated
        private StringParam authorFamilyName;
        @Generated
        private StringParam authorGivenName;
        @Generated
        private TokenParam authorIdentifier;
        @Generated
        private TokenParam identifier;
        @Generated
        private TokenOrListParam status;
        @Generated
        private TokenOrListParam category;
        @Generated
        private TokenOrListParam type;
        @Generated
        private TokenOrListParam setting;
        @Generated
        private DateRangeParam period;
        @Generated
        private TokenOrListParam facility;
        @Generated
        private TokenOrListParam event;
        @Generated
        private TokenOrListParam securityLabel;
        @Generated
        private TokenOrListParam format;
        @Generated
        private ReferenceOrListParam related;
        @Generated
        private TokenOrListParam relatedId;
        @Generated
        private TokenParam _id;
        @Generated
        private SortSpec sortSpec;
        @Generated
        private Set<Include> includeSpec;
        @Generated
        private FhirContext fhirContext;

        @Generated
        Iti67SearchParametersBuilder() {
        }

        @Generated
        public Iti67SearchParametersBuilder patientReference(ReferenceParam patientReference) {
            this.patientReference = patientReference;
            return this;
        }

        @Generated
        public Iti67SearchParametersBuilder patientIdentifier(TokenParam patientIdentifier) {
            this.patientIdentifier = patientIdentifier;
            return this;
        }

        @Generated
        public Iti67SearchParametersBuilder date(DateRangeParam date) {
            this.date = date;
            return this;
        }

        @Generated
        public Iti67SearchParametersBuilder authorFamilyName(StringParam authorFamilyName) {
            this.authorFamilyName = authorFamilyName;
            return this;
        }

        @Generated
        public Iti67SearchParametersBuilder authorGivenName(StringParam authorGivenName) {
            this.authorGivenName = authorGivenName;
            return this;
        }

        @Generated
        public Iti67SearchParametersBuilder authorIdentifier(TokenParam authorIdentifier) {
            this.authorIdentifier = authorIdentifier;
            return this;
        }

        @Generated
        public Iti67SearchParametersBuilder identifier(TokenParam identifier) {
            this.identifier = identifier;
            return this;
        }

        @Generated
        public Iti67SearchParametersBuilder status(TokenOrListParam status) {
            this.status = status;
            return this;
        }

        @Generated
        public Iti67SearchParametersBuilder category(TokenOrListParam category) {
            this.category = category;
            return this;
        }

        @Generated
        public Iti67SearchParametersBuilder type(TokenOrListParam type) {
            this.type = type;
            return this;
        }

        @Generated
        public Iti67SearchParametersBuilder setting(TokenOrListParam setting) {
            this.setting = setting;
            return this;
        }

        @Generated
        public Iti67SearchParametersBuilder period(DateRangeParam period) {
            this.period = period;
            return this;
        }

        @Generated
        public Iti67SearchParametersBuilder facility(TokenOrListParam facility) {
            this.facility = facility;
            return this;
        }

        @Generated
        public Iti67SearchParametersBuilder event(TokenOrListParam event) {
            this.event = event;
            return this;
        }

        @Generated
        public Iti67SearchParametersBuilder securityLabel(TokenOrListParam securityLabel) {
            this.securityLabel = securityLabel;
            return this;
        }

        @Generated
        public Iti67SearchParametersBuilder format(TokenOrListParam format) {
            this.format = format;
            return this;
        }

        @Generated
        public Iti67SearchParametersBuilder related(ReferenceOrListParam related) {
            this.related = related;
            return this;
        }

        @Generated
        public Iti67SearchParametersBuilder relatedId(TokenOrListParam relatedId) {
            this.relatedId = relatedId;
            return this;
        }

        @Generated
        public Iti67SearchParametersBuilder _id(TokenParam _id) {
            this._id = _id;
            return this;
        }

        @Generated
        public Iti67SearchParametersBuilder sortSpec(SortSpec sortSpec) {
            this.sortSpec = sortSpec;
            return this;
        }

        @Generated
        public Iti67SearchParametersBuilder includeSpec(Set<Include> includeSpec) {
            this.includeSpec = includeSpec;
            return this;
        }

        @Generated
        public Iti67SearchParametersBuilder fhirContext(FhirContext fhirContext) {
            this.fhirContext = fhirContext;
            return this;
        }

        @Generated
        public Iti67SearchParameters build() {
            return new Iti67SearchParameters(this.patientReference, this.patientIdentifier, this.date, this.authorFamilyName, this.authorGivenName, this.authorIdentifier, this.identifier, this.status, this.category, this.type, this.setting, this.period, this.facility, this.event, this.securityLabel, this.format, this.related, this.relatedId, this._id, this.sortSpec, this.includeSpec, this.fhirContext);
        }

        @Generated
        public String toString() {
            return "Iti67SearchParameters.Iti67SearchParametersBuilder(patientReference=" + this.patientReference + ", patientIdentifier=" + this.patientIdentifier + ", date=" + this.date + ", authorFamilyName=" + this.authorFamilyName + ", authorGivenName=" + this.authorGivenName + ", authorIdentifier=" + this.authorIdentifier + ", identifier=" + this.identifier + ", status=" + this.status + ", category=" + this.category + ", type=" + this.type + ", setting=" + this.setting + ", period=" + this.period + ", facility=" + this.facility + ", event=" + this.event + ", securityLabel=" + this.securityLabel + ", format=" + this.format + ", related=" + this.related + ", relatedId=" + this.relatedId + ", _id=" + this._id + ", sortSpec=" + this.sortSpec + ", includeSpec=" + this.includeSpec + ", fhirContext=" + this.fhirContext + ")";
        }
    }
}

