/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.iti65;

import lombok.Generated;
import org.hl7.fhir.r4.model.DocumentManifest;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Reference;
import org.openehealth.ipf.commons.ihe.fhir.audit.FhirAuditDataset;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.SubmissionSetList;

public class Iti65AuditDataset
extends FhirAuditDataset {
    private String submissionSetUuid;

    public Iti65AuditDataset(boolean serverSide) {
        super(serverSide);
    }

    public void enrichDatasetFromDocumentManifest(DocumentManifest documentManifest) {
        Reference reference = documentManifest.getSubject();
        this.getPatientIds().add(reference.getResource() != null ? reference.getResource().getIdElement().getValue() : reference.getReference());
        if (!documentManifest.getIdentifier().isEmpty()) {
            this.submissionSetUuid = ((Identifier)documentManifest.getIdentifier().get(0)).getValue();
        }
    }

    public void enrichDatasetFromSubmissionSetList(SubmissionSetList<?> submissionSetList) {
        Reference reference = submissionSetList.getSubject();
        this.getPatientIds().add(reference.getResource() != null ? reference.getResource().getIdElement().getValue() : reference.getReference());
        if (!submissionSetList.getIdentifier().isEmpty()) {
            this.submissionSetUuid = ((Identifier)submissionSetList.getIdentifier().get(0)).getValue();
        }
    }

    @Generated
    public String getSubmissionSetUuid() {
        return this.submissionSetUuid;
    }

    @Generated
    public void setSubmissionSetUuid(String submissionSetUuid) {
        this.submissionSetUuid = submissionSetUuid;
    }
}

