/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.pharm5;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.ResourceType;
import org.openehealth.ipf.commons.ihe.fhir.AbstractPlainProvider;
import org.openehealth.ipf.commons.ihe.fhir.FhirSearchParameters;
import org.openehealth.ipf.commons.ihe.fhir.pharm5.Pharm5Operations;
import org.openehealth.ipf.commons.ihe.fhir.pharm5.Pharm5SearchParameters;

public class Pharm5ResourceProvider
extends AbstractPlainProvider {
    public static final String SP_PATIENT_IDENTIFIER = "patient.identifier";
    public static final String SP_AUTHOR_FAMILY = "author.family";
    public static final String SP_AUTHOR_GIVEN = "author.given";

    @Operation(name="$find-medication-treatment-plans", type=DocumentReference.class, idempotent=true, bundleType=BundleTypeEnum.SEARCHSET)
    public IBundleProvider findMedicationTreatmentPlans(@OperationParam(name="patient.identifier", min=1, max=1) TokenParam patient, @OperationParam(name="status", min=1, max=2) TokenOrListParam status, @OperationParam(name="identifier") TokenParam identifier, @OperationParam(name="setting") TokenOrListParam setting, @OperationParam(name="date") DateRangeParam date, @OperationParam(name="period") DateRangeParam period, @OperationParam(name="format") TokenOrListParam format, @OperationParam(name="facility") TokenOrListParam facility, @OperationParam(name="event") TokenOrListParam event, @OperationParam(name="security-label") TokenOrListParam securityLabel, @OperationParam(name="author.family") StringParam authorFamily, @OperationParam(name="author.given") StringParam authorGiven, @Sort SortSpec sortSpec, @IncludeParam Set<Include> includeSpec, RequestDetails requestDetails, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.stableSearch(patient, identifier, setting, date, period, format, facility, event, securityLabel, authorFamily, authorGiven, status, sortSpec, includeSpec, requestDetails, httpServletRequest, httpServletResponse, Pharm5Operations.FIND_MEDICATION_TREATMENT_PLANS);
    }

    @Operation(name="$find-prescriptions", type=DocumentReference.class, idempotent=true, bundleType=BundleTypeEnum.SEARCHSET)
    public IBundleProvider findPrescriptions(@OperationParam(name="patient.identifier", min=1, max=1) TokenParam patient, @OperationParam(name="status", min=1, max=2) TokenOrListParam status, @OperationParam(name="identifier") TokenParam identifier, @OperationParam(name="setting") TokenOrListParam setting, @OperationParam(name="date") DateRangeParam date, @OperationParam(name="period") DateRangeParam period, @OperationParam(name="format") TokenOrListParam format, @OperationParam(name="facility") TokenOrListParam facility, @OperationParam(name="event") TokenOrListParam event, @OperationParam(name="security-label") TokenOrListParam securityLabel, @OperationParam(name="author.family") StringParam authorFamily, @OperationParam(name="author.given") StringParam authorGiven, @Sort SortSpec sortSpec, @IncludeParam Set<Include> includeSpec, RequestDetails requestDetails, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.stableSearch(patient, identifier, setting, date, period, format, facility, event, securityLabel, authorFamily, authorGiven, status, sortSpec, includeSpec, requestDetails, httpServletRequest, httpServletResponse, Pharm5Operations.FIND_PRESCRIPTIONS);
    }

    @Operation(name="$find-dispenses", type=DocumentReference.class, idempotent=true, bundleType=BundleTypeEnum.SEARCHSET)
    public IBundleProvider findDispenses(@OperationParam(name="patient.identifier", min=1, max=1) TokenParam patient, @OperationParam(name="status", min=1, max=2) TokenOrListParam status, @OperationParam(name="identifier") TokenParam identifier, @OperationParam(name="setting") TokenOrListParam setting, @OperationParam(name="date") DateRangeParam date, @OperationParam(name="period") DateRangeParam period, @OperationParam(name="format") TokenOrListParam format, @OperationParam(name="facility") TokenOrListParam facility, @OperationParam(name="event") TokenOrListParam event, @OperationParam(name="security-label") TokenOrListParam securityLabel, @OperationParam(name="author.family") StringParam authorFamily, @OperationParam(name="author.given") StringParam authorGiven, @Sort SortSpec sortSpec, @IncludeParam Set<Include> includeSpec, RequestDetails requestDetails, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.stableSearch(patient, identifier, setting, date, period, format, facility, event, securityLabel, authorFamily, authorGiven, status, sortSpec, includeSpec, requestDetails, httpServletRequest, httpServletResponse, Pharm5Operations.FIND_DISPENSES);
    }

    @Operation(name="$find-medication-administrations", type=DocumentReference.class, idempotent=true, bundleType=BundleTypeEnum.SEARCHSET)
    public IBundleProvider findMedicationAdministrations(@OperationParam(name="patient.identifier", min=1, max=1) TokenParam patient, @OperationParam(name="status", min=1, max=2) TokenOrListParam status, @OperationParam(name="identifier") TokenParam identifier, @OperationParam(name="setting") TokenOrListParam setting, @OperationParam(name="date") DateRangeParam date, @OperationParam(name="period") DateRangeParam period, @OperationParam(name="format") TokenOrListParam format, @OperationParam(name="facility") TokenOrListParam facility, @OperationParam(name="event") TokenOrListParam event, @OperationParam(name="security-label") TokenOrListParam securityLabel, @OperationParam(name="author.family") StringParam authorFamily, @OperationParam(name="author.given") StringParam authorGiven, @Sort SortSpec sortSpec, @IncludeParam Set<Include> includeSpec, RequestDetails requestDetails, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.stableSearch(patient, identifier, setting, date, period, format, facility, event, securityLabel, authorFamily, authorGiven, status, sortSpec, includeSpec, requestDetails, httpServletRequest, httpServletResponse, Pharm5Operations.FIND_MEDICATION_ADMINISTRATIONS);
    }

    @Operation(name="$find-prescriptions-for-validation", type=DocumentReference.class, idempotent=true, bundleType=BundleTypeEnum.SEARCHSET)
    public IBundleProvider findPrescriptionsForValidation(@OperationParam(name="patient.identifier", min=1, max=1) TokenParam patient, @OperationParam(name="status", min=1, max=2) TokenOrListParam status, @OperationParam(name="identifier") TokenParam identifier, @OperationParam(name="setting") TokenOrListParam setting, @OperationParam(name="date") DateRangeParam date, @OperationParam(name="period") DateRangeParam period, @OperationParam(name="format") TokenOrListParam format, @OperationParam(name="facility") TokenOrListParam facility, @OperationParam(name="event") TokenOrListParam event, @OperationParam(name="security-label") TokenOrListParam securityLabel, @OperationParam(name="author.family") StringParam authorFamily, @OperationParam(name="author.given") StringParam authorGiven, @Sort SortSpec sortSpec, @IncludeParam Set<Include> includeSpec, RequestDetails requestDetails, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.stableSearch(patient, identifier, setting, date, period, format, facility, event, securityLabel, authorFamily, authorGiven, status, sortSpec, includeSpec, requestDetails, httpServletRequest, httpServletResponse, Pharm5Operations.FIND_PRESCRIPTIONS_FOR_VALIDATION);
    }

    @Operation(name="$find-prescriptions-for-dispense", type=DocumentReference.class, idempotent=true, bundleType=BundleTypeEnum.SEARCHSET)
    public IBundleProvider findPrescriptionsForDispense(@OperationParam(name="patient.identifier", min=1, max=1) TokenParam patient, @OperationParam(name="status", min=1, max=2) TokenOrListParam status, @OperationParam(name="identifier") TokenParam identifier, @OperationParam(name="setting") TokenOrListParam setting, @OperationParam(name="date") DateRangeParam date, @OperationParam(name="period") DateRangeParam period, @OperationParam(name="format") TokenOrListParam format, @OperationParam(name="facility") TokenOrListParam facility, @OperationParam(name="event") TokenOrListParam event, @OperationParam(name="security-label") TokenOrListParam securityLabel, @OperationParam(name="author.family") StringParam authorFamily, @OperationParam(name="author.given") StringParam authorGiven, @Sort SortSpec sortSpec, @IncludeParam Set<Include> includeSpec, RequestDetails requestDetails, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.stableSearch(patient, identifier, setting, date, period, format, facility, event, securityLabel, authorFamily, authorGiven, status, sortSpec, includeSpec, requestDetails, httpServletRequest, httpServletResponse, Pharm5Operations.FIND_PRESCRIPTIONS_FOR_DISPENSE);
    }

    @Operation(name="$find-medication-list", type=DocumentReference.class, idempotent=true, bundleType=BundleTypeEnum.SEARCHSET)
    public IBundleProvider findMedicationList(@OperationParam(name="patient.identifier", min=1, max=1) TokenParam patient, @OperationParam(name="status", min=1, max=2) TokenOrListParam status, @OperationParam(name="period") DateRangeParam period, @OperationParam(name="format") TokenOrListParam format, @Sort SortSpec sortSpec, @IncludeParam Set<Include> includeSpec, RequestDetails requestDetails, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Pharm5SearchParameters searchParameters = Pharm5SearchParameters.builder().status(status).period(period).format(format).patientIdentifier(patient).sortSpec(sortSpec).includeSpec(includeSpec).fhirContext(this.getFhirContext()).operation(Pharm5Operations.FIND_MEDICATION_LIST).build();
        return this.requestBundleProvider(null, (FhirSearchParameters)searchParameters, ResourceType.DocumentReference.name(), httpServletRequest, httpServletResponse, requestDetails);
    }

    IBundleProvider stableSearch(TokenParam patient, TokenParam identifier, TokenOrListParam setting, DateRangeParam date, DateRangeParam period, TokenOrListParam format, TokenOrListParam facility, TokenOrListParam event, TokenOrListParam securityLabel, StringParam authorFamily, StringParam authorGiven, TokenOrListParam status, SortSpec sortSpec, Set<Include> includeSpec, RequestDetails requestDetails, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Pharm5Operations operation) {
        Pharm5SearchParameters searchParameters = Pharm5SearchParameters.builder().patientIdentifier(patient).status(status).identifier(identifier).setting(setting).date(date).period(period).facility(facility).event(event).securityLabel(securityLabel).format(format).authorFamilyName(authorFamily).authorGivenName(authorGiven).sortSpec(sortSpec).includeSpec(includeSpec).fhirContext(this.getFhirContext()).operation(operation).build();
        return this.requestBundleProvider(null, (FhirSearchParameters)searchParameters, ResourceType.DocumentReference.name(), httpServletRequest, httpServletResponse, requestDetails);
    }
}

