/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.mhd.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.Extension;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.ListResource;
import org.hl7.fhir.r4.model.Resource;
import org.openehealth.ipf.commons.ihe.fhir.mhd.Mhd421;
import org.openehealth.ipf.commons.ihe.fhir.mhd.MhdProfile;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.EntryUuidIdentifier;

@ResourceDef(name="List", id="mhdList", profile="https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.List")
public class MhdList<T extends MhdList<T>>
extends ListResource
implements Mhd421 {
    @Child(name="designationType")
    @Extension(url="https://profiles.ihe.net/ITI/MHD/StructureDefinition/ihe-designationType", definedLocally=false)
    @Description(shortDefinition="Clinical code of the List")
    private List<CodeableConcept> designationType;

    public MhdList() {
        this.setDate(new Date());
        this.setStatus(ListResource.ListStatus.CURRENT);
        this.setMode(ListResource.ListMode.WORKING);
        MhdProfile.MHD_LIST.setProfile((Resource)this);
    }

    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.designationType);
    }

    public List<CodeableConcept> getDesignationType() {
        if (this.designationType == null) {
            this.designationType = new ArrayList<CodeableConcept>();
        }
        return this.designationType;
    }

    public CodeableConcept addDesignationType() {
        CodeableConcept codeableConcept = new CodeableConcept();
        this.addDesignationType(codeableConcept);
        return codeableConcept;
    }

    public T addDesignationType(CodeableConcept codeableConcept) {
        if (codeableConcept != null) {
            if (this.designationType == null) {
                this.designationType = new ArrayList<CodeableConcept>();
            }
            this.designationType.add(codeableConcept);
        }
        return (T)this;
    }

    public CodeableConcept getDesignationTypeFirstRep() {
        if (this.getDesignationType().isEmpty()) {
            this.addDesignationType();
        }
        return this.getDesignationType().get(0);
    }

    public boolean hasDesignationType() {
        if (this.designationType == null) {
            return false;
        }
        for (CodeableConcept item : this.designationType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public T setEntryUuidIdentifier(UUID uuid) {
        this.getIdentifier().add(new EntryUuidIdentifier(uuid));
        return (T)this;
    }

    public void copyValues(ListResource dst) {
        super.copyValues(dst);
        MhdList mhdList = (MhdList)dst;
        if (this.designationType != null) {
            mhdList.designationType = new ArrayList<CodeableConcept>();
            for (CodeableConcept i : this.designationType) {
                mhdList.designationType.add(i.copy());
            }
        }
    }

    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MhdList)) {
            return false;
        }
        MhdList o = (MhdList)other_;
        return MhdList.compareDeep(this.designationType, o.designationType, (boolean)true);
    }
}

