/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.mhd.model;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.util.List;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.openehealth.ipf.commons.ihe.fhir.mhd.Mhd421;
import org.openehealth.ipf.commons.ihe.fhir.mhd.MhdProfile;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.AbstractProvideDocumentBundle;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.ComprehensiveDocumentReference;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.ComprehensiveSubmissionSetList;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.FolderList;
import org.openehealth.ipf.commons.ihe.fhir.support.FhirUtils;

@ResourceDef(name="Bundle", id="mhdComprehensiveProvideDocumentBundle", profile="https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Comprehensive.ProvideBundle")
public class ComprehensiveProvideDocumentBundle
extends AbstractProvideDocumentBundle<ComprehensiveProvideDocumentBundle>
implements Mhd421 {
    public ComprehensiveProvideDocumentBundle() {
        this.setType(Bundle.BundleType.TRANSACTION);
        MhdProfile.ITI65_COMPREHENSIVE_BUNDLE.setProfile((Resource)this);
    }

    public ComprehensiveProvideDocumentBundle addSubmissionSetList(String fullUrl, ComprehensiveSubmissionSetList submissionSetList) {
        if (FhirUtils.getOptionalResource((Bundle)this, ComprehensiveSubmissionSetList.class).isPresent()) {
            throw new RuntimeException("Already added SubmissionSet List");
        }
        return (ComprehensiveProvideDocumentBundle)this.addEntry(fullUrl, (Resource)submissionSetList);
    }

    public ComprehensiveProvideDocumentBundle addDocumentReference(String fullUrl, ComprehensiveDocumentReference documentReference) {
        return (ComprehensiveProvideDocumentBundle)this.addEntry(fullUrl, (Resource)documentReference);
    }

    public ComprehensiveSubmissionSetList getSubmissionSet() {
        return (ComprehensiveSubmissionSetList)FhirUtils.getResource((Bundle)this, ComprehensiveSubmissionSetList.class);
    }

    public List<ComprehensiveDocumentReference> getDocumentReferences() {
        return FhirUtils.getResources((Bundle)this, ComprehensiveDocumentReference.class);
    }

    public List<Binary> getBinaries() {
        return FhirUtils.getResources((Bundle)this, Binary.class);
    }

    public List<FolderList> getFolders() {
        return FhirUtils.getResources((Bundle)this, FolderList.class);
    }

    public ComprehensiveProvideDocumentBundle copy() {
        ComprehensiveProvideDocumentBundle dst = new ComprehensiveProvideDocumentBundle();
        this.copyValues(dst);
        return dst;
    }
}

