/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.mhd;

import ca.uhn.fhir.context.FhirContext;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Resource;
import org.openehealth.ipf.commons.ihe.fhir.mhd.Mhd421;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.ComprehensiveDocumentReference;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.ComprehensiveFolderList;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.ComprehensiveProvideDocumentBundle;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.ComprehensiveSubmissionSetList;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.DocumentReferencePatchParameters;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.EntryUuidIdentifier;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.FindComprehensiveDocumentReferencesResponseBundle;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.FindDocumentListsResponseBundle;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.FindMinimalDocumentReferencesResponseBundle;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.GenerateMetadataInParameters;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.GenerateMetadataOutParameters;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.MhdList;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.MinimalDocumentReference;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.MinimalFolderList;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.MinimalProvideDocumentBundle;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.MinimalSubmissionSetList;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.ProvideDocumentBundleResponse;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.SimplifiedPublishDocumentReference;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.SubmissionSetUniqueIdIdentifier;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.UncontainedComprehensiveDocumentReference;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.UncontainedComprehensiveProvideDocumentBundle;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.UniqueIdIdentifier;

public enum MhdProfile implements Mhd421
{
    ITI65_MINIMAL_BUNDLE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Minimal.ProvideBundle", MinimalProvideDocumentBundle.class, "IHE.MHD.Minimal.ProvideBundle"),
    ITI65_COMPREHENSIVE_BUNDLE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Comprehensive.ProvideBundle", ComprehensiveProvideDocumentBundle.class, "IHE.MHD.Comprehensive.ProvideBundle"),
    ITI65_UNCONTAINED_COMPREHENSIVE_BUNDLE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.UnContained.Comprehensive.ProvideBundle", UncontainedComprehensiveProvideDocumentBundle.class, "IHE.MHD.UnContained.Comprehensive.ProvideBundle"),
    ITI65_PROVIDE_DOCUMENT_BUNDLE_RESPONSE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.ProvideDocumentBundleResponse", ProvideDocumentBundleResponse.class, "IHE.MHD.ProvideDocumentBundleResponse"),
    ITI66_FIND_DOCUMENT_LISTS_RESPONSE_BUNDLE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.FindDocumentListsResponseMessage", FindDocumentListsResponseBundle.class, "IHE.MHD.FindDocumentListsResponseMessage"),
    ITI67_FIND_DOCUMENT_REFERENCES_RESPONSE_BUNDLE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.FindDocumentReferencesResponseMessage", FindMinimalDocumentReferencesResponseBundle.class, "IHE.MHD.FindDocumentReferencesResponseMessage"),
    ITI67_FIND_DOCUMENT_REFERENCES_COMPREHENSIVE_RESPONSE_BUNDLE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.FindDocumentReferencesComprehensiveResponseMessage", FindComprehensiveDocumentReferencesResponseBundle.class, "IHE.MHD.FindDocumentReferencesComprehensiveResponseMessage"),
    MHD_LIST("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.List", MhdList.class, "IHE.MHD.List"),
    COMPREHENSIVE_SUBMISSIONSET_TYPE_LIST("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Comprehensive.SubmissionSet", ComprehensiveSubmissionSetList.class, "IHE.MHD.Comprehensive.SubmissionSet"),
    UNCONTAINED_COMPREHENSIVE_SUBMISSIONSET_TYPE_LIST("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.UnContained.Comprehensive.SubmissionSet", UncontainedComprehensiveProvideDocumentBundle.class, "IHE.MHD.UnContained.Comprehensive.SubmissionSet"),
    MINIMAL_SUBMISSIONSET_TYPE_LIST("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Minimal.SubmissionSet", MinimalSubmissionSetList.class, "IHE.MHD.Minimal.SubmissionSet"),
    MINIMAL_FOLDER_TYPE_LIST("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Minimal.Folder", MinimalFolderList.class, "IHE.MHD.Minimal.Folder"),
    COMPREHENSIVE_FOLDER_TYPE_LIST("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Comprehensive.Folder", ComprehensiveFolderList.class, "IHE.MHD.Comprehensive.Folder"),
    COMPREHENSIVE_DOCUMENT_REFERENCE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Comprehensive.DocumentReference", ComprehensiveDocumentReference.class, "IHE.MHD.Comprehensive.DocumentReference"),
    UNCONTAINED_COMPREHENSIVE_DOCUMENT_REFERENCE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.UnContained.Comprehensive.DocumentReference", UncontainedComprehensiveDocumentReference.class, "IHE.MHD.UnContained.Comprehensive.DocumentReference"),
    MINIMAL_DOCUMENT_REFERENCE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Minimal.DocumentReference", MinimalDocumentReference.class, "IHE.MHD.Minimal.DocumentReference"),
    SIMPLIFIED_PUBLISH_DOCUMENT_REFERENCE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.SimplifiedPublish.DocumentReference", SimplifiedPublishDocumentReference.class, "IHE.MHD.SimplifiedPublish.DocumentReference"),
    DOCUMENT_REFERENCE_PATCH_PARAMETERS("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Patch.Parameters", DocumentReferencePatchParameters.class, "IHE.MHD.Patch.Parameters"),
    GENERATE_METADATA_PARAMETERS_IN("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.GenerateMetadata.Parameters.In", GenerateMetadataInParameters.class, "IHE.MHD.GenerateMetadata.Parameters.In"),
    GENERATE_METADATA_PARAMETERS_OUT("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.GenerateMetadata.Parameters.Out", GenerateMetadataOutParameters.class, "IHE.MHD.GenerateMetadata.Parameters.Out"),
    DESIGNATION_TYPE("https://profiles.ihe.net/ITI/MHD/StructureDefinition/ihe-designationType", null, "ihe-designationType"),
    AUTHOR_ORG("https://profiles.ihe.net/ITI/MHD/StructureDefinition/ihe-authorOrg", null, "ihe-authorOrg"),
    INTENDED_RECIPIENT("https://profiles.ihe.net/ITI/MHD/StructureDefinition/ihe-intendedRecipient", null, "ihe-intendedRecipient"),
    SOURCE_ID("https://profiles.ihe.net/ITI/MHD/StructureDefinition/ihe-sourceId", null, "ihe-sourceId"),
    SUBMISSIONSET_UNIQUE_IDENTIFIER("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.SubmissionSetUniqueIdIdentifier", null, "IHE.MHD.SubmissionSetUniqueIdIdentifier"),
    UNIQUE_ID_IDENTIFIER("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.UniqueIdIdentifier", null, "IHE.MHD.UniqueIdIdentifier"),
    ENTRY_UUID_IDENTIFIER("https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.EntryUUID.Identifier", null, "IHE.MHD.EntryUUID.Identifier");

    public static final String ITI65_MINIMAL_BUNDLE_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Minimal.ProvideBundle";
    public static final String ITI65_COMPREHENSIVE_BUNDLE_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Comprehensive.ProvideBundle";
    public static final String ITI65_UNCONTAINED_COMPREHENSIVE_BUNDLE_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.UnContained.Comprehensive.ProvideBundle";
    public static final String ITI65_PROVIDE_DOCUMENT_BUNDLE_RESPONSE_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.ProvideDocumentBundleResponse";
    public static final String ITI66_FIND_DOCUMENT_LISTS_RESPONSE_BUNDLE_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.FindDocumentListsResponseMessage";
    public static final String ITI67_FIND_DOCUMENT_REFERENCES_RESPONSE_BUNDLE_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.FindDocumentReferencesResponseMessage";
    public static final String ITI67_FIND_DOCUMENT_REFERENCES_COMPREHENSIVE_RESPONSE_BUNDLE_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.FindDocumentReferencesComprehensiveResponseMessage";
    public static final String MHD_LIST_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.List";
    public static final String COMPREHENSIVE_SUBMISSIONSET_TYPE_LIST_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Comprehensive.SubmissionSet";
    public static final String UNCONTAINED_COMPREHENSIVE_SUBMISSIONSET_TYPE_LIST_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.UnContained.Comprehensive.SubmissionSet";
    public static final String MINIMAL_SUBMISSIONSET_TYPE_LIST_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Minimal.SubmissionSet";
    public static final String MINIMAL_FOLDER_TYPE_LIST_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Minimal.Folder";
    public static final String COMPREHENSIVE_FOLDER_TYPE_LIST_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Comprehensive.Folder";
    public static final String COMPREHENSIVE_DOCUMENT_REFERENCE_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Comprehensive.DocumentReference";
    public static final String UNCONTAINED_COMPREHENSIVE_DOCUMENT_REFERENCE_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.UnContained.Comprehensive.DocumentReference";
    public static final String MINIMAL_DOCUMENT_REFERENCE_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Minimal.DocumentReference";
    public static final String SIMPLIFIED_PUBLISH_DOCUMENT_REFERENCE_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.SimplifiedPublish.DocumentReference";
    public static final String DOCUMENT_REFERENCE_PATCH_PARAMETERS_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Patch.Parameters";
    public static final String GENERATE_METADATA_PARAMETERS_IN_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.GenerateMetadata.Parameters.In";
    public static final String GENERATE_METADATA_PARAMETERS_OUT_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.GenerateMetadata.Parameters.Out";
    public static final String DESIGNATION_TYPE_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/ihe-designationType";
    public static final String AUTHOR_ORG_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/ihe-authorOrg";
    public static final String INTENDED_RECIPIENT_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/ihe-intendedRecipient";
    public static final String SOURCE_ID_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/ihe-sourceId";
    public static final String SUBMISSIONSET_UNIQUE_IDENTIFIER_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.SubmissionSetUniqueIdIdentifier";
    public static final String UNIQUE_ID_IDENTIFIER_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.UniqueIdIdentifier";
    public static final String ENTRY_UUID_IDENTIFIER_PROFILE = "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.EntryUUID.Identifier";
    private final String url;
    private final Class<? extends IBaseResource> resourceClass;
    private final String structureDefinitionName;

    private MhdProfile(String url, Class<? extends IBaseResource> resourceClass, String structureDefinitionName) {
        this.url = url;
        this.resourceClass = resourceClass;
        this.structureDefinitionName = structureDefinitionName;
    }

    public void setProfile(Resource resource) {
        resource.getMeta().setProfile(List.of(new CanonicalType(this.url)));
    }

    public boolean hasProfile(Resource resource) {
        return resource.getMeta().hasProfile(this.url);
    }

    public String getStructureDefinitionResourceName() {
        return "StructureDefinition-" + this.structureDefinitionName + ".xml";
    }

    public static void registerDefaultTypes(FhirContext fhirContext) {
        Arrays.stream(MhdProfile.values()).filter(profile -> profile.resourceClass != null).forEach(profile -> fhirContext.setDefaultTypeForProfile(profile.url, profile.resourceClass));
        fhirContext.registerCustomTypes(Arrays.asList(EntryUuidIdentifier.class, SubmissionSetUniqueIdIdentifier.class, UniqueIdIdentifier.class));
    }

    public static Optional<MhdProfile> profileForResource(IBaseResource resource) {
        return resource.getMeta().getProfile().stream().map(IPrimitiveType::getValue).findFirst().flatMap(MhdProfile::profileForUrl);
    }

    public static Optional<MhdProfile> profileForUrl(String url) {
        return Arrays.stream(MhdProfile.values()).filter(p -> p.url.equalsIgnoreCase(url)).findFirst();
    }

    public String getUrl() {
        return this.url;
    }

    public String getStructureDefinitionName() {
        return this.structureDefinitionName;
    }
}

