/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.iti66;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.r4.model.ListResource;
import org.openehealth.ipf.commons.ihe.fhir.iti66.Iti66SearchParameters;

public class Iti66ListSearchParameters
extends Iti66SearchParameters<ListResource> {
    private DateRangeParam date;
    private TokenOrListParam code;
    private TokenOrListParam designationType;
    private TokenOrListParam sourceId;
    private TokenOrListParam status;
    private TokenParam identifier;
    private TokenParam _id;
    private ReferenceParam patientReference;
    private TokenParam patientIdentifier;
    private StringParam authorFamilyName;
    private StringParam authorGivenName;
    private SortSpec sortSpec;
    private Set<Include> includeSpec;
    private final FhirContext fhirContext;
    private static final Comparator<ListResource> CP_DATE = Comparator.nullsLast(Comparator.comparing(ListResource::getDate));

    public Iti66ListSearchParameters setAuthor(ReferenceAndListParam author) {
        if (author != null) {
            author.getValuesAsQueryTokens().forEach(param -> {
                ReferenceParam ref = (ReferenceParam)param.getValuesAsQueryTokens().get(0);
                String authorChain = ref.getChain();
                if ("family".equals(authorChain)) {
                    this.setAuthorFamilyName(ref.toStringParam(this.getFhirContext()));
                } else if ("given".equals(authorChain)) {
                    this.setAuthorGivenName(ref.toStringParam(this.getFhirContext()));
                }
            });
        }
        return this;
    }

    public List<TokenParam> getPatientIdParam() {
        if (this._id != null) {
            return Collections.singletonList(this._id);
        }
        if (this.patientReference != null) {
            return Collections.singletonList(this.patientReference.toTokenParam(this.fhirContext));
        }
        return Collections.singletonList(this.patientIdentifier);
    }

    public Optional<Comparator<ListResource>> comparatorFor(String paramName) {
        if ("date".equals(paramName)) {
            return Optional.of(CP_DATE);
        }
        return Optional.empty();
    }

    Iti66ListSearchParameters(DateRangeParam date, TokenOrListParam code, TokenOrListParam designationType, TokenOrListParam sourceId, TokenOrListParam status, TokenParam identifier, TokenParam _id, ReferenceParam patientReference, TokenParam patientIdentifier, StringParam authorFamilyName, StringParam authorGivenName, SortSpec sortSpec, Set<Include> includeSpec, FhirContext fhirContext) {
        this.date = date;
        this.code = code;
        this.designationType = designationType;
        this.sourceId = sourceId;
        this.status = status;
        this.identifier = identifier;
        this._id = _id;
        this.patientReference = patientReference;
        this.patientIdentifier = patientIdentifier;
        this.authorFamilyName = authorFamilyName;
        this.authorGivenName = authorGivenName;
        this.sortSpec = sortSpec;
        this.includeSpec = includeSpec;
        this.fhirContext = fhirContext;
    }

    public static Iti66ListSearchParametersBuilder builder() {
        return new Iti66ListSearchParametersBuilder();
    }

    public String toString() {
        return "Iti66ListSearchParameters(date=" + this.getDate() + ", code=" + this.getCode() + ", designationType=" + this.getDesignationType() + ", sourceId=" + this.getSourceId() + ", status=" + this.getStatus() + ", identifier=" + this.getIdentifier() + ", _id=" + this.get_id() + ", patientReference=" + this.getPatientReference() + ", patientIdentifier=" + this.getPatientIdentifier() + ", authorFamilyName=" + this.getAuthorFamilyName() + ", authorGivenName=" + this.getAuthorGivenName() + ", sortSpec=" + this.getSortSpec() + ", includeSpec=" + this.getIncludeSpec() + ", fhirContext=" + this.getFhirContext() + ")";
    }

    public DateRangeParam getDate() {
        return this.date;
    }

    public void setDate(DateRangeParam date) {
        this.date = date;
    }

    public TokenOrListParam getCode() {
        return this.code;
    }

    public void setCode(TokenOrListParam code) {
        this.code = code;
    }

    public TokenOrListParam getDesignationType() {
        return this.designationType;
    }

    public void setDesignationType(TokenOrListParam designationType) {
        this.designationType = designationType;
    }

    public TokenOrListParam getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(TokenOrListParam sourceId) {
        this.sourceId = sourceId;
    }

    public TokenOrListParam getStatus() {
        return this.status;
    }

    public void setStatus(TokenOrListParam status) {
        this.status = status;
    }

    public TokenParam getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(TokenParam identifier) {
        this.identifier = identifier;
    }

    public TokenParam get_id() {
        return this._id;
    }

    public void set_id(TokenParam _id) {
        this._id = _id;
    }

    public ReferenceParam getPatientReference() {
        return this.patientReference;
    }

    public void setPatientReference(ReferenceParam patientReference) {
        this.patientReference = patientReference;
    }

    public TokenParam getPatientIdentifier() {
        return this.patientIdentifier;
    }

    public void setPatientIdentifier(TokenParam patientIdentifier) {
        this.patientIdentifier = patientIdentifier;
    }

    public StringParam getAuthorFamilyName() {
        return this.authorFamilyName;
    }

    public void setAuthorFamilyName(StringParam authorFamilyName) {
        this.authorFamilyName = authorFamilyName;
    }

    public StringParam getAuthorGivenName() {
        return this.authorGivenName;
    }

    public void setAuthorGivenName(StringParam authorGivenName) {
        this.authorGivenName = authorGivenName;
    }

    public SortSpec getSortSpec() {
        return this.sortSpec;
    }

    public void setSortSpec(SortSpec sortSpec) {
        this.sortSpec = sortSpec;
    }

    public Set<Include> getIncludeSpec() {
        return this.includeSpec;
    }

    public void setIncludeSpec(Set<Include> includeSpec) {
        this.includeSpec = includeSpec;
    }

    @Override
    public FhirContext getFhirContext() {
        return this.fhirContext;
    }

    public static class Iti66ListSearchParametersBuilder {
        private DateRangeParam date;
        private TokenOrListParam code;
        private TokenOrListParam designationType;
        private TokenOrListParam sourceId;
        private TokenOrListParam status;
        private TokenParam identifier;
        private TokenParam _id;
        private ReferenceParam patientReference;
        private TokenParam patientIdentifier;
        private StringParam authorFamilyName;
        private StringParam authorGivenName;
        private SortSpec sortSpec;
        private Set<Include> includeSpec;
        private FhirContext fhirContext;

        Iti66ListSearchParametersBuilder() {
        }

        public Iti66ListSearchParametersBuilder date(DateRangeParam date) {
            this.date = date;
            return this;
        }

        public Iti66ListSearchParametersBuilder code(TokenOrListParam code) {
            this.code = code;
            return this;
        }

        public Iti66ListSearchParametersBuilder designationType(TokenOrListParam designationType) {
            this.designationType = designationType;
            return this;
        }

        public Iti66ListSearchParametersBuilder sourceId(TokenOrListParam sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public Iti66ListSearchParametersBuilder status(TokenOrListParam status) {
            this.status = status;
            return this;
        }

        public Iti66ListSearchParametersBuilder identifier(TokenParam identifier) {
            this.identifier = identifier;
            return this;
        }

        public Iti66ListSearchParametersBuilder _id(TokenParam _id) {
            this._id = _id;
            return this;
        }

        public Iti66ListSearchParametersBuilder patientReference(ReferenceParam patientReference) {
            this.patientReference = patientReference;
            return this;
        }

        public Iti66ListSearchParametersBuilder patientIdentifier(TokenParam patientIdentifier) {
            this.patientIdentifier = patientIdentifier;
            return this;
        }

        public Iti66ListSearchParametersBuilder authorFamilyName(StringParam authorFamilyName) {
            this.authorFamilyName = authorFamilyName;
            return this;
        }

        public Iti66ListSearchParametersBuilder authorGivenName(StringParam authorGivenName) {
            this.authorGivenName = authorGivenName;
            return this;
        }

        public Iti66ListSearchParametersBuilder sortSpec(SortSpec sortSpec) {
            this.sortSpec = sortSpec;
            return this;
        }

        public Iti66ListSearchParametersBuilder includeSpec(Set<Include> includeSpec) {
            this.includeSpec = includeSpec;
            return this;
        }

        public Iti66ListSearchParametersBuilder fhirContext(FhirContext fhirContext) {
            this.fhirContext = fhirContext;
            return this;
        }

        public Iti66ListSearchParameters build() {
            return new Iti66ListSearchParameters(this.date, this.code, this.designationType, this.sourceId, this.status, this.identifier, this._id, this.patientReference, this.patientIdentifier, this.authorFamilyName, this.authorGivenName, this.sortSpec, this.includeSpec, this.fhirContext);
        }

        public String toString() {
            return "Iti66ListSearchParameters.Iti66ListSearchParametersBuilder(date=" + this.date + ", code=" + this.code + ", designationType=" + this.designationType + ", sourceId=" + this.sourceId + ", status=" + this.status + ", identifier=" + this.identifier + ", _id=" + this._id + ", patientReference=" + this.patientReference + ", patientIdentifier=" + this.patientIdentifier + ", authorFamilyName=" + this.authorFamilyName + ", authorGivenName=" + this.authorGivenName + ", sortSpec=" + this.sortSpec + ", includeSpec=" + this.includeSpec + ", fhirContext=" + this.fhirContext + ")";
        }
    }
}

