/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.pharm5;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.util.UrlUtil;
import java.util.Set;
import org.hl7.fhir.r4.model.Parameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openehealth.ipf.commons.ihe.fhir.pharm5.Pharm5Operations;
import org.openehealth.ipf.commons.ihe.fhir.pharm5.Pharm5SearchParameters;

class Pharm5SearchParametersTest {
    Pharm5SearchParametersTest() {
    }

    @Test
    void testToParameters() {
        FhirContext fhirContext = FhirContext.forR4();
        Pharm5SearchParameters searchParameters = new Pharm5SearchParameters(new TokenParam("urn:oid:1.2.3", "1234"), new DateRangeParam(new DateParam(ParamPrefixEnum.GREATERTHAN, "2022-01-01"), new DateParam(ParamPrefixEnum.LESSTHAN, "2022-03-31")), new StringParam("Doe"), new StringParam("John"), new TokenParam("abc"), new TokenOrListParam(null, new String[]{"current"}), new TokenOrListParam("urn:oid:1.2.9", new String[]{"setting1", "setting2"}), new DateRangeParam(new DateParam(ParamPrefixEnum.GREATERTHAN, "2022-02-02"), new DateParam(ParamPrefixEnum.LESSTHAN, "2022-02-04")), new TokenOrListParam(null, new String[]{"fa"}), new TokenOrListParam(null, new String[]{"e"}), new TokenOrListParam(null, new String[]{"s"}), new TokenOrListParam(null, new String[]{"fo"}), Pharm5Operations.FIND_MEDICATION_ADMINISTRATIONS, new SortSpec("date", SortOrderEnum.ASC, new SortSpec("status", SortOrderEnum.DESC)), Set.of(new Include("Provenance:target:DocumentReference", true)), fhirContext);
        Assertions.assertEquals((Object)"patient.identifier=urn%3Aoid%3A1.2.3%7C1234&date=gt2022-01-01&date=lt2022-03-31&author.family=Doe&author.given=John&identifier=abc&status=current&setting=urn%3Aoid%3A1.2.9%7Csetting1%2Curn%3Aoid%3A1.2.9%7Csetting2&period=gt2022-02-02&period=lt2022-02-04&facility=fa&event=e&security-label=s&format=fo&_sort=date%2C-status&_include%3Aiterate=Provenance%3Atarget%3ADocumentReference", (Object)this.toQueryString(searchParameters.toParameters()));
    }

    private String toQueryString(Parameters parameters) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Parameters.ParametersParameterComponent param : parameters.getParameter()) {
            if (!first) {
                b.append('&');
            }
            b.append(UrlUtil.escapeUrlParam((String)param.getName()));
            b.append('=');
            b.append(UrlUtil.escapeUrlParam((String)param.getValue().primitiveValue()));
            first = false;
        }
        return b.toString();
    }
}

